/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.LinkChunkHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LinkChunk
extends Chunk {
    public LinkChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        byte[] buf = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ByteArrayXMPSource xs = new ByteArrayXMPSource(bais);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            LinkChunkHandler handler = new LinkChunkHandler();
            parser.setContentHandler(handler);
            parser.parse((InputSource)xs);
            List fileNames = handler.getFileNames();
            String id = handler.getID();
            if (!fileNames.isEmpty()) {
                ArrayList<Property> plist = new ArrayList<Property>(2);
                plist.add(new Property("FileNames", PropertyType.STRING, PropertyArity.LIST, (Object)fileNames));
                if (id != null) {
                    plist.add(new Property("ID", PropertyType.STRING, (Object)id));
                }
                module.addWaveProperty(new Property("Link", PropertyType.PROPERTY, PropertyArity.LIST, plist));
            }
        }
        catch (SAXException se) {
            info.setMessage((Message)new ErrorMessage("SAXException in reading Link Chunk"));
            info.setValid(false);
            return true;
        }
        catch (ParserConfigurationException pe) {
            info.setMessage((Message)new ErrorMessage("ParserConfigurationException in reading Link Chunk"));
            info.setValid(false);
            return true;
        }
        return true;
    }
}

