/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module;

import com.mcgath.jhove.module.png.IdatChunk;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PngModule
extends ModuleBase {
    private static final String NAME = "PNG-gdm";
    private static final String RELEASE = "1.0";
    private static final int[] DATE = new int[]{2016, 2, 25};
    private static final String[] FORMAT = new String[]{"PNG", " ISO/IEC 15948:2003", "Portable Network Graphics"};
    private static final String COVERAGE = "PNG (ISO/IEC 15948:2003)";
    private static final String[] MIMETYPE = new String[]{"image/png"};
    private static final String WELLFORMED = "Put well-formedness criteria here";
    private static final String VALIDITY = "Put validity criteria here";
    private static final String REPINFO = "Put repinfo note here";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2016 by Gary McGath. Released under the GNU Lesser General Public License.";
    private static final String NISO_IMAGE_MD = "NisoImageMetadata";
    protected Checksummer _ckSummer;
    protected List<Property> _propList;
    protected List<Property> _keywordPropList;
    protected List<Property> _spltList;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    NisoImageMetadata _nisoData;
    protected int _colorType;
    private Set<Integer> _ancillaryChunks;
    private boolean ihdrSeen;
    private boolean plteSeen;
    private boolean idatSeen;
    private boolean idatFinished;
    private boolean iendSeen;
    private static final int[] _sigBytes = new int[]{137, 80, 78, 71, 13, 10, 26, 10};

    public PngModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        InternalSignature sig = new InternalSignature(_sigBytes, SignatureType.MAGIC, SignatureUseType.MANDATORY, 0, "");
        this._signature.add(sig);
        sig = new ExternalSignature(".png", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
    }

    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        this._dstream = PngModule.getBufferedDataStream((InputStream)stream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        for (int i = 0; i < 8; ++i) {
            int ch;
            try {
                ch = PngModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            }
            catch (Exception e) {
                ch = -1;
            }
            if (ch == _sigBytes[i]) continue;
            info.setWellFormed(false);
            return;
        }
        info.setModule((Module)this);
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setSigMatch(this._name);
    }

    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        ErrorMessage msg;
        this.initParse();
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule((Module)this);
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().size() == 0) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(stream, this._ckSummer);
            this._dstream = PngModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = PngModule.getBufferedDataStream((InputStream)stream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        this._propList = new LinkedList<Property>();
        this._metadata = new Property("PNGMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._nisoData = new NisoImageMetadata();
        Property nisoProp = new Property(NISO_IMAGE_MD, PropertyType.NISOIMAGEMETADATA, (Object)this._nisoData);
        this._propList.add(nisoProp);
        this._keywordPropList = new LinkedList<Property>();
        this._spltList = new LinkedList<Property>();
        for (int i = 0; i < _sigBytes.length; ++i) {
            int byt = PngModule.readUnsignedByte((DataInputStream)this._dstream);
            if (byt == _sigBytes[i]) continue;
            ErrorMessage msg2 = new ErrorMessage("File header does not match PNG signature");
            info.setMessage((Message)msg2);
            info.setWellFormed(false);
            return 0;
        }
        try {
            PNGChunk chunk;
            while ((chunk = this.readChunkHead(this._dstream)) != null) {
                long calculatedCRC;
                if (this.iendSeen) {
                    ErrorMessage msg3 = new ErrorMessage("IEND chunk is not last");
                    info.setMessage((Message)msg3);
                    info.setWellFormed(false);
                    return 0;
                }
                if (this.idatSeen && !(chunk instanceof IdatChunk)) {
                    this.idatFinished = true;
                }
                chunk.setModule(this);
                chunk.setInputStream(this._dstream);
                chunk.setNisoMetadata(this._nisoData);
                chunk.setPropertyList(this._propList);
                chunk.processChunk(info);
                long storedCRC = chunk.readCRC();
                if (storedCRC == (calculatedCRC = chunk.getCRC())) continue;
                ErrorMessage msg4 = new ErrorMessage("Incorrect CRC in chunk " + chunk.chunkTypeString());
                info.setMessage((Message)msg4);
                info.setWellFormed(false);
                return 0;
            }
        }
        catch (PNGException e) {
            return 0;
        }
        catch (EOFException e) {
            ErrorMessage msg5 = new ErrorMessage("Unexpected end of file", this._nByte);
            info.setMessage((Message)msg5);
            info.setWellFormed(false);
            return 0;
        }
        catch (Exception e) {
            ErrorMessage msg6 = new ErrorMessage("Exception " + e.getClass().getName());
            info.setMessage((Message)msg6);
            info.setWellFormed(false);
            return 0;
        }
        boolean criticalMissing = false;
        if (!this.ihdrSeen) {
            msg = new ErrorMessage("No IHDR chunk");
            info.setMessage((Message)msg);
            criticalMissing = true;
        }
        if (!this.idatSeen) {
            msg = new ErrorMessage("No IDAT chunk");
            info.setMessage((Message)msg);
            criticalMissing = true;
        }
        if (!this.iendSeen) {
            msg = new ErrorMessage("No IEND chunk");
            info.setMessage((Message)msg);
            criticalMissing = true;
        }
        if (criticalMissing) {
            info.setWellFormed(false);
            return 0;
        }
        if (this._colorType == 3 && !this.plteSeen) {
            msg = new ErrorMessage("No PLTE chunk, required with color type 3");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            return 0;
        }
        if ((this._colorType == 0 || this._colorType == 4) && this.plteSeen) {
            msg = new ErrorMessage("PLTE chunk found, not allowed with color types 0 and 4");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            return 0;
        }
        if (!this._keywordPropList.isEmpty()) {
            this._propList.add(new Property("Keywords", PropertyType.PROPERTY, PropertyArity.LIST, this._keywordPropList));
        }
        if (!this._spltList.isEmpty()) {
            this._propList.add(new Property("Suggested palettes", PropertyType.PROPERTY, PropertyArity.LIST, this._spltList));
        }
        info.setProperty(this._metadata);
        return 0;
    }

    public void eatChunk(PNGChunk chnk) throws IOException {
        chnk.skipBytes((int)chnk.getLength());
    }

    public void addKeyword(String keywd, String val) {
        this.addKeyword(keywd, null, val, null);
    }

    public void addKeyword(String keywd, String translatedKeywd, String val, String language) {
        ArrayList<Property> props = new ArrayList<Property>();
        Property prop = new Property("Keyword", PropertyType.PROPERTY, PropertyArity.LIST, props);
        props.add(new Property("Key", PropertyType.STRING, (Object)keywd));
        props.add(new Property("Value", PropertyType.STRING, (Object)val));
        if (language != null) {
            props.add(new Property("Language", PropertyType.STRING, (Object)language));
        }
        if (translatedKeywd != null) {
            props.add(new Property("Translated key", PropertyType.STRING, (Object)translatedKeywd));
        }
        this._keywordPropList.add(prop);
    }

    public void addSplt(String name, int sampleDepth, int numSamples) {
        ArrayList<Property> props = new ArrayList<Property>();
        Property prop = new Property("Suggested palette", PropertyType.PROPERTY, PropertyArity.LIST, props);
        props.add(new Property("Name", PropertyType.STRING, (Object)name));
        props.add(new Property("Sample depth", PropertyType.INTEGER, (Object)sampleDepth));
        props.add(new Property("Number of samples", PropertyType.INTEGER, (Object)numSamples));
        this._spltList.add(prop);
    }

    protected void initParse() {
        super.initParse();
        this.ihdrSeen = false;
        this.plteSeen = false;
        this.idatSeen = false;
        this.idatFinished = false;
        this.iendSeen = false;
        this._ancillaryChunks = new HashSet<Integer>();
    }

    private PNGChunk readChunkHead(DataInputStream dstrm) throws IOException {
        long chunkLength;
        try {
            chunkLength = PngModule.readUnsignedInt((DataInputStream)dstrm, (boolean)true);
        }
        catch (EOFException e) {
            return null;
        }
        int sig = (int)PngModule.readUnsignedInt((DataInputStream)dstrm, (boolean)true);
        return PNGChunk.makePNGChunk(chunkLength, sig);
    }

    public void setIhdrSeen(boolean b) {
        this.ihdrSeen = b;
    }

    public boolean isIhdrSeen() {
        return this.ihdrSeen;
    }

    public void setIdatSeen(boolean b) {
        this.idatSeen = b;
    }

    public void setPlteSeen(boolean b) {
        this.plteSeen = b;
    }

    public void setIendSeen(boolean b) {
        this.iendSeen = b;
    }

    public boolean isIdatSeen() {
        return this.idatSeen;
    }

    public boolean isIdatFinished() {
        return this.idatFinished;
    }

    public boolean isPlteSeen() {
        return this.plteSeen;
    }

    public void setChunkSeen(int chunkType) {
        this._ancillaryChunks.add(chunkType);
    }

    public boolean isChunkSeen(int chunkType) {
        return this._ancillaryChunks.contains(chunkType);
    }

    public void setColorType(int ct) {
        this._colorType = ct;
    }

    public int getColorType() {
        return this._colorType;
    }
}

