/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;

public class BkgdChunk
extends PNGChunk {
    public BkgdChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String badChunk = "Bad bKGD chunk";
        this.processChunkCommon(info);
        ErrorMessage msg = null;
        int colorType = this._module.getColorType();
        int minLength = 0;
        switch (colorType) {
            case 0: 
            case 4: {
                minLength = 2;
                break;
            }
            case 2: 
            case 6: {
                minLength = 6;
                break;
            }
            case 3: {
                minLength = 1;
            }
        }
        if (this._module.isIdatSeen()) {
            msg = new ErrorMessage("bKGD chunk is not allowed after IDAT chunk");
        } else if (this.length < (long)minLength) {
            msg = new ErrorMessage("bKGD chunk is too short");
        } else {
            switch (colorType) {
                case 0: 
                case 4: {
                    int grayBkgd = this.readUnsignedShort();
                    Property grayProp = new Property("Gray background value", PropertyType.INTEGER, (Object)grayBkgd);
                    info.setProperty(grayProp);
                    break;
                }
                case 2: 
                case 6: {
                    int redBkgd = this.readUnsignedShort();
                    int greenBkgd = this.readUnsignedShort();
                    int blueBkgd = this.readUnsignedShort();
                    Property redProp = new Property("Red background value", PropertyType.INTEGER, (Object)redBkgd);
                    info.setProperty(redProp);
                    Property greenProp = new Property("Green background value", PropertyType.INTEGER, (Object)greenBkgd);
                    info.setProperty(greenProp);
                    Property blueProp = new Property("Blue background value", PropertyType.INTEGER, (Object)blueBkgd);
                    info.setProperty(blueProp);
                    break;
                }
                case 3: {
                    int bkgdIndex = this.readUnsignedByte();
                    Property bkgdProp = new Property("Background palette index", PropertyType.INTEGER, (Object)bkgdIndex);
                    info.setProperty(bkgdProp);
                }
            }
            int i = 0;
            while ((long)i < this.length - (long)minLength) {
                this.readUnsignedByte();
                ++i;
            }
        }
        if (msg != null) {
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad bKGD chunk");
        }
    }
}

