/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;

public class ChrmChunk
extends PNGChunk {
    private long whitePtX;
    private long whitePtY;
    private long redX;
    private long redY;
    private long greenX;
    private long greenY;
    private long blueX;
    private long blueY;

    public ChrmChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String badChunk = "Bad cHRM chunk";
        this.processChunkCommon(info);
        if (this._module.isPlteSeen() || this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage("cHRM chunk is not allowed after PLTE or IDAT");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException(badChunk);
        }
        if (this.length < 32L) {
            ErrorMessage msg = new ErrorMessage("cHRM chunk is too short");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad cHRM chunk");
        }
        this.whitePtX = this.readUnsignedInt();
        this.whitePtY = this.readUnsignedInt();
        this.redX = this.readUnsignedInt();
        this.redY = this.readUnsignedInt();
        this.greenX = this.readUnsignedInt();
        this.greenY = this.readUnsignedInt();
        this.blueX = this.readUnsignedInt();
        this.blueY = this.readUnsignedInt();
        this._nisoMetadata.setWhitePointXValue(new Rational(this.whitePtX, 100000L));
        this._nisoMetadata.setWhitePointYValue(new Rational(this.whitePtY, 100000L));
        this._nisoMetadata.setPrimaryChromaticitiesRedX(new Rational(this.redX, 100000L));
        this._nisoMetadata.setPrimaryChromaticitiesRedY(new Rational(this.redY, 100000L));
        this._nisoMetadata.setPrimaryChromaticitiesGreenX(new Rational(this.greenX, 100000L));
        this._nisoMetadata.setPrimaryChromaticitiesGreenY(new Rational(this.greenY, 100000L));
        this._nisoMetadata.setPrimaryChromaticitiesBlueX(new Rational(this.blueX, 100000L));
        this._nisoMetadata.setPrimaryChromaticitiesBlueY(new Rational(this.blueY, 100000L));
        int i = 0;
        while ((long)i < this.length - 32L) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

