/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;

public class GamaChunk
extends PNGChunk {
    public GamaChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        String badChunk = "Bad gAMA chunk";
        if (this._module.isPlteSeen() || this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage("gAMA chunk is not allowed after PLTE or IDAT");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad gAMA chunk");
        }
        if (this.length != 4L) {
            ErrorMessage msg = new ErrorMessage("gAMA chunk should have length = 4, length is " + this.length);
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad gAMA chunk");
        }
        int gamma = (int)this.readUnsignedInt();
        Rational ratGamma = new Rational(100000, gamma);
        Property gammaProp = new Property("Gamma", PropertyType.RATIONAL, (Object)ratGamma);
        this._propList.add(gammaProp);
        if (this._module.isPlteSeen()) {
            ErrorMessage msg = new ErrorMessage("gAMA chunk not allowed after PLTE chunk");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad gAMA chunk");
        }
        if (this._module.isIdatSeen()) {
            ErrorMessage msg = new ErrorMessage("gAMA chunk not allowed after IDAT chunk");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad gAMA chunk");
        }
    }
}

