/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;

public class IdatChunk
extends PNGChunk {
    public IdatChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        this._module.setIdatSeen(true);
        if (this._module.isIdatFinished()) {
            ErrorMessage msg = new ErrorMessage("IDAT chunks are not consecutive in file");
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Misplaced IDAT chunk");
        }
        int i = 0;
        while ((long)i < this.length) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

