/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;

public class PhysChunk
extends PNGChunk {
    public PhysChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String unitStr;
        String badChunk = "Bad pHYS chunk";
        this.processChunkCommon(info);
        ErrorMessage msg = null;
        if (this._module.isIdatSeen()) {
            msg = new ErrorMessage("pHYS chunk is not allowed after IDAT chunk");
        }
        if (this.length < 9L) {
            msg = new ErrorMessage("pHYS chunk too short");
        }
        if (msg != null) {
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad pHYS chunk");
        }
        long xPixelsPerUnit = this.readUnsignedInt();
        long yPixelsPerUnit = this.readUnsignedInt();
        int unit = this.readUnsignedByte();
        Property prop = new Property("X pixels per unit", PropertyType.INTEGER, (Object)xPixelsPerUnit);
        info.setProperty(prop);
        prop = new Property("Y pixels per unit", PropertyType.INTEGER, (Object)yPixelsPerUnit);
        info.setProperty(prop);
        switch (unit) {
            case 0: {
                unitStr = "Undefined";
                break;
            }
            case 1: {
                unitStr = "Metre";
                break;
            }
            default: {
                unitStr = Integer.toString(unit);
            }
        }
        prop = new Property("Pixel unit", PropertyType.STRING, (Object)unitStr);
        info.setProperty(prop);
        int i = 0;
        while ((long)i < this.length - 9L) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

