/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;

public class PlteChunk
extends PNGChunk {
    public PlteChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        ErrorMessage msg = null;
        this.processChunkCommon(info);
        if (this._module.isPlteSeen()) {
            msg = new ErrorMessage("Multiple PLTE chunks are not allowed");
        }
        this._module.setPlteSeen(true);
        if (this._module.isIdatSeen()) {
            msg = new ErrorMessage("PLTE chunk is not allowed after first IDAT chunk");
        }
        if (this.length % 3L != 0L) {
            msg = new ErrorMessage("Invalid PLTE chunk length " + this.length);
        }
        if (msg != null) {
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("PLTE chunk error");
        }
        int i = 0;
        while ((long)i < this.length) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

