/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.GeneralTextChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.util.zip.DataFormatException;

public class ZtxtChunk
extends GeneralTextChunk {
    public ZtxtChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = true;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String badchunk = "Bad zTXt chunk";
        this.processChunkCommon(info);
        StringBuilder sb = new StringBuilder();
        String keyword = null;
        String value = null;
        int cmprsIdx = 0;
        int state = 0;
        byte[] compressedData = new byte[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            int c = this.readUnsignedByte();
            switch (state) {
                case 0: {
                    if (c == 0) {
                        keyword = sb.toString();
                        state = 1;
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 1: {
                    if (c != 0) {
                        ErrorMessage msg = new ErrorMessage("Unrecognized compression type " + c + " in zTXt chunk");
                        info.setMessage((Message)msg);
                        info.setWellFormed(0);
                        throw new PNGException("Bad zTXt chunk");
                    }
                    state = 2;
                    compressedData = new byte[(int)this.length - i];
                    break;
                }
                case 2: {
                    compressedData[cmprsIdx++] = (byte)c;
                }
            }
            ++i;
        }
        if (keyword != null) {
            try {
                value = this.inflateToText(compressedData);
            }
            catch (DataFormatException e) {
                ErrorMessage msg = new ErrorMessage("Bad compressed data in zTXt chunk");
                info.setMessage((Message)msg);
                info.setWellFormed(false);
                throw new PNGException("Bad zTXt chunk");
            }
        }
        this._module.addKeyword(keyword, value);
    }
}

