/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.gzip.GzipEntryProperties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.jwat.common.Diagnosis;
import org.jwat.common.Diagnostics;
import org.jwat.common.InputStreamNoSkip;
import org.jwat.common.RandomAccessFileInputStream;
import org.jwat.gzip.GzipEntry;
import org.jwat.gzip.GzipReader;

public class GzipModule
extends ModuleBase {
    private static final Agent KB_AGENT = new Agent.Builder("Royal Library of Denmark", AgentType.STANDARD).address("S\u00f8ren Kierkegaards Plads 1, 1219 K\u00f8benhavn K, Denmark").fax("+45 3393 2218").web("http://kb.dk").build();
    private static final String NAME = "GZIP-kb";
    private static final String RELEASE = "0.1";
    private static final int[] DATE = new int[]{2015, 12, 8};
    private static final String[] FORMAT = new String[]{"GZIP"};
    private static final String COVERAGE = "GZIP, https://tools.ietf.org/html/rfc1952";
    private static final String[] MIMETYPE = new String[]{"application/gzip", "application/x-gzip"};
    private static final String WELLFORMED = "";
    private static final String VALIDITY = "The file is well-formed";
    private static final String REPINFO = "";
    private static final String NOTE = "";
    private static final String RIGHTS = "Copyright 2015 by The Royal Library of Denmark. Released under the GNU Lesser General Public License.";
    private List<Property> entryProperties;

    public GzipModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, "", VALIDITY, "", "", RIGHTS, false);
        this.setVendorAndSpecification();
        this.initialiseVariables();
    }

    private void setVendorAndSpecification() {
        this._vendor = KB_AGENT;
        Document doc = new Document("GZIP", DocumentType.RFC);
        Agent ietfAgent = new Agent.Builder("IETF", AgentType.STANDARD).web("http://www.ietf.org").build();
        doc.setPublisher(ietfAgent);
        doc.setDate("1996");
        doc.setIdentifier(new Identifier("https://www.ietf.org/rfc/rfc1952.txt", IdentifierType.RFC));
        this._specification.add(doc);
    }

    private void initialiseVariables() {
        this.entryProperties = new ArrayList<Property>();
    }

    public void resetParams() throws Exception {
        this.initialiseVariables();
    }

    public void parse(RandomAccessFile file, RepInfo info) throws IOException {
        RandomAccessFileInputStream stream = new RandomAccessFileInputStream(file);
        this.parse((InputStream)stream, info, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        GzipReader reader = new GzipReader((InputStream)new InputStreamNoSkip(stream), 8192);
        try {
            this.parseRecords(reader);
            info.setValid(reader.isCompliant());
            info.setWellFormed(reader.isCompliant());
            this.reportResults(reader, info);
            info.setSigMatch(this._name);
            info.setFormat(this._format[0]);
            info.setVersion("4.3");
            info.setMimeType(this._mimeType[0]);
        }
        catch (Exception e) {
            info.setMessage((Message)new ErrorMessage(e.getMessage()));
            info.setValid(false);
            info.setWellFormed(false);
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        return 0;
    }

    protected void parseRecords(GzipReader reader) throws EOFException, IOException, JhoveException {
        if (reader != null) {
            GzipEntry entry;
            while ((entry = reader.getNextEntry()) != null) {
                this.processEntry(entry);
                reader.diagnostics.addAll(entry.diagnostics);
            }
        } else {
            throw new JhoveException("WarcReader is has not been properly instantiated.");
        }
    }

    protected void processEntry(GzipEntry entry) throws EOFException, IOException, JhoveException {
        GzipEntryProperties properties = new GzipEntryProperties(entry);
        Property p = new Property("Record", PropertyType.STRING, PropertyArity.MAP, properties.getProperties());
        this.entryProperties.add(p);
        entry.close();
    }

    private void reportResults(GzipReader reader, RepInfo repInfo) throws JhoveException, IOException {
        Diagnostics diagnostics = reader.diagnostics;
        if (diagnostics.hasErrors()) {
            for (Diagnosis d : diagnostics.getErrors()) {
                repInfo.setMessage((Message)new ErrorMessage(this.extractDiagnosisType(d), this.extractDiagnosisMessage(d)));
            }
            repInfo.setConsistent(false);
        }
        if (diagnostics.hasWarnings()) {
            for (Diagnosis d : diagnostics.getWarnings()) {
                repInfo.setMessage((Message)new InfoMessage(this.extractDiagnosisType(d), this.extractDiagnosisMessage(d)));
            }
        }
        repInfo.setProperty(new Property("Records", PropertyType.PROPERTY, PropertyArity.LIST, this.entryProperties));
        repInfo.setSize(reader.getConsumed());
    }

    private String extractDiagnosisType(Diagnosis d) {
        return d.type.name();
    }

    private String extractDiagnosisMessage(Diagnosis d) {
        StringBuilder res = new StringBuilder();
        res.append("Entity: " + d.entity);
        for (String i : d.information) {
            res.append(", " + i);
        }
        return res.toString();
    }
}

