/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class PageObject
extends DocNode {
    private List _contentStreams = null;
    private static final String badPageStr = "Invalid dictionary data for page";

    public PageObject(PdfModule module, PageTreeNode parent, PdfDictionary dict) {
        super(module, parent, dict);
        this._pageObjectFlag = true;
    }

    public void loadContent(PdfModule module) throws PdfException {
        block8: {
            try {
                PdfObject contents = this._dict.get("Contents");
                if (contents == null) break block8;
                if ((contents = module.resolveIndirectObject(contents)) instanceof PdfStream) {
                    this._contentStreams = new ArrayList(1);
                    this._contentStreams.add(contents);
                    return;
                }
                if (contents instanceof PdfArray) {
                    Vector<PdfObject> contentVec = ((PdfArray)contents).getContent();
                    if (contentVec.size() == 0) {
                        return;
                    }
                    this._contentStreams = new ArrayList(contentVec.size());
                    for (int i = 0; i < contentVec.size(); ++i) {
                        PdfObject streamElement = contentVec.elementAt(i);
                        streamElement = module.resolveIndirectObject(streamElement);
                        this._contentStreams.add((PdfStream)streamElement);
                    }
                    break block8;
                }
                throw new PdfInvalidException(badPageStr, 0L);
            }
            catch (NullPointerException e) {
                throw new PdfInvalidException(badPageStr, 0L);
            }
            catch (ClassCastException e) {
                throw new PdfInvalidException(badPageStr, 0L);
            }
            catch (IOException e) {
                throw new PdfMalformedException(badPageStr, 0L);
            }
        }
    }

    public List getContentStreams() {
        return this._contentStreams;
    }

    public PdfArray getAnnotations() throws PdfException {
        String badAnnot = "Invalid Annotations";
        try {
            return (PdfArray)this._module.resolveIndirectObject(this._dict.get("Annots"));
        }
        catch (ClassCastException e) {
            throw new PdfInvalidException(badAnnot);
        }
        catch (IOException e) {
            throw new PdfMalformedException(badAnnot);
        }
    }

    @Override
    public void startWalk() {
        this._walkFinished = false;
    }

    @Override
    public PageObject nextPageObject() {
        if (this._walkFinished) {
            return null;
        }
        this._walkFinished = true;
        return this;
    }

    @Override
    public DocNode nextDocNode() {
        return this.nextPageObject();
    }

    public PdfArray getArtBox() throws PdfException {
        String badbox = "Malformed ArtBox in page tree";
        try {
            PdfArray mbox = (PdfArray)this._dict.get("ArtBox");
            if (mbox == null) {
                return null;
            }
            if (mbox.toRectangle() != null) {
                return mbox;
            }
            throw new PdfInvalidException("Malformed ArtBox in page tree");
        }
        catch (Exception e) {
            throw new PdfMalformedException("Malformed ArtBox in page tree");
        }
    }

    public PdfArray getTrimBox() throws PdfException {
        String badbox = "Malformed TrimBox in page tree";
        try {
            PdfArray mbox = (PdfArray)this._dict.get("TrimBox");
            if (mbox == null) {
                return null;
            }
            if (mbox.toRectangle() != null) {
                return mbox;
            }
            throw new PdfInvalidException("Malformed TrimBox in page tree");
        }
        catch (Exception e) {
            throw new PdfMalformedException("Malformed TrimBox in page tree");
        }
    }

    public PdfArray getBleedBox() throws PdfException {
        String badbox = "Malformed BleedBox in page tree";
        try {
            PdfArray mbox = (PdfArray)this._dict.get("BleedBox");
            if (mbox == null) {
                return null;
            }
            if (mbox.toRectangle() != null) {
                return mbox;
            }
            throw new PdfInvalidException("Malformed BleedBox in page tree");
        }
        catch (Exception e) {
            throw new PdfMalformedException("Malformed BleedBox in page tree");
        }
    }
}

