/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.ArrayEnd;
import edu.harvard.hul.ois.jhove.module.pdf.ArrayStart;
import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryEnd;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryStart;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArrayEnd;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionaryEnd;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfPseudoObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import edu.harvard.hul.ois.jhove.module.pdf.Tokenizer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Parser {
    private Tokenizer _tokenizer;
    private int _dictDepth;
    private int _arrayDepth;
    private Map<Long, PdfObject> _objectMap;
    private boolean _encrypted;
    private boolean _pdfACompliant;

    public Parser(Tokenizer tokenizer) {
        this._tokenizer = tokenizer;
        this._pdfACompliant = true;
        this.reset();
    }

    public void setObjectMap(Map<Long, PdfObject> objectMap) {
        this._objectMap = objectMap;
    }

    public void reset() {
        this._dictDepth = 0;
        this._arrayDepth = 0;
    }

    public void resetLoose() {
        this._dictDepth = 1000000;
        this._arrayDepth = 1000000;
    }

    public Token getNext() throws IOException, PdfException {
        return this.getNext(0L);
    }

    public Token getNext(long max) throws IOException, PdfException {
        Token tok = this._tokenizer.getNext(max);
        if (tok instanceof DictionaryStart) {
            ++this._dictDepth;
        } else if (tok instanceof DictionaryEnd) {
            --this._dictDepth;
            if (this._dictDepth < 0) {
                throw new PdfMalformedException("Improperly nested dictionary delimiters");
            }
        }
        if (tok instanceof ArrayStart) {
            ++this._arrayDepth;
        } else if (tok instanceof ArrayEnd) {
            --this._arrayDepth;
            if (this._arrayDepth < 0) {
                throw new PdfMalformedException("Improperly nested array delimiters");
            }
        }
        return tok;
    }

    public Token getNext(Class<?> clas, String errMsg) throws IOException, PdfException {
        Token tok = this.getNext();
        if (!clas.isInstance(tok)) {
            throw new PdfInvalidException(errMsg);
        }
        if (!tok.isPdfACompliant()) {
            this._pdfACompliant = false;
        }
        return tok;
    }

    public int getDictDepth() {
        return this._dictDepth;
    }

    public void setEncrypted(boolean encrypted) {
        this._encrypted = encrypted;
        this._tokenizer.setEncrypted(encrypted);
    }

    public int getArrayDepth() {
        return this._arrayDepth;
    }

    public String getWSString() {
        return this._tokenizer.getWSString();
    }

    public Set<String> getLanguageCodes() {
        return this._tokenizer.getLanguageCodes();
    }

    public boolean getPDFACompliant() {
        if (!this._tokenizer.getPDFACompliant()) {
            this._pdfACompliant = false;
        }
        return this._pdfACompliant;
    }

    public void setPDFACompliant(boolean pdfACompliant) {
        this._pdfACompliant = pdfACompliant;
        if (pdfACompliant) {
            this._tokenizer.setPDFACompliant(true);
        }
    }

    public PdfObject readObjectDef() throws IOException, PdfException {
        Numeric objNumTok = (Numeric)this.getNext(Numeric.class, "Invalid object definition");
        return this.readObjectDef(objNumTok);
    }

    public PdfObject readObjectDef(Numeric objNumTok) throws IOException, PdfException {
        PdfObject obj;
        String invDef = "Invalid object definition";
        this.reset();
        Numeric genNumTok = (Numeric)this.getNext(Numeric.class, invDef);
        Keyword objKey = (Keyword)this.getNext(Keyword.class, invDef);
        if (!"obj".equals(objKey.getValue())) {
            throw new PdfMalformedException(invDef);
        }
        if (this._tokenizer.getWSString().length() > 1) {
            this._pdfACompliant = false;
        }
        if ((obj = this.readObject(false)) instanceof PdfDictionary) {
            Stream strm = null;
            try {
                strm = (Stream)this.getNext(Stream.class, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (strm != null) {
                PdfStream strmObj = new PdfStream((PdfDictionary)obj, strm);
                if (!strmObj.isPdfaCompliant()) {
                    this._pdfACompliant = false;
                }
                obj = strmObj;
            }
        }
        obj.setObjNumber(objNumTok.getIntegerValue());
        obj.setGenNumber(genNumTok.getIntegerValue());
        return obj;
    }

    public PdfObject readObject(boolean allowPseudo) throws IOException, PdfException {
        Token tok = this.getNext();
        if (tok instanceof ArrayStart) {
            return this.readArray();
        }
        if (tok instanceof DictionaryStart) {
            return this.readDictionary();
        }
        if (allowPseudo && tok instanceof ArrayEnd) {
            return new PdfArrayEnd(tok);
        }
        if (allowPseudo && tok instanceof DictionaryEnd) {
            return new PdfDictionaryEnd(tok);
        }
        if (tok.isSimpleToken()) {
            return new PdfSimpleObject(tok);
        }
        throw new PdfMalformedException("Cannot parse object", this.getOffset(), tok);
    }

    public PdfArray readArray() throws IOException, PdfException {
        PdfObject obj;
        PdfArray arr = new PdfArray();
        while (true) {
            obj = null;
            obj = this.readObject(true);
            if (!(obj instanceof PdfPseudoObject)) {
                arr.add(obj);
                continue;
            }
            if (obj instanceof PdfArrayEnd) break;
        }
        PdfArrayEnd eobj = (PdfArrayEnd)obj;
        Token tok = eobj.getToken();
        if (tok instanceof ArrayEnd) {
            this.collapseObjectVector(arr.getContent());
            if (!arr.isPdfACompliant()) {
                this._pdfACompliant = false;
            }
            return arr;
        }
        throw new PdfMalformedException("Unexpected token in array", this.getOffset());
    }

    public PdfDictionary readDictionary() throws IOException, PdfException {
        PdfObject obj;
        PdfDictionary dict = new PdfDictionary();
        Vector<PdfObject> vec = new Vector<PdfObject>();
        while (true) {
            obj = null;
            obj = this.readObject(true);
            if (obj instanceof PdfSimpleObject && ((PdfSimpleObject)obj).getToken() instanceof Comment) continue;
            if (!(obj instanceof PdfPseudoObject)) {
                vec.add(obj);
                continue;
            }
            if (obj instanceof PdfDictionaryEnd) break;
        }
        PdfDictionaryEnd eobj = (PdfDictionaryEnd)obj;
        Token tok = eobj.getToken();
        if (tok instanceof DictionaryEnd) {
            this.collapseObjectVector(vec);
            String invalDict = "Malformed dictionary";
            int vecSize = vec.size();
            if (vecSize % 2 != 0) {
                throw new PdfMalformedException(invalDict + ": Vector must contain an even number of objects, but has " + vecSize, this.getOffset());
            }
            for (int i = 0; i < vecSize; i += 2) {
                try {
                    Name key = (Name)((PdfSimpleObject)vec.elementAt(i)).getToken();
                    PdfObject value = vec.elementAt(i + 1);
                    dict.add(key.getValue(), value);
                    continue;
                }
                catch (Exception f) {
                    throw new PdfMalformedException(invalDict, this.getOffset());
                }
            }
            if (!dict.isPdfACompliant()) {
                this._pdfACompliant = false;
            }
            return dict;
        }
        throw new PdfMalformedException("Unexpected token in dictionary", this.getOffset());
    }

    public long getOffset() {
        return this._tokenizer.getOffset();
    }

    public void seek(long offset) throws IOException, PdfException {
        this._tokenizer.seek(offset);
        this.reset();
    }

    private void collapseObjectVector(Vector<PdfObject> v) throws PdfException {
        int i;
        int lowestChanged = -1;
        for (i = v.size() - 1; i >= 2; --i) {
            Token tok;
            PdfObject obj = v.elementAt(i);
            if (!(obj instanceof PdfSimpleObject) || !((tok = ((PdfSimpleObject)obj).getToken()) instanceof Keyword) || !"R".equals(((Keyword)tok).getValue())) continue;
            try {
                PdfSimpleObject nobj = (PdfSimpleObject)v.elementAt(i - 2);
                Numeric ntok = (Numeric)nobj.getToken();
                int objNum = ntok.getIntegerValue();
                nobj = (PdfSimpleObject)v.elementAt(i - 1);
                ntok = (Numeric)nobj.getToken();
                int genNum = ntok.getIntegerValue();
                v.set(i - 2, new PdfIndirectObj(objNum, genNum, this._objectMap));
                v.set(i, null);
                v.set(i - 1, null);
                lowestChanged = i - 1;
                i -= 2;
                continue;
            }
            catch (Exception e) {
                throw new PdfMalformedException("Malformed indirect object reference");
            }
        }
        if (lowestChanged > 0) {
            int j = lowestChanged;
            for (i = lowestChanged; i < v.size(); ++i) {
                PdfObject elem = v.elementAt(i);
                if (elem == null) continue;
                v.set(j++, elem);
            }
            v.setSize(j);
        }
    }

    public void scanMode(boolean flag) {
        this._tokenizer.scanMode(flag);
    }
}

