/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BroadcastExtChunk
extends Chunk {
    public BroadcastExtChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        byte[] buf256 = new byte[256];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf256, (ModuleBase)module);
        String description = this.byteBufString(buf256);
        byte[] buf32 = new byte[32];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf32, (ModuleBase)module);
        String originator = this.byteBufString(buf32);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf32, (ModuleBase)module);
        String originatorRef = this.byteBufString(buf32);
        byte[] buf10 = new byte[10];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf10, (ModuleBase)module);
        String originationDate = this.byteBufString(buf10);
        byte[] buf8 = new byte[8];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf8, (ModuleBase)module);
        String originationTime = this.byteBufString(buf8);
        long timeReference = module.readSignedLong(this._dstream);
        int version = module.readUnsignedShort(this._dstream);
        module.setBroadcastVersion(version);
        byte[] smtpe_umid = new byte[64];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])smtpe_umid, (ModuleBase)module);
        module.skipBytes(this._dstream, 190L, module);
        String codingHistory = "";
        if (this.bytesLeft > 602L) {
            byte[] bufCodingHistory = new byte[(int)this.bytesLeft - 602];
            ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])bufCodingHistory, (ModuleBase)module);
            codingHistory = this.byteBufString(bufCodingHistory);
        }
        ArrayList<Property> plist = new ArrayList<Property>(20);
        if (description.length() > 0) {
            plist.add(new Property("Description", PropertyType.STRING, (Object)description));
        }
        if (originator.length() > 0) {
            plist.add(new Property("Originator", PropertyType.STRING, (Object)originator));
        }
        if (originatorRef.length() > 0) {
            plist.add(new Property("Originator Reference", PropertyType.STRING, (Object)originatorRef));
        }
        if (originationDate.length() > 0) {
            plist.add(new Property("OriginationDate", PropertyType.STRING, (Object)originationDate));
        }
        if (originationTime.length() > 0) {
            plist.add(new Property("OriginationTime", PropertyType.STRING, (Object)originationTime));
        }
        plist.add(new Property("TimeReference", PropertyType.LONG, (Object)new Long(timeReference)));
        plist.add(new Property("Version", PropertyType.INTEGER, (Object)new Integer(version)));
        plist.add(new Property("UMID", PropertyType.BYTE, PropertyArity.ARRAY, (Object)smtpe_umid));
        if (codingHistory.length() > 0) {
            plist.add(new Property("CodingHistory", PropertyType.STRING, (Object)codingHistory));
        }
        module.addWaveProperty(new Property("BroadcastAudioExtension", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        AESAudioMetadata aes = module.getAESMetadata();
        aes.setStartTime(timeReference);
        return true;
    }
}

