/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.WaveStrings;
import java.io.DataInputStream;
import java.io.IOException;

public class FormatChunk
extends Chunk {
    public static final int WAVE_FORMAT_PCM = 1;
    public static final int WAVE_FORMAT_MPEG = 80;
    public static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int[] losslessCodecs = new int[]{355, 6513};

    public FormatChunk(WaveModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException, JhoveException {
        String compName;
        WaveModule module = (WaveModule)this._module;
        int validBitsPerSample = -1;
        byte[] subformat = null;
        long channelMask = -1L;
        int compressionCode = module.readUnsignedShort(this._dstream);
        module.setCompressionCode(compressionCode);
        int numChannels = module.readUnsignedShort(this._dstream);
        long sampleRate = module.readUnsignedInt(this._dstream);
        module.setSampleRate(sampleRate);
        long bytesPerSecond = module.readUnsignedInt(this._dstream);
        int blockAlign = module.readUnsignedShort(this._dstream);
        module.setBlockAlign(blockAlign);
        int bitsPerSample = module.readUnsignedShort(this._dstream);
        this.bytesLeft -= 16L;
        byte[] extraBytes = null;
        if (this.bytesLeft > 0L) {
            int extraFormatBytes = module.readUnsignedShort(this._dstream);
            extraBytes = new byte[extraFormatBytes];
            if (compressionCode == 65534 && this.bytesLeft >= 22L) {
                boolean wfe = true;
                validBitsPerSample = module.readUnsignedShort(this._dstream);
                channelMask = module.readUnsignedInt(this._dstream);
                subformat = new byte[20];
                ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])subformat, (ModuleBase)module);
                if ((bitsPerSample + 7) / 8 * numChannels != blockAlign) {
                    wfe = false;
                }
                if (bitsPerSample % 8 != 0) {
                    wfe = false;
                }
                if (validBitsPerSample > bitsPerSample) {
                    wfe = false;
                }
                if (wfe) {
                    module.setWaveFormatExtensible(true);
                }
            } else {
                if (compressionCode != 1 || (bitsPerSample + 7) / 8 * numChannels == blockAlign) {
                    module.setWaveFormatEx(true);
                }
                ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])extraBytes, (ModuleBase)module);
            }
            if ((extraFormatBytes & 1) != 0) {
                this._module.skipBytes(this._dstream, 1L, (ModuleBase)module);
            }
        } else if (compressionCode == 1 && (bitsPerSample + 7) / 8 * numChannels == blockAlign) {
            module.setPCMWaveFormat(true);
        }
        if (compressionCode == 1 || compressionCode == 80) {
            module.setBroadcastWave(true);
        }
        module.addWaveProperty(module.addIntegerProperty("CompressionCode", compressionCode, WaveStrings.COMPRESSION_FORMAT, WaveStrings.COMPRESSION_INDEX));
        AESAudioMetadata aes = module.getAESMetadata();
        try {
            compName = WaveStrings.COMPRESSION_FORMAT[WaveStrings.COMPRESSION_INDEX[compressionCode]];
        }
        catch (Exception e) {
            throw new JhoveException("Error in FormatChunk: " + e.getClass().getName());
        }
        aes.setAudioDataEncoding(compName);
        aes.setNumChannels(numChannels);
        this.setChannelLocations(aes, numChannels);
        aes.setSampleRate((double)sampleRate);
        aes.setBitDepth(bitsPerSample);
        String qual = "LOSSY";
        for (int i = 0; i < losslessCodecs.length; ++i) {
            if (compressionCode != losslessCodecs[i]) continue;
            qual = "CODE_REGENERATING";
        }
        if (compressionCode == 1) {
            aes.clearBitrateReduction();
        } else {
            aes.setBitrateReduction(compName, "", "", "", qual, Long.toString(bytesPerSecond), "FIXED");
        }
        module.addWaveProperty(new Property("AverageBytesPerSecond", PropertyType.LONG, (Object)new Long(bytesPerSecond)));
        module.addWaveProperty(new Property("BlockAlign", PropertyType.INTEGER, (Object)new Integer(blockAlign)));
        if (extraBytes != null) {
            module.addWaveProperty(new Property("ExtraFormatBytes", PropertyType.BYTE, PropertyArity.ARRAY, (Object)extraBytes));
        }
        if (validBitsPerSample != -1) {
            module.addWaveProperty(new Property("ValidBitsPerSample", PropertyType.INTEGER, (Object)new Integer(validBitsPerSample)));
        }
        if (channelMask != -1L) {
            module.addWaveProperty(new Property("ChannelMask", PropertyType.LONG, (Object)new Long(channelMask)));
        }
        if (subformat != null) {
            module.addWaveProperty(new Property("Subformat", PropertyType.BYTE, PropertyArity.ARRAY, (Object)subformat));
        }
        return true;
    }

    private void setChannelLocations(AESAudioMetadata aes, int numChannels) {
        String[] mapLoc = new String[numChannels];
        switch (numChannels) {
            case 2: {
                mapLoc[0] = "LEFT";
                mapLoc[1] = "RIGHT";
                break;
            }
            default: {
                for (int i = 0; i < numChannels; ++i) {
                    mapLoc[i] = "UNKNOWN";
                }
            }
        }
        aes.setMapLocations(mapLoc);
    }
}

