/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Callback;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.ConfigHandler;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleInfo;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.handler.AuditHandler;
import edu.harvard.hul.ois.jhove.handler.TextHandler;
import edu.harvard.hul.ois.jhove.handler.XmlHandler;
import edu.harvard.hul.ois.jhove.module.BytestreamModule;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.SAXParserFactory;
import org.openpreservation.jhove.ReleaseDetails;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JhoveBase {
    private static final ReleaseDetails RELEASE_DETAILS = ReleaseDetails.getInstance();
    public static final String _name = "JhoveBase";
    private static final String JAVA_TEMP_DIR_PROP_KEY = "java.io.tmpdir";
    private static final String HUL_PROPERTY_PREFIX = "edu.harvard.hul.ois.";
    private static final String JHOVE_PROPERTY_PREFIX = "edu.harvard.hul.ois.jhove.";
    private static final String BUFFER_PROPERTY = "edu.harvard.hul.ois.jhove.bufferSize";
    private static final String CONFIG_DIR = "conf";
    private static final String CONFIG_PROPERTY = "edu.harvard.hul.ois.jhove.config";
    private static final int DEFAULT_BUFFER = 131072;
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String DEFAULT_TEMP = System.getProperty("java.io.tmpdir");
    private static final String ENCODING_PROPERTY = "edu.harvard.hul.ois.jhove.encoding";
    private static final String JHOVE_DIR = "jhove";
    private static final String SAX_PROPERTY = "edu.harvard.hul.ois.jhove.saxClass";
    private static final String TEMPDIR_PROPERTY = "edu.harvard.hul.ois.jhove.tempDirectory";
    private static final String MIXVSN_PROPERTY = "edu.harvard.hul.ois.jhove.mixvsn";
    protected boolean _abort;
    protected int _bufferSize;
    protected boolean _checksum;
    protected String _configFile;
    protected String _encoding;
    protected Map<String, String> _extensions;
    protected List<OutputHandler> _handlerList;
    protected Map<String, OutputHandler> _handlerMap;
    protected String _jhoveHome;
    protected List<Module> _moduleList;
    protected Map<String, Module> _moduleMap;
    protected String _outputFile;
    protected String _saxClass;
    protected boolean _showRaw;
    protected boolean _signature;
    protected String _tempDir;
    protected String _mixVsn;
    protected int _sigBytes;
    protected File _saveDir;
    protected long _nByte;
    Callback _callback;
    protected URLConnection _conn;
    protected Thread _currentThread;
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove");
    protected String _logLevel;

    public JhoveBase() throws JhoveException {
        this._logger.setLevel(Level.SEVERE);
        String version = System.getProperty("java.vm.version");
        if (version.compareTo("1.5.0") < 0) {
            String bad = "Java 1.5 or higher is required";
            this._logger.severe(bad);
            throw new JhoveException(bad);
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new NaiveHostnameVerifier());
        this._moduleList = new ArrayList<Module>(20);
        this._moduleMap = new TreeMap<String, Module>();
        this._handlerList = new ArrayList<OutputHandler>();
        this._handlerMap = new TreeMap<String, OutputHandler>();
        this._abort = false;
        this._bufferSize = -1;
        this._checksum = false;
        this._showRaw = false;
        this._signature = false;
        this._callback = null;
    }

    public void init(String configFile, String saxClass) throws JhoveException {
        Class<?> cl;
        List<String> param;
        int i;
        if (configFile == null) {
            throw new JhoveException("Initialization exception; location not specified for configuration file.");
        }
        this._configFile = configFile;
        File config = new File(this._configFile);
        if (!config.exists() || !config.isFile()) {
            throw new JhoveException("Configuration file " + config.getAbsolutePath() + " not found or " + "not readable and could not create default file; use -c to specify");
        }
        this._saxClass = saxClass;
        XMLReader parser = null;
        try {
            if (saxClass == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                parser = factory.newSAXParser().getXMLReader();
            } else {
                parser = XMLReaderFactory.createXMLReader(saxClass);
            }
        }
        catch (Exception e) {
            throw new JhoveException("SAX parser not found: " + saxClass, e);
        }
        this._logger.info("Using SAX parser " + parser.getClass().getName());
        ConfigHandler configHandler = new ConfigHandler();
        parser.setContentHandler(configHandler);
        parser.setEntityResolver(configHandler);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            String canonicalPath = config.getCanonicalPath();
            String fileURL = "file://";
            if (canonicalPath.charAt(0) != '/') {
                fileURL = fileURL + Character.toString('/');
            }
            fileURL = fileURL + canonicalPath;
            parser.parse(fileURL);
        }
        catch (IOException e) {
            throw new JhoveException("Cannot read configuration file: " + configFile, e);
        }
        catch (SAXException s) {
            throw new JhoveException("Error parsing configuration file: " + s.getMessage(), s);
        }
        this._extensions = configHandler.getExtensions();
        this._jhoveHome = configHandler.getJhoveHome();
        this._encoding = configHandler.getEncoding();
        if (this._encoding == null) {
            this._encoding = JhoveBase.getFromProperties(ENCODING_PROPERTY);
            if (this._encoding == null) {
                this._encoding = DEFAULT_ENCODING;
            }
        }
        this._tempDir = configHandler.getTempDir();
        if (this._tempDir == null) {
            this._tempDir = JhoveBase.getFromProperties(TEMPDIR_PROPERTY);
            if (this._tempDir == null) {
                this._tempDir = DEFAULT_TEMP;
            }
        }
        this._mixVsn = configHandler.getMixVsn();
        if (this._mixVsn == null) {
            this._mixVsn = "2.0";
        }
        this._sigBytes = configHandler.getSigBytes();
        if (this._logLevel == null) {
            this._logLevel = configHandler.getLogLevel();
            if (this._logLevel != null) {
                try {
                    this._logger.setLevel(Level.parse(this._logLevel));
                }
                catch (Exception s) {
                    // empty catch block
                }
            }
        }
        this._bufferSize = configHandler.getBufferSize();
        if (this._bufferSize < 0) {
            String size = JhoveBase.getFromProperties(BUFFER_PROPERTY);
            if (size != null) {
                try {
                    this._bufferSize = Integer.parseInt(size);
                }
                catch (Exception fileURL) {
                    // empty catch block
                }
            }
            if (this._bufferSize < 0) {
                this._bufferSize = 131072;
            }
        }
        List<ModuleInfo> modList = configHandler.getModule();
        List<String[]> hanList = null;
        List<List<String>> params = configHandler.getModuleParams();
        int n = modList.size();
        for (i = 0; i < n; ++i) {
            ModuleInfo modInfo = modList.get(i);
            param = params.get(i);
            try {
                cl = Class.forName(modInfo.clas);
                Module module = (Module)cl.newInstance();
                module.init(modInfo.init);
                module.setDefaultParams(param);
                this._moduleList.add(module);
                this._moduleMap.put(module.getName().toLowerCase(), module);
                this._logger.info("Initialized " + module.getName());
                continue;
            }
            catch (Exception e) {
                throw new JhoveException("Cannot instantiate module: " + modInfo.clas, e);
            }
        }
        hanList = configHandler.getHandler();
        params = configHandler.getHandlerParams();
        n = hanList.size();
        for (i = 0; i < n; ++i) {
            String[] tuple = hanList.get(i);
            param = params.get(i);
            try {
                cl = Class.forName(tuple[0]);
                OutputHandler handler = (OutputHandler)cl.newInstance();
                handler.setDefaultParams(param);
                this._handlerList.add(handler);
                this._handlerMap.put(handler.getName().toLowerCase(), handler);
                continue;
            }
            catch (Exception e) {
                throw new JhoveException("Cannot instantiate handler: " + tuple[0], e);
            }
        }
        BytestreamModule module = new BytestreamModule();
        module.setDefaultParams(new ArrayList<String>());
        this._moduleList.add(module);
        this._moduleMap.put(module.getName().toLowerCase(), module);
        HandlerBase handler = new TextHandler();
        handler.setDefaultParams(new ArrayList<String>());
        this._handlerList.add(handler);
        this._handlerMap.put(handler.getName().toLowerCase(), handler);
        handler = new XmlHandler();
        handler.setDefaultParams(new ArrayList<String>());
        this._handlerList.add(handler);
        this._handlerMap.put(handler.getName().toLowerCase(), handler);
        handler = new AuditHandler();
        handler.setDefaultParams(new ArrayList<String>());
        this._handlerList.add(handler);
        this._handlerMap.put(handler.getName().toLowerCase(), handler);
    }

    public void setCallback(Callback callback) {
        this._callback = callback;
    }

    public void dispatch(App app, Module module, OutputHandler aboutHandler, OutputHandler handler, String outputFile, String[] dirFileOrUri) throws Exception {
        this._abort = false;
        if (handler == null) {
            handler = this._handlerMap.get("text");
        }
        handler.reset();
        this._outputFile = outputFile;
        handler.setApp(app);
        handler.setBase(this);
        this._logger.info("Handler " + handler.getClass().getName() + " preparing to write to " + this._outputFile);
        handler.setWriter(JhoveBase.makeWriter(this._outputFile, this._encoding));
        handler.showHeader();
        if (dirFileOrUri == null) {
            if (module != null) {
                module.applyDefaultParams();
                module.show(handler);
            } else if (aboutHandler != null) {
                handler.show(aboutHandler);
            } else {
                app.show(handler);
            }
        } else {
            for (int i = 0; i < dirFileOrUri.length && this.process(app, module, handler, dirFileOrUri[i]); ++i) {
            }
        }
        handler.showFooter();
        handler.close();
    }

    public boolean process(App app, Module module, OutputHandler handler, String dirFileOrUri) throws Exception {
        if (this._abort) {
            return false;
        }
        this._logger.info("Entering JhoveBase.process, file/uri = " + dirFileOrUri);
        File file = null;
        boolean isTemp = false;
        long lastModified = -1L;
        URI uri = null;
        try {
            uri = new URI(dirFileOrUri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RepInfo info = new RepInfo(dirFileOrUri);
        if (uri != null && uri.isAbsolute()) {
            URLConnection conn;
            URL url = null;
            try {
                url = uri.toURL();
            }
            catch (Exception e) {
                throw new JhoveException("cannot convert URI to URL: " + dirFileOrUri);
            }
            this._conn = conn = url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                try {
                    TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, tm, new SecureRandom());
                    SSLSocketFactory sf = sslContext.getSocketFactory();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sf);
                    int code = ((HttpsURLConnection)conn).getResponseCode();
                    if (200 > code || code >= 300) {
                        throw new JhoveException("URL not found: " + dirFileOrUri);
                    }
                }
                catch (Exception e) {
                    throw new JhoveException("URL not found: " + dirFileOrUri);
                }
            }
            lastModified = conn.getLastModified();
            try {
                file = this.connToTempFile(conn, info);
                if (file == null) {
                    return false;
                }
                isTemp = true;
            }
            catch (IOException e) {
                this._conn = null;
                String msg = "cannot read URL: " + dirFileOrUri;
                this._logger.info(msg);
                String msg1 = e.getMessage();
                if (msg1 != null) {
                    msg = msg + " (" + msg1 + ")";
                }
                throw new JhoveException(msg);
            }
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).disconnect();
            }
            this._conn = null;
        } else {
            file = new File(dirFileOrUri);
        }
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            info = null;
            Arrays.sort(files);
            handler.startDirectory(file.getCanonicalPath());
            for (int i = 0; i < files.length; ++i) {
                if (this.process(app, module, handler, ((File)files[i]).getCanonicalPath())) continue;
                return false;
            }
            handler.endDirectory();
        } else if (!file.exists()) {
            this._logger.info("file not found");
            info.setMessage(new ErrorMessage("file not found"));
            info.setWellFormed(0);
            info.show(handler);
        } else if (!file.isFile() || !file.canRead()) {
            this._logger.info("file cannot be read");
            info.setMessage(new ErrorMessage("file cannot be read"));
            info.setWellFormed(0);
            info.show(handler);
        } else if (handler.okToProcess(dirFileOrUri)) {
            info.setSize(file.length());
            if (lastModified < 0L) {
                lastModified = file.lastModified();
            }
            info.setLastModified(new Date(lastModified));
            if (module != null) {
                this._logger.info("Processing " + file.getName() + " with module " + module.getClass().getName());
                if (!this.processFile(app, module, false, file, info)) {
                    return false;
                }
            } else {
                for (Module mod : this._moduleList) {
                    RepInfo infc = (RepInfo)info.clone();
                    if (!mod.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) continue;
                    try {
                        if (!this.processFile(app, mod, false, file, infc)) {
                            return false;
                        }
                        if (infc.getWellFormed() == 1) {
                            info.copy(infc);
                            break;
                        }
                        info.setSigMatch(infc.getSigMatch());
                    }
                    catch (Exception e) {
                        this._logger.info("JHOVE caught exception: " + e.getClass().getName());
                    }
                }
            }
            info.show(handler);
        }
        if (file != null && isTemp) {
            file.delete();
        }
        return true;
    }

    public File connToTempFile(URLConnection conn, RepInfo info) throws IOException {
        File tempFile;
        try {
            tempFile = this.newTempFile();
        }
        catch (IOException e) {
            throw new IOException("cannot create temp file");
        }
        BufferedOutputStream outstrm = null;
        DataInputStream instrm = null;
        outstrm = this._bufferSize > 0 ? new BufferedOutputStream(new FileOutputStream(tempFile), this._bufferSize) : new BufferedOutputStream(new FileOutputStream(tempFile));
        try {
            instrm = this._bufferSize > 0 ? new DataInputStream(new BufferedInputStream(conn.getInputStream(), this._bufferSize)) : new DataInputStream(new BufferedInputStream(conn.getInputStream()));
        }
        catch (UnknownHostException e) {
            tempFile.delete();
            throw new IOException(e.toString());
        }
        catch (IOException e) {
            tempFile.delete();
            throw e;
        }
        catch (Exception e) {
            tempFile.delete();
            throw new IOException(e.toString());
        }
        Checksummer ckSummer = null;
        if (this._checksum) {
            ckSummer = new Checksummer();
        }
        this._nByte = 0L;
        int appModulo = 4000;
        try {
            while (true) {
                if (this._nByte % (long)appModulo == 0L) {
                    Thread.yield();
                    if (this._callback != null) {
                        this._callback.callback(1, new Long(this._nByte));
                    }
                    if ((long)(appModulo * 10) < this._nByte) {
                        appModulo = (int)(this._nByte / 10L);
                    }
                }
                if (this._abort) {
                    instrm.close();
                    ((OutputStream)outstrm).close();
                    tempFile.delete();
                    return null;
                }
                int ch = instrm.readUnsignedByte();
                if (ckSummer != null) {
                    ckSummer.update(ch);
                }
                byte by = Checksum.unsignedByteToByte(ch);
                ++this._nByte;
                ((OutputStream)outstrm).write(by);
            }
        }
        catch (EOFException by) {
            instrm.close();
            ((OutputStream)outstrm).close();
            info.setSize(this._nByte);
            if (ckSummer != null) {
                info.setChecksum(new Checksum(ckSummer.getCRC32(), ChecksumType.CRC32));
                String value = ckSummer.getMD5();
                if (value != null) {
                    info.setChecksum(new Checksum(value, ChecksumType.MD5));
                }
                if ((value = ckSummer.getSHA1()) != null) {
                    info.setChecksum(new Checksum(value, ChecksumType.SHA1));
                }
            }
            return tempFile;
        }
    }

    public void abort() {
        this._abort = true;
        HttpsURLConnection conn = null;
        if (this._conn instanceof HttpsURLConnection) {
            conn = (HttpsURLConnection)this._conn;
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (conn != null) {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processFile(App app, Module module, boolean verbose, File file, RepInfo info) throws Exception {
        if (!module.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) {
            return false;
        }
        if (this._callback != null) {
            this._callback.callback(2, info.getUri());
        }
        module.setApp(app);
        module.setBase(this);
        module.setVerbosity(verbose ? 1 : 2);
        module.applyDefaultParams();
        if (module.isRandomAccess()) {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            if (this._signature) {
                module.checkSignatures(file, raf, info);
            } else {
                module.parse(raf, info);
            }
            raf.close();
        } else {
            FileInputStream stream = new FileInputStream(file);
            try {
                if (this._signature) {
                    module.checkSignatures(file, stream, info);
                } else {
                    int parseIndex = module.parse(stream, info, 0);
                    while (parseIndex != 0) {
                        ((InputStream)stream).close();
                        stream = new FileInputStream(file);
                        parseIndex = module.parse(stream, info, parseIndex);
                    }
                }
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        return true;
    }

    public File tempFile() throws IOException {
        File file = null;
        if (this._tempDir == null) {
            file = File.createTempFile("JHOV", "");
        } else {
            File dir = new File(this._tempDir);
            file = File.createTempFile("JHOV", "", dir);
        }
        file.deleteOnExit();
        return file;
    }

    public boolean getAbort() {
        return this._abort;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public String getConfigFile() {
        return this._configFile;
    }

    public Date getDate() {
        return RELEASE_DETAILS.getBuildDate();
    }

    public String getEncoding() {
        return this._encoding;
    }

    public Map<String, String> getExtension() {
        return this._extensions;
    }

    public String getExtension(String name) {
        return this._extensions.get(name);
    }

    public OutputHandler getHandler(String name) {
        OutputHandler handler = null;
        if (name != null) {
            handler = this._handlerMap.get(name.toLowerCase());
        }
        return handler;
    }

    public Map<String, OutputHandler> getHandlerMap() {
        return this._handlerMap;
    }

    public List<OutputHandler> getHandlerList() {
        return this._handlerList;
    }

    public String getJhoveHome() {
        return this._jhoveHome;
    }

    public Module getModule(String name) {
        Module module = null;
        if (name != null) {
            module = this._moduleMap.get(name.toLowerCase());
        }
        return module;
    }

    public Map<String, Module> getModuleMap() {
        return this._moduleMap;
    }

    public List<Module> getModuleList() {
        return this._moduleList;
    }

    public String getName() {
        return _name;
    }

    public String getOuputFile() {
        return this._outputFile;
    }

    public String getRelease() {
        return RELEASE_DETAILS.getVersion();
    }

    public String getRights() {
        return RELEASE_DETAILS.getRights();
    }

    public String getSaxClass() {
        return this._saxClass;
    }

    public String getTempDirectory() {
        return this._tempDir;
    }

    public int getSigBytes() {
        return this._sigBytes;
    }

    public File getSaveDirectory() {
        return this._saveDir;
    }

    public boolean getChecksumFlag() {
        return this._checksum;
    }

    public boolean getShowRawFlag() {
        return this._showRaw;
    }

    public boolean getSignatureFlag() {
        return this._signature;
    }

    public String getMixVersion() {
        return this._mixVsn;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize >= 0 && bufferSize < 1024 ? 1024 : bufferSize;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setTempDirectory(String tempDir) {
        this._tempDir = tempDir;
    }

    public void setLogLevel(String level) {
        this._logLevel = level;
        if (level != null) {
            try {
                this._logger.setLevel(Level.parse(this._logLevel));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setChecksumFlag(boolean checksum) {
        this._checksum = checksum;
    }

    public void setShowRawFlag(boolean raw) {
        this._showRaw = raw;
    }

    public void setSignatureFlag(boolean signature) {
        this._signature = signature;
    }

    public void setSaveDirectory(File dir) {
        this._saveDir = dir;
    }

    public void setCurrentThread(Thread t) {
        this._currentThread = t;
    }

    public void resetAbort() {
        this._abort = false;
    }

    public static String getConfigFileFromProperties() {
        String configFile = null;
        configFile = JhoveBase.getFromProperties(CONFIG_PROPERTY);
        if (configFile == null) {
            try {
                String fs = System.getProperty("file.separator");
                configFile = System.getProperty("user.home") + fs + JHOVE_DIR + fs + CONFIG_DIR + fs + "jhove.conf";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return configFile;
    }

    public static String getSaxClassFromProperties() {
        return JhoveBase.getFromProperties(SAX_PROPERTY);
    }

    public static String getFromProperties(String name) {
        String value = null;
        try {
            String fs = System.getProperty("file.separator");
            Properties props = new Properties();
            String propsFile = System.getProperty("user.home") + fs + JHOVE_DIR + fs + "jhove.properties";
            FileInputStream stream = new FileInputStream(propsFile);
            props.load(stream);
            stream.close();
            value = props.getProperty(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected static PrintWriter makeWriter(String outputFile, String encoding) throws JhoveException {
        PrintWriter output = null;
        OutputStreamWriter osw = null;
        if (outputFile != null) {
            try {
                FileOutputStream stream = new FileOutputStream(outputFile);
                osw = new OutputStreamWriter((OutputStream)stream, encoding);
                output = new PrintWriter(osw);
            }
            catch (UnsupportedEncodingException u) {
                throw new JhoveException("unsupported character encoding: " + encoding);
            }
            catch (FileNotFoundException e) {
                throw new JhoveException("cannot open output file: " + outputFile);
            }
        }
        if (output == null) {
            try {
                osw = new OutputStreamWriter((OutputStream)System.out, encoding);
            }
            catch (UnsupportedEncodingException u) {
                throw new JhoveException("unsupported character encoding: " + encoding);
            }
            output = new PrintWriter(osw);
        }
        return output;
    }

    public File newTempFile() throws IOException {
        return this.tempFile();
    }

    private class RelaxedX509TrustManager
    implements X509TrustManager {
        private RelaxedX509TrustManager() {
        }

        public boolean isClientTrusted(X509Certificate[] chain) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] chain) {
            return true;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s) {
        }

        public void checkServerTrusted(X509Certificate[] chain) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s) {
        }
    }

    private class NaiveHostnameVerifier
    implements HostnameVerifier {
        private NaiveHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

