/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.tiffTests;

import org.opengis.cite.geotiff11.tiffTests.CommonTiffMeta;
import org.opengis.cite.geotiff11.util.TiffDump;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TiffTagsTests
extends CommonTiffMeta {
    @Test(description="TIFF Tags Test")
    public void verifyTiffTags() throws Exception {
        for (TiffDump.Directory directory : this.tiffDump.getDirectories()) {
            TiffDump.Tag transformTag;
            TiffDump.Tag pixelScaleTag;
            TiffDump.Tag tiepointTag;
            TiffDump.Tag asciis;
            TiffDump.Tag geoKeyDirectory;
            int previousValue = Integer.MIN_VALUE;
            for (TiffDump.Tag tag : directory.getTags()) {
                Assert.assertTrue((tag.getNameValue() > previousValue ? 1 : 0) != 0, (String)"the TIFF tags in a GeoTIFF file SHALL be written out to the file with the tag-IDs sorted in ascending order");
                previousValue = tag.getNameValue();
            }
            if (directory.getOffset() == 0 || (geoKeyDirectory = directory.getTag(34735)) == null) continue;
            Assert.assertTrue((geoKeyDirectory.getTypeValue() == 3 ? 1 : 0) != 0, (String)"the GeoKeyDirectoryTag SHALL have type = SHORT");
            Assert.assertTrue((geoKeyDirectory.getCount() >= 4 ? 1 : 0) != 0, (String)"the GeoKeyDirectoryTag SHALL have at least 4 values");
            if (geoKeyDirectory.getValues() == null) {
                throw new Exception("GeoKeyDirectory does not exist.");
            }
            Assert.assertTrue((boolean)geoKeyDirectory.containsValue(1024), (String)"validate that there is a GTModelType GeoKey in the GeoKey Directory");
            TiffDump.Tag doubles = directory.getTag(34736);
            if (doubles != null) {
                Assert.assertTrue((doubles.getTypeValue() == 12 ? 1 : 0) != 0, (String)"the GeoDoubleParamsTag MAY hold any number of key parameters with type = double");
            }
            if ((asciis = directory.getTag(34737)) != null) {
                Assert.assertTrue((asciis.getTypeValue() == 2 ? 1 : 0) != 0, (String)"the GeoAsciiParamsTag SHALL have type = ASCII");
            }
            if ((tiepointTag = directory.getTag(33922)) != null) {
                Assert.assertTrue((tiepointTag.getTypeValue() == 12 ? 1 : 0) != 0, (String)"the ModelTiepointTag SHALL have type = DOUBLE");
                Assert.assertTrue((tiepointTag.getCount() == 6 ? 1 : 0) != 0, (String)"the ModelTiepointTag SHALL have 6 values for each of the K tiepoints");
            }
            if ((pixelScaleTag = directory.getTag(33550)) != null) {
                Assert.assertTrue((pixelScaleTag.getTypeValue() == 12 ? 1 : 0) != 0, (String)"the ModelPixelScaleTag SHALL have type = DOUBLE");
                Assert.assertTrue((tiepointTag != null ? 1 : 0) != 0, (String)"validate that this IFD (containing ModelPixelScaleTag) contains a ModelTiepointTag");
                Assert.assertTrue((pixelScaleTag.getCount() == 3 ? 1 : 0) != 0, (String)"the ModelPixelScaleTag SHALL have 3 values representing the scale factor in the X, Y, and Z directions");
            }
            if ((transformTag = directory.getTag(34264)) != null) {
                Assert.assertTrue((transformTag.getTypeValue() == 12 ? 1 : 0) != 0, (String)"the ModelTransformationTag SHALL have type = DOUBLE");
                Assert.assertTrue((pixelScaleTag == null ? 1 : 0) != 0, (String)"validate that this IFD (containing ModelTransformationTag) does not contain a ModelPixelScaleTag");
                Assert.assertTrue((transformTag.getValues().size() == 16 ? 1 : 0) != 0, (String)"the ModelTransformationTag SHALL have 16 values representing the terms of the 4 by 4 transformation matrix");
            }
            Assert.assertTrue((transformTag != null || tiepointTag != null ? 1 : 0) != 0, (String)"validate that this IFD contains either a ModelTransformationTag or a ModelTiepointTag");
        }
    }
}

