/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TiffDump {
    private String filePath;
    private String magic;
    private String version;
    private List<Directory> directories = new ArrayList<Directory>();
    private Directory geoKeyDirectory;

    public static void main(String[] args) {
        String test = "Tile L(ength (0x323) SHORT (3) 231<256 789 87 45>\\r\\n";
        try {
            TiffDump td = new TiffDump(new String("c:/Users/RDAGCDLJ/Documents/FY20/GeoTIFF/example_tiffs/COG_DEF_OR/LC08_L1TP_016030_20140602_20170305_01_T1_B1.TIF:\r\nMagic: 0x4949 <little-endian> Version: 0x2a <ClassicTIFF>\r\nDirectory 0: offset 8 (0x8) next 3034 (0xbda)\r\nImageWidth (256) SHORT (3) 1<7901>\r\nImageLength (257) SHORT (3) 1<8011>\r\nBitsPerSample (258) SHORT (3) 1<16>\r\nCompression (259) SHORT (3) 1<8>\r\nPhotometric (262) SHORT (3) 1<1>\r\nSamplesPerPixel (277) SHORT (3) 1<1>\r\nPlanarConfig (284) SHORT (3) 1<1>\r\nPredictor (317) SHORT (3) 1<1>\r\nTileWidth (322) SHORT (3) 1<512>\r\nTileLength (323) SHORT (3) 1<512>\r\nSampleFormat (339) SHORT (3) 1<1>\r\n33550 (0x830e) DOUBLE (12) 3<30 30 0>\r\n33922 (0x8482) DOUBLE (12) 6<0 0 0 217200 4.9029e+06 0>\r\n34735 (0x87af) SHORT (3) 64<1 1 0 14 1024 0 1 1 1025 0 1 2 1026 34737 33 0 2048 0 1 32767 2049 34737 84 33 2054 0 1 9102 2055 34736 1 0 2057 34736 1 1 2059 34736 1 2 2061 34736 1 3 3072 0 1 32767 3073 34737 406 117 3074 0 1 16018 3076 0 1 9001 0 0 0 0>\r\n34736 (0x87b0) DOUBLE (12) 4<0.0174533 6.37814e+06 298.257 0>\r\n34737 (0x87b1) ASCII (2) 524<PCS Name = WGS_1984_UTM_zone_18N|GCS Name = GCS_WGS_1984|Datum = D_WGS_1984|Ellipsoid = WGS_1984|Primem = Greenwich||ESRI PE String = PROJCS[\"WGS_1984_UTM_zone_18N\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"Meter\",1]]|\\0>\r\n"));
            System.out.println(td);
            System.out.println(td.getDirectory(0));
            System.out.println(td.getDirectory(0).getTag("34737"));
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TiffDump(String contents) throws Exception {
        Directory currentDirectory = null;
        for (String line : contents.toLowerCase().split("\n")) {
            if (currentDirectory == null && (line.contains(".tif") || line.contains(".tmp"))) {
                this.filePath = line.substring(0, line.length() - 2);
                continue;
            }
            if (currentDirectory == null && line.contains("magic:") && line.contains("version:")) {
                List<String> info = Arrays.asList(line.replace(":", "").split(" "));
                this.magic = info.get(info.indexOf("magic") + 1).trim();
                this.version = info.get(info.indexOf("version") + 1).trim();
                continue;
            }
            if (line.toLowerCase().indexOf("directory") == 0 && line.toLowerCase().contains("offset") && line.toLowerCase().contains("next")) {
                currentDirectory = new Directory(line);
                this.directories.add(currentDirectory);
                continue;
            }
            if (currentDirectory == null || line.trim().equals("")) continue;
            currentDirectory.addTag(line);
            if (!currentDirectory.hasTag(34735)) continue;
            this.geoKeyDirectory = currentDirectory;
        }
        if (!this.valid()) {
            System.out.println("Tiff contents invalid/parsed incorrectly:\n" + contents);
            throw new Exception("Tiff contents invalid/parsed incorrectly.");
        }
    }

    public boolean valid() {
        return this.magic != null && this.version != null && this.directories.size() >= 1;
    }

    public Directory getDirectory(int index) {
        return this.directories.get(index);
    }

    public List<Directory> getDirectories() {
        return this.directories;
    }

    public Directory getGeoKeyDirectory() {
        return this.geoKeyDirectory;
    }

    public String toString() {
        return String.format("TiffDump:\n%s\nMagic: %s Version: %s\n%s", this.filePath == null ? "filepath unavailable" : this.filePath, this.magic, this.version, this.directories.toString());
    }

    public String getMagic() {
        return this.magic;
    }

    public String getVersion() {
        return this.version;
    }

    public static String tagHeaderString() {
        return String.format("%20s (%s)\t%10s (%s)\t%10s %s", "NAME", "ID", "TYPE", "T", "CNT", "[VALUES]");
    }

    public class Tag {
        private String line;
        private String name;
        private String type;
        private int nameValue;
        private int typeValue;
        private int count;
        private String valuesAsString;
        private List<Object> values = new ArrayList<Object>();

        public Tag(String line) {
            String[] stringValues;
            this.line = line;
            String regexNameValue = ".+?(?= \\([0-9])";
            String regexNumbers = "\\((0x[0-9a-f]+?|[0-9]+?)\\)";
            String regexCount = "([0-9]+)\\<";
            String regexValues = "[0-9]\\<(.*?)\\>\\s*$";
            Matcher matcher = Pattern.compile(regexNumbers).matcher(line);
            matcher.find();
            String nameValueString = matcher.group(1);
            this.nameValue = nameValueString.contains("x") ? Integer.parseInt(nameValueString.replace("0x", ""), 16) : Integer.parseInt(nameValueString);
            matcher.find();
            this.typeValue = Integer.parseInt(matcher.group(1));
            matcher = Pattern.compile(regexCount).matcher(line);
            matcher.find();
            this.count = Integer.parseInt(matcher.group(1));
            matcher = Pattern.compile(regexValues).matcher(line);
            matcher.find();
            this.valuesAsString = matcher.group(1).trim();
            this.name = line.split(regexNumbers)[0].trim();
            this.type = line.split(regexNumbers)[1].trim();
            switch (this.type.toUpperCase()) {
                case "ASCII": {
                    stringValues = this.valuesAsString.split("\\|");
                    break;
                }
                default: {
                    stringValues = this.valuesAsString.split(" ");
                }
            }
            if (stringValues[stringValues.length - 1].contains("...")) {
                System.out.println("Value list has been truncated.");
                stringValues = Arrays.copyOfRange(stringValues, 0, stringValues.length - 1);
            }
            switch (this.type.toUpperCase()) {
                case "SHORT": {
                    for (String value : stringValues) {
                        this.values.add(Integer.parseInt(value));
                    }
                    break;
                }
                case "RATIONAL": 
                case "DOUBLE": {
                    for (String value : stringValues) {
                        this.values.add(Float.valueOf(Float.parseFloat(value)));
                    }
                    break;
                }
                default: {
                    for (String value : stringValues) {
                        this.values.add(value);
                    }
                }
            }
            this.values.removeIf(s -> s.equals(""));
        }

        public String getLine() {
            return this.line;
        }

        public String getName() {
            return this.name;
        }

        public int getNameValue() {
            return this.nameValue;
        }

        public int getTypeValue() {
            return this.typeValue;
        }

        public int getCount() {
            return this.count;
        }

        public boolean containsValue(Object value) {
            return this.values.contains(value);
        }

        public List<Object> getValues() {
            return this.values;
        }

        public String getValuesAsString() {
            return this.valuesAsString;
        }

        public String toString() {
            return String.format("%20s (%d)\t%10s (%d)\t%10d %s", this.name.toUpperCase(), this.nameValue, this.type, this.typeValue, this.count, this.values.toString());
        }
    }

    public class Directory {
        private int index;
        private int offset;
        private int next;
        private List<Tag> tags = new ArrayList<Tag>();

        public Directory(String directoryLine) {
            ArrayList<String> info = new ArrayList<String>(Arrays.asList(directoryLine.replace(":", "").split(" ")));
            this.index = Integer.parseInt(((String)info.get(info.indexOf("directory") + 1)).trim());
            this.offset = Integer.parseInt(((String)info.get(info.indexOf("offset") + 1)).trim());
            this.next = Integer.parseInt(((String)info.get(info.indexOf("next") + 1)).trim());
        }

        public void addTag(String line) {
            this.tags.add(new Tag(line));
        }

        public Tag getTag(String s) {
            for (Tag tag : this.tags) {
                if (!tag.getName().equals(s.toLowerCase())) continue;
                return tag;
            }
            return null;
        }

        public Tag getTag(int value) {
            for (Tag tag : this.tags) {
                if (tag.getNameValue() != value) continue;
                return tag;
            }
            return null;
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getNext() {
            return this.next;
        }

        public String toString() {
            String tagsString = "";
            for (Tag tag : this.tags) {
                tagsString = tagsString + tag.toString() + "\n";
            }
            return String.format("Directory %d:\nOffset: %d\tNext: %d\nTags:\n%s\n%s\n", this.index, this.offset, this.next, TiffDump.tagHeaderString(), tagsString);
        }

        public boolean hasTag(int tag) {
            return this.getTag(tag) != null;
        }
    }
}

