/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.opengis.cite.geotiff11.SuiteAttribute;
import org.opengis.cite.geotiff11.SyncPipe;
import org.opengis.cite.geotiff11.util.TestSuiteLogger;
import org.testng.ISuite;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class URIUtils {
    private static final String FIXUP_BASE_URI = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    private static final String EXE = "exe";
    private static final String TIFFDUMP = "tiffdump";

    public static Document parseURI(URI uriRef) throws SAXException, IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setExpandEntityReferences(false);
        docFactory.setXIncludeAware(true);
        Document doc = null;
        try {
            docFactory.setFeature(FIXUP_BASE_URI, false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(uriRef.toString());
        }
        catch (ParserConfigurationException x) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DocumentBuilder." + x);
        }
        if (null != doc) {
            doc.setDocumentURI(uriRef.toString());
        }
        return doc;
    }

    public static boolean parseGeoTiff(ISuite suite, URI uriRef, String geoTiffFile) throws SAXException, IOException {
        if (null == uriRef) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        String geotiffFilePath = URIUtils.prepPath(uriRef.getPath());
        return URIUtils.readMetaData(suite, geotiffFilePath, geoTiffFile);
    }

    private static String initMetadataComm(String exeCommand, String outLocation, String geotiffFilePath, String option) {
        return exeCommand + " " + option + " " + geotiffFilePath + " > " + outLocation;
    }

    private static boolean readMetaData(ISuite suite, String geotiffFilePath, String geoTiffFile) {
        Process p = URIUtils.startCmd();
        if (p == null) {
            return false;
        }
        new Thread(new SyncPipe(p.getErrorStream(), System.err)).start();
        new Thread(new SyncPipe(p.getInputStream(), System.out)).start();
        try {
            Object exe;
            File outTempFile = File.createTempFile("tiffMeta", ".txt");
            if (SystemUtils.IS_OS_WINDOWS) {
                File exeTempFile = File.createTempFile(TIFFDUMP, ".exe");
                InputStream input = URIUtils.class.getResourceAsStream("/exe/tiffdump.exe");
                FileOutputStream output = new FileOutputStream(exeTempFile);
                byte[] buffer = new byte[4096];
                int bytesRead = input.read(buffer);
                while (bytesRead != -1) {
                    output.write(buffer, 0, bytesRead);
                    bytesRead = input.read(buffer);
                }
                exeTempFile.deleteOnExit();
                exe = Paths.get(System.getProperty("user.dir"), new String[0]).relativize(exeTempFile.toPath()).toString();
                output.close();
                input.close();
                try (PrintWriter stdin = new PrintWriter(p.getOutputStream());){
                    stdin.println(URIUtils.initMetadataComm((String)exe, outTempFile.getAbsolutePath(), geotiffFilePath, "-m 10000"));
                    stdin.flush();
                }
            }
            PrintWriter stdin = new PrintWriter(p.getOutputStream());
            exe = null;
            try {
                stdin.println("cat /etc/os-release");
                stdin.println("apt-get upgrade -y");
                stdin.println("apt-get update -y");
                stdin.println("apt-get install -y libtiff-tools");
                stdin.println("apt-get update -y");
                stdin.flush();
                String outPath = outTempFile.getAbsolutePath();
                stdin.println("cd /");
                stdin.println("echo '" + URIUtils.initMetadataComm(TIFFDUMP, outPath, geotiffFilePath, "-m 10000") + "'");
                stdin.println(URIUtils.initMetadataComm(TIFFDUMP, outPath, geotiffFilePath, "-m 10000"));
                stdin.println("echo 'cat " + outPath + "'");
                stdin.println("cat " + outPath);
                stdin.flush();
            }
            catch (Throwable throwable) {
                exe = throwable;
                throw throwable;
            }
            finally {
                if (stdin != null) {
                    if (exe != null) {
                        try {
                            stdin.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)exe).addSuppressed(throwable);
                        }
                    } else {
                        stdin.close();
                    }
                }
            }
            try {
                int returnCode = p.waitFor();
                FileInputStream inputStream = new FileInputStream(outTempFile.getAbsolutePath());
                suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                ((InputStream)inputStream).close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String prepPath(String string) {
        string = string.replace("jar:", "");
        string = string.replace("file:", "");
        string = SystemUtils.IS_OS_WINDOWS ? string.replace("/", "\\") : string.replace("\\", "/");
        while (string.charAt(0) == '\\' || string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    private static Process startCmd() {
        String command = SystemUtils.IS_OS_WINDOWS ? "cmd" : "bash";
        try {
            Process p = Runtime.getRuntime().exec(command);
            return p;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File dereferenceURI(URI uriRef) throws IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        if (uriRef.getScheme().equalsIgnoreCase("file")) {
            return new File(uriRef);
        }
        Client client = Client.create();
        WebResource webRes = client.resource(uriRef);
        ClientResponse rsp = (ClientResponse)webRes.get(ClientResponse.class);
        String suffix = null;
        if (((String)rsp.getHeaders().getFirst((Object)"Content-Type")).endsWith("tif")) {
            suffix = ".tif";
        }
        File destFile = File.createTempFile("entity-", suffix);
        if (rsp.hasEntity()) {
            int bytesRead;
            InputStream is = rsp.getEntityInputStream();
            FileOutputStream os = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            is.close();
            os.flush();
            ((OutputStream)os).close();
        }
        TestSuiteLogger.log(Level.FINE, "Wrote " + destFile.length() + " bytes to file at " + destFile.getAbsolutePath());
        return destFile;
    }

    public static URI resolveRelativeURI(String baseURI, String uriRef) {
        URI uri;
        URI uRI = uri = null != baseURI ? URI.create(baseURI) : URI.create("");
        if (null != baseURI && null == uri.getScheme()) {
            throw new IllegalArgumentException("Base URI has no scheme component: " + baseURI);
        }
        return uri.resolve(uriRef);
    }
}

