/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.tiffTests;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.csv.CSVRecord;
import org.opengis.cite.geotiff11.tiffTests.GeoKeysTests;
import org.opengis.cite.geotiff11.util.EPSGDataSet;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ShortParamsTests
extends GeoKeysTests {
    @Test(description="Short Params GTModelTypeGeoKey (1024) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGTModelTypeGeoKey() {
        int index = this.getKeyIndex(1024);
        Assert.assertTrue((index != -1 ? 1 : 0) != 0, (String)"a GeoTIFF file SHALL include a GTModelTypeGeoKey");
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the GTModelTypeGeoKey SHALL have type = SHORT");
        Assert.assertFalse((value >= 4 && value <= 32766 ? 1 : 0) != 0, (String)"GTModelTypeGeoKey values in the range 4-32766 SHALL be reserved");
        Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"GTModelTypeGeoKey values in the range 32768-65535 SHALL be private");
        switch (value) {
            case 1: {
                Assert.assertTrue((boolean)this.keyExists(3072), (String)"if the GTModelTypeGeoKey value is 1 (Model CRS is a projected 2D CRS) then the GeoTIFF file SHALL include a ProjectedCRSGeoKey 3072");
                break;
            }
            case 2: 
            case 3: {
                Assert.assertTrue((boolean)this.keyExists(2048), (String)"if the GTModelTypeGeoKey value is 2/3 then the GeoTIFF file SHALL include a GeodeticCRSGeoKey");
                break;
            }
            case 32767: {
                Assert.assertTrue((boolean)this.keyExists(1026), (String)"if the GTModelTypeGeoKey value is 32767 (user-defined) then the GTCitationGeoKey SHALL be populated");
            }
        }
    }

    @Test(description="Short Params GTRasterTypeGeoKey (1025) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGTRasterTypeGeoKey() {
        int index = this.getKeyIndex(1025);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the GTRasterTypeGeoKey SHALL have type = SHORT");
        if (!Arrays.asList(0, 1, 2, Short.MAX_VALUE).contains(value)) {
            Assert.assertFalse((value >= 3 && value <= 32766 ? 1 : 0) != 0, (String)"GTRasterTypeGeoKey values in the range 3-32766 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"GTRasterTypeGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params GeodeticCRSGeoKey (2048) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeodeticCRSGeoKey() throws IOException {
        int index = this.getKeyIndex(2048);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the GeodeticCRSGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(2049) && this.keyExists(2050) && (this.keyExists(2054) || this.keyExists(2052)) ? 1 : 0) != 0, (String)"if the GeodeticCRSGeoKey value is 32767 (User-Defined) then the GeodeticCitationGeoKey 2049, GeodeticDatumGeoKey 2050 and at least one of GeogAngularUnitsGeoKey 2054 or GeogLinearUnitsGeoKey 2052 SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("coordinate-reference-system", "COORD_REF_SYS_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"GeodeticCRSGeoKey values in the range 1024-32766 SHALL be EPSG geodetic CRS codes (geographic 2D CRS, geographic 3D CRS, and geocentric CRS)");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"GeodeticCRSGeoKey values in the range 1024-32766 SHALL be EPSG geodetic CRS codes (geographic 2D CRS, geographic 3D CRS, and geocentric CRS)");
            Assert.assertTrue((record.get("COORD_REF_SYS_KIND").equals("geographic 2D") || record.get("COORD_REF_SYS_KIND").equals("geographic 3D") || record.get("COORD_REF_SYS_KIND").equals("geocentric") ? 1 : 0) != 0, (String)"GeodeticCRSGeoKey values in the range 1024-32766 SHALL be EPSG geodetic CRS codes (geographic 2D CRS, geographic 3D CRS, and geocentric CRS)");
        } else if (value >= 1 && value <= 1000) {
            Assert.assertTrue((this.minorRevision == 0 ? 1 : 0) != 0, (String)"GeodeticCRSGeoKey values in the range 1-1000 SHALL be obsolete EPSG/POC Geographic Codes");
        } else {
            Assert.assertFalse((value >= 1001 && value <= 1023 ? 1 : 0) != 0, (String)"GeodeticCRSGeoKey values in the range 1001-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"GeodeticCRSGeoKeyvalues value out of bounds");
        }
    }

    @Test(description="Short Params GeodeticDatumGeoKey (2050) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeodeticDatumGeoKey() throws IOException {
        int index = this.getKeyIndex(2050);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the GeodeticDatumGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(2049) && this.keyExists(2051) && this.keyExists(2056) ? 1 : 0) != 0, (String)"if the GeodeticDatumGeoKey value is 32767 (User-Defined) then the GeodeticCitationGeoKey 2049, PrimeMeridianGeoKey 2051 and EllipsoidGeoKey 2056 SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("datum", "DATUM_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"GeodeticDatumGeoKey values in the range 1024-32766 SHALL be EPSG geodetic datum codes");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"));
            Assert.assertTrue((boolean)record.get("DATUM_TYPE").equals("geodetic"));
        } else {
            Assert.assertFalse((this.minorRevision != 0 && value >= 1 && value <= 1000 ? 1 : 0) != 0, (String)"GeodeticDatumGeoKey values in the range 1-1000 SHALL be obsolete EPSG/POS Datum Codes");
            Assert.assertFalse((value >= 1001 && value <= 1023 ? 1 : 0) != 0, (String)"GeodeticDatumGeoKey values in the range 1001-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"GeodeticDatumGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params PrimeMeridianGeoKey (2051) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyPrimeMeridianGeoKey() throws IOException {
        int index = this.getKeyIndex(2051);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the PrimeMeridianGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(2049) && this.keyExists(2061) ? 1 : 0) != 0, (String)"if the PrimeMeridianGeoKey value is 32767 (User-Defined) then the GeodeticCitationGeoKey, and PrimeMeridianLongGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("prime-meridian", "PRIME_MERIDIAN_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"PrimeMeridianGeoKey values in the range 1024-32766 SHALL be EPSG Prime Meridian Codes");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"PrimeMeridianGeoKey values in the range 1024-32766 SHALL be EPSG Prime Meridian Codes");
        } else {
            Assert.assertFalse((this.minorRevision != 0 && value >= 1 && value <= 100 ? 1 : 0) != 0, (String)"PrimeMeridianGeoKey values in the range 1-100 SHALL be obsolete EPSG/POSC Datum Codes");
            Assert.assertFalse((value >= 101 && value <= 1023 ? 1 : 0) != 0, (String)"PrimeMeridianGeoKey values in the range 101-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"PrimeMeridianGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params GeogLinearUnitsGeoKey (2052) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeogLinearUnitsGeoKey() throws IOException {
        int index = this.getKeyIndex(2052);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the GeogLinearUnitsGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(2049) && this.keyExists(2053) ? 1 : 0) != 0, (String)"a GeogLinearUnitsGeoKey value of 32767 SHALL be a user-defined linear unit. If the value is 32767 (User-Defined) then the GeodeticCitationGeoKey and the GeogLinearUnitSizeGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("unit-of-measure", "UOM_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"GeogLinearUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"GeogLinearUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
            Assert.assertTrue((boolean)record.get("UNIT_OF_MEAS_TYPE").equals("length"), (String)"GeogLinearUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
        } else {
            Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"GeogLinearUnitsGeoKey values in the range 1-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"GeogLinearUnitsGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params GeogAngularUnitsGeoKey (2054) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeogAngularUnitsGeoKey() throws IOException {
        int index = this.getKeyIndex(2054);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the GeogAngularUnitsGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(2049) && this.keyExists(2055) ? 1 : 0) != 0, (String)"A GeogAngularUnitsGeoKey or a GeogAzimuthUnitsGeoKey value of 32767 SHALL be a user-defined angular unit. If the value is 32767 (User-Defined) then the GeodeticCitationGeoKey and the GeogAngularUnitSizeGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("unit-of-measure", "UOM_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"GeogAzimuthUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = angle");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"GeogAzimuthUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = angle");
            Assert.assertTrue((boolean)record.get("UNIT_OF_MEAS_TYPE").equals("angle"), (String)"GeogAzimuthUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = angle");
        } else {
            Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"GeogAngularUnitsGeoKey values in the range 1-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"GeogAngularUnitsGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params EllipsoidGeoKey (2056) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyEllipsoidGeoKey() throws IOException {
        int index = this.getKeyIndex(2056);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the EllipsoidGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(2049) && this.keyExists(2057) && (this.keyExists(2058) || this.keyExists(2059)) ? 1 : 0) != 0, (String)"if the EllipsoidGeoKey value is 32767 (User-Defined) then the GTCitationGeoKey and the EllipsoidSemiMajorAxisGeoKey SHALL be populated together with the one of either the EllipsoidSemiMinorAxisGeoKey or the EllipsoidInvFlatteningGeoKey");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("ellipsoid", "ELLIPSOID_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"EllipsoidGeoKey values in the range 1024-32766 SHALL be EPSG ellipsoid Codes");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"EllipsoidGeoKey values in the range 1024-32766 SHALL be EPSG ellipsoid Codes");
        } else {
            Assert.assertFalse((this.minorRevision != 1 && value >= 1024 && value <= 32766 ? 1 : 0) != 0, (String)"EllipsoidGeoKey values in the range 1024-32766 SHALL be EPSG ellipsoid Codes");
            Assert.assertFalse((this.minorRevision != 0 && value >= 1 && value <= 1000 ? 1 : 0) != 0, (String)"EllipsoidGeoKey values in the range 1-1000 SHALL be obsolete EPSG/POSC Datum Codes");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"EllipsoidGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params GeogAzimuthUnitsGeoKey (2060) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeogAzimuthUnitsGeoKey() throws IOException {
        int index = this.getKeyIndex(2060);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"GeogAzimuthUnitsGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(2049) && this.keyExists(2055) ? 1 : 0) != 0, (String)"a GeogAngularUnitsGeoKey or a GeogAzimuthUnitsGeoKey value of 32767 SHALL be a user-defined angular unit. If the value is 32767 (User-Defined) then the GeodeticCitationGeoKey and the GeogAngularUnitSizeGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("unit-of-measure", "UOM_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"GeogAzimuthUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = angle");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"GeogAzimuthUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = angle");
            Assert.assertTrue((boolean)record.get("UNIT_OF_MEAS_TYPE").equals("angle"), (String)"GeogAzimuthUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = angle");
        } else {
            Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"GeogAzimuthUnitsGeoKey values in the range 1-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"GeogAzimuthUnitsGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params ProjectedCRSGeoKey (2056) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjectedCRSGeoKey() throws IOException {
        int index = this.getKeyIndex(3072);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the ProjectedCRSGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(3073) && this.keyExists(2048) && this.keyExists(3074) ? 1 : 0) != 0, (String)"a ProjectedCRSGeoKey value of 32767 SHALL be a user-defined projected CRS. If the ProjectedCRSGeoKey value is 32767 (User-Defined) then the ProjectedCitationGeoKey, GeodeticCRSGeoKey and ProjectionGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("coordinate-reference-system", "COORD_REF_SYS_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"ProjectedCRSGeoKey values in the range 1024-32766 SHALL be EPSG Projected CRS Codes");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"ProjectedCRSGeoKey values in the range 1024-32766 SHALL be EPSG Projected CRS Codes");
            Assert.assertTrue((boolean)record.get("COORD_REF_SYS_KIND").equals("projected"), (String)"ProjectedCRSGeoKey values in the range 1024-32766 SHALL be EPSG Projected CRS Codes");
        } else {
            Assert.assertFalse((this.minorRevision != 0 && value >= 1 && value <= 1000 ? 1 : 0) != 0, (String)"ProjectedCRSGeoKey values in the range 1-1000 SHALL be obsolete EPSG/POC Datum Codes");
            Assert.assertFalse((value >= 1001 && value <= 1023 ? 1 : 0) != 0, (String)"ProjectedCRSGeoKey values in the range 1001-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"ProjectedCRSGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params ProjectionGeoKey (3074) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjectionGeoKey() throws IOException {
        int index = this.getKeyIndex(3074);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the ProjectionGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(3073) && this.keyExists(3075) && this.keyExists(3076) ? 1 : 0) != 0, (String)"If the ProjectionGeoKey value is 32767 (User-Defined) then the ProjectedCitationGeoKey, ProjectionMethodGeoKey, and ProjLinearUnitsGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("coordinate-operation", "COORD_OP_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"ProjectionGeoKey values in the range 1024-32766 SHALL be valid EPSG map projection (coordinate operation) codes");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"ProjectionGeoKey values in the range 1024-32766 SHALL be valid EPSG map projection (coordinate operation) codes");
        } else {
            Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"ProjectionGeoKey values in the range 1-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"ProjectionGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params ProjMethodGeoKey (3075) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjMethodGeoKey() {
        int index = this.getKeyIndex(3075);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the ProjMethodGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((boolean)this.keyExists(3073), (String)"if the ProjectionMethodGeoKey value is 32767 (User-Defined) then the ProjectedCitationGeoKey ");
        } else {
            Assert.assertFalse((value >= 28 && value <= 32766 ? 1 : 0) != 0, (String)"ProjMethodGeoKey values in the range 28-32766 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"ProjMethodGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params ProjLinearUnitsGeoKey (3076) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjLinearUnitsGeoKey() throws IOException {
        int index = this.getKeyIndex(3076);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the ProjLinearUnitsGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(3073) && this.keyExists(3077) ? 1 : 0) != 0, (String)"a ProjLinearUnitsGeoKey value of 32767 SHALL be a user-defined linear unit. If the value is 32767 (User-Defined) then the ProjectedCitationGeoKey and the ProjLinearUnitSizeGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("unit-of-measure", "UOM_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"ProjLinearUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"ProjLinearUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
            Assert.assertTrue((boolean)record.get("UNIT_OF_MEAS_TYPE").equals("length"), (String)"ProjLinearUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
        } else {
            Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"ProjLinearUnitsGeoKey values in the range 1-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"ProjLinearUnitsGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params VerticalGeoKey (4096) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyVerticalGeoKey() throws IOException {
        int index = this.getKeyIndex(4096);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the VerticalGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((this.keyExists(4097) && this.keyExists(4099) && this.keyExists(4098) ? 1 : 0) != 0, (String)"if the VerticalGeoKey value is 32767 (User-Defined) then the VerticalCitationGeoKey, the VerticalUnitsGeoKey and VerticalDatumGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("coordinate-reference-system", "COORD_REF_SYS_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"VerticalGeoKey values in the range 1024-32766 SHALL be\u00a0either\u00a0EPSG Vertical CRS Codes\u00a0or\u00a0EPSG geographic 3D CRS codes");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"VerticalGeoKey values in the range 1024-32766 SHALL be\u00a0either\u00a0EPSG Vertical CRS Codes\u00a0or\u00a0EPSG geographic 3D CRS codes");
            Assert.assertTrue((record.get("COORD_REF_SYS_KIND").equals("vertical") || record.get("COORD_REF_SYS_KIND").equals("geographic 3D") ? 1 : 0) != 0, (String)"VerticalGeoKey values in the range 1024-32766 SHALL be\u00a0either\u00a0EPSG Vertical CRS Codes\u00a0or\u00a0EPSG geographic 3D CRS codes");
        } else {
            Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"VerticalGeoKey values in the range 1-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"VerticalGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params VerticalDatumGeoKey (2050) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyVerticalDatumGeoKey() throws IOException {
        int index = this.getKeyIndex(4098);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the VerticalDatumGeoKey SHALL have type = SHORT");
        if (value == Short.MAX_VALUE) {
            Assert.assertTrue((boolean)this.keyExists(4097), (String)"if the VerticalDatumGeoKey value is 32767 (User-Defined) then the VerticalCitationGeoKey SHALL be populated");
        } else if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("datum", "DATUM_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"VerticalDatumGeoKey values in the range 1024-32766 SHALL be EPSG vertical datum codes");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"VerticalDatumGeoKey values in the range 1024-32766 SHALL be EPSG vertical datum codes");
            Assert.assertTrue((boolean)record.get("DATUM_TYPE").equals("vertical"), (String)"VerticalDatumGeoKey values in the range 1024-32766 SHALL be EPSG vertical datum codes");
        } else {
            Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"VerticalDatumGeoKey values in the range 1-1023 SHALL be reserved");
            Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"VerticalDatumGeoKey value out of bounds");
        }
    }

    @Test(description="Short Params VerticalUnitsGeoKey (4099) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyVerticalUnitsGeoKey() throws IOException {
        int index = this.getKeyIndex(4099);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        int value = this.processFourthShortForShort(index, keyLength);
        Assert.assertTrue((type == 0 || type == 34735 ? 1 : 0) != 0, (String)"the VerticalUnitsGeoKey SHALL have type = SHORT");
        Assert.assertFalse((value == Short.MAX_VALUE ? 1 : 0) != 0, (String)"a VerticalUnitsGeoKey value of 32767 (user defined) SHALL not be used");
        if (value >= 1024 && value <= 32766) {
            CSVRecord record = EPSGDataSet.getRecord("unit-of-measure", "UOM_CODE", Integer.toString(value));
            Assert.assertTrue((record != null ? 1 : 0) != 0, (String)"VerticalUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
            Assert.assertTrue((boolean)record.get("DEPRECATED").equals("0"), (String)"VerticalUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
            Assert.assertTrue((boolean)record.get("UNIT_OF_MEAS_TYPE").equals("length"), (String)"VerticalUnitsGeoKey values in the range 1024-32766 SHALL be EPSG Unit Of Measure (UOM) codes with type = length");
        }
        Assert.assertFalse((value >= 1 && value <= 1023 ? 1 : 0) != 0, (String)"VerticalUnitsGeoKey values in the range 1-1023 SHALL be reserved");
        Assert.assertFalse((value > 65535 || value < 0 ? 1 : 0) != 0, (String)"VerticalUnitsGeoKey value out of bounds");
    }
}

