/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.warc.WarcRecordProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jwat.common.Diagnosis;
import org.jwat.common.Diagnostics;
import org.jwat.common.InputStreamNoSkip;
import org.jwat.common.RandomAccessFileInputStream;
import org.jwat.common.UriProfile;
import org.jwat.warc.WarcReader;
import org.jwat.warc.WarcReaderFactory;
import org.jwat.warc.WarcRecord;

public class WarcModule
extends ModuleBase {
    private static final Agent KB_AGENT = new Agent.Builder("Royal Library of Denmark", AgentType.STANDARD).address("S\u00f8ren Kierkegaards Plads 1, 1219 K\u00f8benhavn K, Denmark").fax("+45 3393 2218").web("http://kb.dk").build();
    private static final String NAME = "WARC-kb";
    private static final String RELEASE = "1.0";
    private static final int[] DATE = new int[]{2015, 12, 7};
    private static final String[] FORMAT = new String[]{"WARC", "WARC, Web ARChive file format"};
    private static final String COVERAGE = "WARC, 28500:2009";
    private static final String[] MIMETYPE = new String[]{"application/warc", "application/warc-fields"};
    private static final String WELLFORMED = "";
    private static final String VALIDITY = "The file is well-formed";
    private static final String REPINFO = "";
    private static final String NOTE = "";
    private static final String RIGHTS = "Copyright 2015 by The Royal Library of Denmark. Released under the GNU Lesser General Public License.";
    private static final Boolean DEFAULT_COMPUTE_BLOCK_DIGEST = true;
    private static final String DEFAULT_BLOCK_DIGEST_ALGORITHM = "sha1";
    private static final String DEFAULT_BLOCK_DIGEST_ENCODING = "base32";
    private static final Boolean DEFAULT_COMPUTE_PAYLOAD_DIGEST = true;
    private static final String DEFAULT_PAYLOAD_DIGEST_ALGORITHM = "sha1";
    private static final String DEFAULT_PAYLOAD_DIGEST_ENCODING = "base32";
    private static final Boolean DEFAULT_STRICT_TARGET_URI_VALIDATION = false;
    private static final Boolean DEFAULT_STRICT_URI_VALIDATION = false;
    private boolean bComputeBlockDigest;
    private String blockDigestAlgorithm;
    private String blockDigestEncoding;
    private boolean bComputePayloadDigest;
    private String payloadDigestAlgorithm;
    private String payloadDigestEncoding;
    private boolean bStrictTargetUriValidation;
    private boolean bStrictUriValidation;
    private Map<String, Integer> versions;
    private List<Property> recordProperties;

    public WarcModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, "", VALIDITY, "", "", RIGHTS, false);
        this.setVendorAndSpecification();
        this.initialiseVariables();
    }

    private void setVendorAndSpecification() {
        this._vendor = KB_AGENT;
        Document doc = new Document("WARC (Web ARChive) file format", DocumentType.WEB);
        doc.setPublisher(Agent.newIsoInstance());
        doc.setDate("2009");
        doc.setIdentifier(new Identifier("28500:2009", IdentifierType.ISO));
        this._specification.add(doc);
    }

    private void initialiseVariables() {
        this.versions = new HashMap<String, Integer>();
        this.recordProperties = new ArrayList<Property>();
        this.bComputeBlockDigest = DEFAULT_COMPUTE_BLOCK_DIGEST;
        this.blockDigestAlgorithm = "sha1";
        this.blockDigestEncoding = "base32";
        this.bComputePayloadDigest = DEFAULT_COMPUTE_PAYLOAD_DIGEST;
        this.payloadDigestAlgorithm = "sha1";
        this.payloadDigestEncoding = "base32";
        this.bStrictTargetUriValidation = DEFAULT_STRICT_TARGET_URI_VALIDATION;
        this.bStrictUriValidation = DEFAULT_STRICT_URI_VALIDATION;
    }

    @Override
    public void resetParams() throws Exception {
        this.initialiseVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(RandomAccessFile file, RepInfo info) throws IOException {
        RandomAccessFileInputStream stream = null;
        try {
            stream = new RandomAccessFileInputStream(file);
            this.parse(stream, info, 0);
        }
        finally {
            if (stream != null) {
                ((InputStream)stream).close();
                stream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        WarcReader reader = WarcReaderFactory.getReader(new InputStreamNoSkip(stream), 8192);
        try {
            this.setReaderOptions(reader);
            this.parseRecords(reader);
            info.setValid(reader.isCompliant());
            info.setWellFormed(reader.isCompliant());
            this.reportResults(reader, info);
            info.setSigMatch(this._name);
            info.setFormat(this._format[0]);
            info.setMimeType(this._mimeType[0]);
        }
        catch (JhoveException e) {
            info.setMessage(new ErrorMessage(e.getMessage()));
            info.setValid(false);
            info.setWellFormed(false);
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        return 0;
    }

    protected void setReaderOptions(WarcReader reader) throws JhoveException {
        reader.setBlockDigestEnabled(this.bComputeBlockDigest);
        reader.setPayloadDigestEnabled(this.bComputePayloadDigest);
        if (!reader.setBlockDigestAlgorithm(this.blockDigestAlgorithm)) {
            throw new JhoveException("Invalid block digest algorithm: " + this.blockDigestAlgorithm);
        }
        if (!reader.setPayloadDigestAlgorithm(this.payloadDigestAlgorithm)) {
            throw new JhoveException("Invalid payload digest algorithm: " + this.payloadDigestAlgorithm);
        }
        reader.setBlockDigestEncoding(this.blockDigestEncoding);
        reader.setPayloadDigestEncoding(this.payloadDigestEncoding);
        if (this.bStrictTargetUriValidation) {
            reader.setWarcTargetUriProfile(UriProfile.RFC3986);
        } else {
            reader.setWarcTargetUriProfile(UriProfile.RFC3986_ABS_16BIT_LAX);
        }
        if (this.bStrictUriValidation) {
            reader.setUriProfile(UriProfile.RFC3986);
        } else {
            reader.setUriProfile(UriProfile.RFC3986_ABS_16BIT_LAX);
        }
    }

    protected void parseRecords(WarcReader reader) throws IOException, JhoveException {
        if (reader != null) {
            WarcRecord record;
            while ((record = reader.getNextRecord()) != null) {
                this.processRecord(record);
                reader.diagnostics.addAll(record.diagnostics);
            }
        } else {
            throw new JhoveException("WarcReader has not been properly instantiated.");
        }
    }

    protected void processRecord(WarcRecord record) throws IOException, JhoveException {
        if (record.header.bValidVersionFormat) {
            Integer count = this.versions.get(record.header.versionStr);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this.versions.put(record.header.versionStr, count);
        }
        WarcRecordProperties properties = new WarcRecordProperties(record);
        Property p = new Property("Record", PropertyType.STRING, PropertyArity.MAP, properties.getProperties());
        this.recordProperties.add(p);
        record.close();
    }

    private void reportResults(WarcReader reader, RepInfo repInfo) throws JhoveException, IOException {
        Diagnostics<Diagnosis> diagnostics = reader.diagnostics;
        if (diagnostics.hasErrors()) {
            for (Diagnosis d : diagnostics.getErrors()) {
                repInfo.setMessage(new ErrorMessage(this.extractDiagnosisType(d), this.extractDiagnosisMessage(d)));
            }
            repInfo.setConsistent(false);
        }
        if (diagnostics.hasWarnings()) {
            for (Diagnosis d : diagnostics.getWarnings()) {
                repInfo.setMessage(new InfoMessage(this.extractDiagnosisType(d), this.extractDiagnosisMessage(d)));
            }
        }
        int maxCount = -1;
        for (Map.Entry<String, Integer> e : this.versions.entrySet()) {
            if (e.getValue() > maxCount) {
                maxCount = e.getValue();
                repInfo.setVersion(e.getKey());
            }
            this._features.add(e.getValue() + " WARC records of version " + e.getKey());
        }
        repInfo.setProperty(new Property("Records", PropertyType.PROPERTY, PropertyArity.LIST, this.recordProperties));
        repInfo.setSize(reader.getConsumed());
    }

    private String extractDiagnosisType(Diagnosis d) {
        return d.type.name();
    }

    private String extractDiagnosisMessage(Diagnosis d) {
        StringBuilder res = new StringBuilder();
        res.append("Entity: " + d.entity);
        for (String i : d.information) {
            res.append(", " + i);
        }
        return res.toString();
    }
}

