/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.AssocDataListChunk;
import edu.harvard.hul.ois.jhove.module.wave.BroadcastExtChunk;
import edu.harvard.hul.ois.jhove.module.wave.CartChunk;
import edu.harvard.hul.ois.jhove.module.wave.CueChunk;
import edu.harvard.hul.ois.jhove.module.wave.DataChunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import edu.harvard.hul.ois.jhove.module.wave.FactChunk;
import edu.harvard.hul.ois.jhove.module.wave.FormatChunk;
import edu.harvard.hul.ois.jhove.module.wave.InstrumentChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LinkChunk;
import edu.harvard.hul.ois.jhove.module.wave.ListInfoChunk;
import edu.harvard.hul.ois.jhove.module.wave.MpegChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import edu.harvard.hul.ois.jhove.module.wave.PeakEnvelopeChunk;
import edu.harvard.hul.ois.jhove.module.wave.SampleChunk;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class WaveModule
extends ModuleBase {
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    protected List<Property> _propList;
    protected List<Property> _notes;
    protected List<Property> _labels;
    protected List<Property> _labeledText;
    protected List<Property> _samples;
    protected AESAudioMetadata _aesMetadata;
    protected long bytesRemaining;
    protected int _blockAlign;
    protected ExifInfo _exifInfo;
    protected int compressionCode;
    protected long numSamples;
    protected long sampleRate;
    protected boolean formatChunkSeen;
    protected boolean factChunkSeen;
    protected boolean dataChunkSeen;
    protected boolean instrumentChunkSeen;
    protected boolean mpegChunkSeen;
    protected boolean cartChunkSeen;
    protected boolean broadcastExtChunkSeen;
    protected boolean peakChunkSeen;
    protected boolean linkChunkSeen;
    protected boolean cueChunkSeen;
    protected boolean flagPCMWaveFormat;
    protected boolean flagWaveFormatEx;
    protected boolean flagWaveFormatExtensible;
    protected boolean flagBroadcastWave;
    protected int broadcastVersion;
    protected boolean firstSampleOffsetMarked;
    private static final int[] sigByte = new int[]{82, 73, 70, 70};
    private static final String NAME = "WAVE-hul";
    private static final String RELEASE = "1.4";
    private static final int[] DATE = new int[]{2017, 3, 14};
    private static final String[] FORMAT = new String[]{"WAVE", "Audio for Windows", "EBU Technical Specification 3285", "Broadcast Wave Format", "BWF"};
    private static final String COVERAGE = "WAVE (WAVEFORMAT, PCMWAVEFORMAT, WAVEFORMATEX, WAVEFORMATEXTENSIBLE), Broadcast Wave Format (BWF) version 0 and 1";
    private static final String[] MIMETYPE = new String[]{"audio/x-wave", "audio/wave"};
    private static final String WELLFORMED = null;
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "There is no published standard for WAVE files. This module regards a file as valid if it conforms to common usage practices.";
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";

    public WaveModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Agent msagent = new Agent.Builder("Microsoft Corporation", AgentType.COMMERCIAL).address(" One Microsoft Way, Redmond, WA 98052-6399").telephone("+1 (800) 426-9400").web("http://www.microsoft.com").build();
        Document doc = new Document("PCMWAVEFORMAT", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_pcmwaveformat_str.asp", IdentifierType.URL));
        doc.setPublisher(msagent);
        this._specification.add(doc);
        doc = new Document("WAVEFORMATEX", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatex_str.asp", IdentifierType.URL));
        doc.setPublisher(msagent);
        this._specification.add(doc);
        doc = new Document("WAVEFORMATEXTENSIBLE", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatextensible_str.asp", IdentifierType.URL));
        doc.setPublisher(msagent);
        this._specification.add(doc);
        Agent agent = new Agent.Builder("European Broadcasting Union", AgentType.COMMERCIAL).address("Casa postale 45, Ancienne Route 17A, CH-1218 Grand-Saconex, Geneva, Switzerland").telephone("+ 41 (0)22 717 2111").fax("+ 41 (0)22 747 4000").email("techreview@ebu.ch").web("http://www.ebu.ch").build();
        doc = new Document("Broadcast Wave Format (EBU N22-1987)", DocumentType.REPORT);
        doc.setIdentifier(new Identifier("http://www.ebu.ch/CMSimages/en/tec_doc_t3285_tcm6-10544.pdf", IdentifierType.URL));
        doc.setPublisher(agent);
        this._specification.add(doc);
        Signature sig = new ExternalSignature(".wav", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".bwf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For BWF profile");
        this._signature.add(sig);
        sig = new InternalSignature("RIFF", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0);
        this._signature.add(sig);
        sig = new InternalSignature("WAVE", SignatureType.MAGIC, SignatureUseType.MANDATORY, 8);
        this._signature.add(sig);
        this._bigEndian = false;
    }

    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        this.initParse();
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        this._aesMetadata.setPrimaryIdentifier(info.getUri());
        if (info.getURLFlag()) {
            this._aesMetadata.setOtherPrimaryIdentifierType("URI");
        } else {
            this._aesMetadata.setPrimaryIdentifierType("FILE_NAME");
        }
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(stream, this._ckSummer);
            this._dstream = WaveModule.getBufferedDataStream(this._cstream, this._je != null ? this._je.getBufferSize() : 0);
        } else {
            this._dstream = WaveModule.getBufferedDataStream(stream, this._je != null ? this._je.getBufferSize() : 0);
        }
        try {
            for (int i = 0; i < 4; ++i) {
                int ch = WaveModule.readUnsignedByte(this._dstream, this);
                if (ch == sigByte[i]) continue;
                info.setMessage(new ErrorMessage("Document does not start with RIFF chunk", 0L));
                info.setWellFormed(false);
                return 0;
            }
            info.setSigMatch(this._name);
            this.bytesRemaining = this.readUnsignedInt(this._dstream);
            String typ = this.read4Chars(this._dstream);
            this.bytesRemaining -= 4L;
            if (!"WAVE".equals(typ)) {
                info.setMessage(new ErrorMessage("File type in RIFF header is not WAVE", this._nByte));
                info.setWellFormed(false);
                return 0;
            }
            while (this.bytesRemaining > 0L && this.readChunk(info)) {
            }
        }
        catch (EOFException e) {
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Unexpected end of file", this._nByte));
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            info.setWellFormed(false);
            info.setMessage(new ErrorMessage("Exception reading file: " + e.getClass().getName() + ", " + e.getMessage(), this._nByte));
            return 0;
        }
        if (this.numSamples > 0L) {
            this._aesMetadata.setDuration(this.numSamples);
        }
        if (!this._labels.isEmpty()) {
            this._propList.add(new Property("Labels", PropertyType.PROPERTY, PropertyArity.LIST, this._labels));
        }
        if (!this._labeledText.isEmpty()) {
            this._propList.add(new Property("LabeledText", PropertyType.PROPERTY, PropertyArity.LIST, this._labeledText));
        }
        if (!this._notes.isEmpty()) {
            this._propList.add(new Property("Notes", PropertyType.PROPERTY, PropertyArity.LIST, this._notes));
        }
        if (!this._samples.isEmpty()) {
            this._propList.add(new Property("Samples", PropertyType.PROPERTY, PropertyArity.LIST, this._samples));
        }
        if (this._exifInfo != null) {
            this._propList.add(this._exifInfo.buildProperty());
        }
        if (!this.formatChunkSeen) {
            info.setMessage(new ErrorMessage("No Format Chunk"));
            info.setWellFormed(false);
            return 0;
        }
        if (this._ckSummer != null) {
            try {
                long n;
                while ((n = this.skipBytes(this._dstream, 2048L, this)) != 0L) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            info.setSize(this._cstream.getNBytes());
            info.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            String value = this._ckSummer.getMD5();
            if (value != null) {
                info.setChecksum(new Checksum(value, ChecksumType.MD5));
            }
            if ((value = this._ckSummer.getSHA1()) != null) {
                info.setChecksum(new Checksum(value, ChecksumType.SHA1));
            }
        }
        info.setProperty(this._metadata);
        if (this.flagPCMWaveFormat) {
            info.setProfile("PCMWAVEFORMAT");
        }
        if (this.flagWaveFormatEx) {
            info.setProfile("WAVEFORMATEX");
        }
        if (this.flagWaveFormatExtensible) {
            info.setProfile("WAVEFORMATEXTENSIBLE");
        }
        if (this.flagBroadcastWave) {
            if (!this.broadcastExtChunkSeen) {
                this.flagBroadcastWave = false;
            }
            if (!(this.compressionCode != 80 || this.broadcastExtChunkSeen && this.factChunkSeen)) {
                this.flagBroadcastWave = false;
            }
            if (this.flagBroadcastWave) {
                String prof = null;
                switch (this.broadcastVersion) {
                    case 0: {
                        prof = "Broadcast Wave Version 0";
                        break;
                    }
                    case 1: {
                        prof = "Broadcast Wave Version 1";
                    }
                }
                if (prof != null) {
                    info.setProfile(prof);
                }
            }
        }
        return 0;
    }

    public void markFirstSampleOffset() {
        if (!this.firstSampleOffsetMarked) {
            this.firstSampleOffsetMarked = true;
            this._aesMetadata.setFirstSampleOffset(this._nByte);
        }
    }

    public void setExifInfo(ExifInfo exifInfo) {
        this._exifInfo = exifInfo;
    }

    public void setBlockAlign(int align) {
        this._blockAlign = align;
    }

    public ExifInfo getExifInfo() {
        return this._exifInfo;
    }

    public int getCompressionCode() {
        return this.compressionCode;
    }

    public int getBlockAlign() {
        return this._blockAlign;
    }

    public void addWaveProperty(Property prop) {
        this._propList.add(prop);
    }

    public void addLabel(Property p) {
        this._labels.add(p);
    }

    public void addLabeledText(Property p) {
        this._labeledText.add(p);
    }

    public void addSample(Property p) {
        this._samples.add(p);
    }

    public void addNote(Property p) {
        this._notes.add(p);
    }

    public void addListInfo(List l) {
        this._propList.add(new Property("ListInfo", PropertyType.PROPERTY, PropertyArity.LIST, l));
    }

    public long readSignedLong(DataInputStream stream) throws IOException {
        return WaveModule.readSignedLong(stream, false, this);
    }

    public long readUnsignedInt(DataInputStream stream) throws IOException {
        return WaveModule.readUnsignedInt(stream, false, this);
    }

    public int readSignedInt(DataInputStream stream) throws IOException {
        return WaveModule.readSignedInt(stream, false, this);
    }

    public int readUnsignedShort(DataInputStream stream) throws IOException {
        return WaveModule.readUnsignedShort(stream, false, this);
    }

    public int readSignedShort(DataInputStream stream) throws IOException {
        return WaveModule.readSignedShort(stream, false, this);
    }

    public String read4Chars(DataInputStream stream) throws IOException {
        StringBuffer sbuf = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int ch = WaveModule.readUnsignedByte(stream, this);
            if (ch == 0) continue;
            sbuf.append((char)ch);
        }
        return sbuf.toString();
    }

    public void setCompressionCode(int cf) {
        this.compressionCode = cf;
    }

    public void addSamples(long samples) {
        this.numSamples += samples;
    }

    public void setSampleRate(long rate) {
        this.sampleRate = rate;
    }

    public void setPCMWaveFormat(boolean b) {
        this.flagPCMWaveFormat = b;
    }

    public void setWaveFormatEx(boolean b) {
        this.flagWaveFormatEx = b;
    }

    public void setWaveFormatExtensible(boolean b) {
        this.flagWaveFormatExtensible = b;
    }

    public void setBroadcastWave(boolean b) {
        this.flagBroadcastWave = b;
    }

    public void setBroadcastVersion(int version) {
        this.broadcastVersion = version;
    }

    @Override
    protected void initParse() {
        super.initParse();
        this._propList = new LinkedList<Property>();
        this._notes = new LinkedList<Property>();
        this._labels = new LinkedList<Property>();
        this._labeledText = new LinkedList<Property>();
        this._samples = new LinkedList<Property>();
        this.firstSampleOffsetMarked = false;
        this.numSamples = 0L;
        this._metadata = new Property("WAVEMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._aesMetadata = new AESAudioMetadata();
        this._aesMetadata.setByteOrder(1);
        this._aesMetadata.setAnalogDigitalFlag("FILE_DIGITAL");
        this._aesMetadata.setFormat("WAVE");
        this._aesMetadata.setUse("OTHER", "JHOVE_validation");
        this._aesMetadata.setDirection("NONE");
        this._propList.add(new Property("AESAudioMetadata", PropertyType.AESAUDIOMETADATA, this._aesMetadata));
        this.formatChunkSeen = false;
        this.dataChunkSeen = false;
        this.instrumentChunkSeen = false;
        this.cartChunkSeen = false;
        this.mpegChunkSeen = false;
        this.broadcastExtChunkSeen = false;
        this.peakChunkSeen = false;
        this.linkChunkSeen = false;
        this.cueChunkSeen = false;
        this.flagPCMWaveFormat = false;
        this.flagWaveFormatEx = false;
        this.flagWaveFormatExtensible = false;
        this.flagBroadcastWave = false;
    }

    protected boolean readChunk(RepInfo info) throws IOException {
        long chunkSize;
        block46: {
            Chunk chunk = null;
            ChunkHeader chunkh = new ChunkHeader(this, info);
            if (!chunkh.readHeader(this._dstream)) {
                return false;
            }
            chunkSize = chunkh.getSize();
            this.bytesRemaining -= chunkSize + 8L;
            if (this.bytesRemaining < 0L) {
                info.setMessage(new ErrorMessage("Invalid chunk size", this._nByte));
                return false;
            }
            String id = chunkh.getID();
            if ("fmt ".equals(id)) {
                if (this.formatChunkSeen) {
                    this.dupChunkError(info, "Format");
                }
                chunk = new FormatChunk(this, chunkh, this._dstream);
                this.formatChunkSeen = true;
            } else if ("data".equals(id)) {
                if (this.dataChunkSeen) {
                    this.dupChunkError(info, "Data");
                }
                chunk = new DataChunk(this, chunkh, this._dstream);
                this.dataChunkSeen = true;
            } else if ("fact".equals(id)) {
                chunk = new FactChunk(this, chunkh, this._dstream);
                this.factChunkSeen = true;
            } else if ("note".equals(id)) {
                chunk = new NoteChunk(this, chunkh, this._dstream);
            } else if ("labl".equals(id)) {
                chunk = new LabelChunk(this, chunkh, this._dstream);
            } else if ("list".equals(id)) {
                chunk = new AssocDataListChunk(this, chunkh, this._dstream, info);
            } else if ("LIST".equals(id)) {
                chunk = new ListInfoChunk(this, chunkh, this._dstream, info);
            } else if ("smpl".equals(id)) {
                chunk = new SampleChunk(this, chunkh, this._dstream);
            } else if ("inst".equals(id)) {
                if (this.instrumentChunkSeen) {
                    this.dupChunkError(info, "Instrument");
                }
                chunk = new InstrumentChunk(this, chunkh, this._dstream);
                this.instrumentChunkSeen = true;
            } else if ("mext".equals(id)) {
                if (this.mpegChunkSeen) {
                    this.dupChunkError(info, "MPEG");
                }
                chunk = new MpegChunk(this, chunkh, this._dstream);
                this.mpegChunkSeen = true;
            } else if ("cart".equals(id)) {
                if (this.cartChunkSeen) {
                    this.dupChunkError(info, "Cart");
                }
                chunk = new CartChunk(this, chunkh, this._dstream);
                this.cartChunkSeen = true;
            } else if ("bext".equals(id)) {
                if (this.broadcastExtChunkSeen) {
                    this.dupChunkError(info, "Broadcast Audio Extension");
                }
                chunk = new BroadcastExtChunk(this, chunkh, this._dstream);
                this.broadcastExtChunkSeen = true;
            } else if ("levl".equals(id)) {
                if (this.peakChunkSeen) {
                    this.dupChunkError(info, "Peak Envelope");
                }
                chunk = new PeakEnvelopeChunk(this, chunkh, this._dstream);
                this.peakChunkSeen = true;
            } else if ("link".equals(id)) {
                if (this.linkChunkSeen) {
                    this.dupChunkError(info, "Link");
                }
                chunk = new LinkChunk(this, chunkh, this._dstream);
                this.linkChunkSeen = true;
            } else if ("cue ".equals(id)) {
                if (this.cueChunkSeen) {
                    this.dupChunkError(info, "Cue");
                }
                chunk = new CueChunk(this, chunkh, this._dstream);
                this.cueChunkSeen = true;
            } else {
                info.setMessage(new InfoMessage("Chunk type '" + id + "' ignored", this._nByte));
            }
            if (chunk != null) {
                try {
                    if (!((Chunk)chunk).readChunk(info)) {
                        return false;
                    }
                    break block46;
                }
                catch (JhoveException e) {
                    info.setMessage(new ErrorMessage(e.getMessage()));
                    info.setWellFormed(false);
                    return false;
                }
            }
            this.skipBytes(this._dstream, chunkSize, this);
        }
        if ((chunkSize & 1L) != 0L) {
            this.skipBytes(this._dstream, 1L, this);
            --this.bytesRemaining;
        }
        return true;
    }

    public AESAudioMetadata getAESMetadata() {
        return this._aesMetadata;
    }

    protected void dupChunkError(RepInfo info, String chunkName) {
        info.setMessage(new ErrorMessage("Multiple " + chunkName + " Chunks not permitted", this._nByte));
        info.setValid(false);
    }

    public Property buildBitmaskProperty(int val, String name, String[] oneValueNames, String[] zeroValueNames) {
        if (this._je != null && this._je.getShowRawFlag()) {
            return new Property(name, PropertyType.INTEGER, new Integer(val));
        }
        LinkedList<String> slist = new LinkedList<String>();
        try {
            for (int i = 0; i < oneValueNames.length; ++i) {
                String s = null;
                s = (val & 1 << i) != 0 ? oneValueNames[i] : zeroValueNames[i];
                if (s == null || s.length() <= 0) continue;
                slist.add(s);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Property(name, PropertyType.STRING, PropertyArity.LIST, slist);
    }
}

