/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class ApplicationChunk
extends Chunk {
    public ApplicationChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        String applicationSignature = module.read4Chars(this._dstream);
        byte[] data = new byte[(int)(this.bytesLeft - 4L)];
        ModuleBase.readByteBuf(this._dstream, data, this._module);
        Property[] propArr = new Property[2];
        propArr[0] = new Property("ApplicationSignature", PropertyType.STRING, applicationSignature);
        AESAudioMetadata aes = module.getAESMetadata();
        aes.setAppSpecificData(applicationSignature);
        if ("stoc".equals(applicationSignature) || "pdos".equals(applicationSignature)) {
            String appName = module.readPascalString(this._dstream);
            this.bytesLeft -= (long)(appName.length() + 1);
            module.skipBytes(this._dstream, (int)this.bytesLeft, module);
            propArr[1] = new Property("ApplicationName", PropertyType.STRING, appName);
        } else {
            propArr[1] = new Property("Data", PropertyType.BYTE, PropertyArity.ARRAY, data);
        }
        module.addAiffProperty(new Property("Application", PropertyType.PROPERTY, PropertyArity.ARRAY, propArr));
        return true;
    }
}

