/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class DigSignatureBox
extends JP2Box {
    public DigSignatureBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        int sizeLeft = (int)this._boxHeader.getDataLength();
        ArrayList<Property> propList = new ArrayList<Property>(10);
        JhoveBase je = this._module.getBase();
        boolean raw = je.getShowRawFlag();
        int styp = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        if (styp > 5) {
            this._repInfo.setMessage(new ErrorMessage("Unknown digital signature type", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        propList.add(this._module.addIntegerProperty("Type", styp, JP2Strings.digitalSigTypeStr));
        int ptyp = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        if (ptyp > 1) {
            this._repInfo.setMessage(new ErrorMessage("Unknown digital signature pointer type", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        propList.add(this._module.addIntegerProperty("PointerType", styp, JP2Strings.digitalSigPtrTypeStr));
        sizeLeft -= 2;
        long off = 0L;
        long len = 0L;
        if (ptyp == 1) {
            off = this._module.readSignedLong(this._dstrm);
            len = this._module.readSignedLong(this._dstrm);
            propList.add(new Property("Offset", PropertyType.LONG, new Long(off)));
            propList.add(new Property("Length", PropertyType.LONG, new Long(len)));
            sizeLeft -= 8;
        }
        byte[] data = new byte[sizeLeft];
        ModuleBase.readByteBuf(this._dstrm, data, this._module);
        if (styp == 0 || styp == 1) {
            try {
                if (ptyp == 0) {
                    off = 0L;
                    len = this._raf.length();
                }
                propList.add(new Property("Valid", PropertyType.BOOLEAN, new Boolean(this.isSigValid(styp, off, len, data))));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._module.addDigitalSignatureProp(new Property("DigitalSignature", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Digital Signature Box";
    }

    private boolean isSigValid(int styp, long off, long len, byte[] data) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = styp == 0 ? MessageDigest.getInstance("MD5") : MessageDigest.getInstance("SHA-1");
        try {
            this._raf.seek(off);
            int buflen = len < 65536L ? (int)len : 65536;
            byte[] buf = new byte[buflen];
            while (len > 0L) {
                int btr = len < (long)buflen ? (int)len : buflen;
                int bytesRead = this._raf.read(buf, 0, btr);
                digest.update(buf, 0, bytesRead);
            }
            byte[] digestVal = digest.digest();
            if (digestVal.length != data.length) {
                return false;
            }
            for (int i = 0; i < data.length; ++i) {
                if (digestVal[i] == data[i]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

