/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class CrossRefStream {
    private PdfStream _xstrm;
    private PdfDictionary _dict;
    private int _size;
    private IndexRange[] _index;
    private int[] _fieldSizes;
    private int _freeCount;
    private Filter[] _filters;
    private int _readRange;
    private int _readIndex;
    private int _bytesPerEntry;
    private long _prevXref;
    private int _objType;
    private int _objNum;
    private int _objField1;
    private int _objField2;

    public CrossRefStream(PdfStream xstrm) {
        this._xstrm = xstrm;
        this._dict = xstrm.getDict();
        this._freeCount = 0;
    }

    public boolean isValid() {
        try {
            PdfObject prevObj;
            PdfObject wObj;
            PdfObject typeObj = this._dict.get("Type");
            String typeStr = null;
            if (typeObj instanceof PdfSimpleObject && !"XRef".equals(typeStr = ((PdfSimpleObject)typeObj).getStringValue())) {
                return false;
            }
            if (typeStr == null) {
                return false;
            }
            PdfObject sizeObj = this._dict.get("Size");
            if (!(sizeObj instanceof PdfSimpleObject)) {
                return false;
            }
            this._size = ((PdfSimpleObject)sizeObj).getIntValue();
            PdfObject indexObj = this._dict.get("Index");
            if (indexObj instanceof PdfArray) {
                Vector<PdfObject> indexObjs = ((PdfArray)indexObj).getContent();
                int indexObjCount = indexObjs.size();
                if (indexObjCount % 2 != 0) {
                    return false;
                }
                this._index = new IndexRange[indexObjCount / 2];
                for (int i = 0; i < this._index.length; ++i) {
                    this._index[i].start = ((PdfSimpleObject)indexObjs.get(i * 2)).getIntValue();
                    this._index[i].len = ((PdfSimpleObject)indexObjs.get(i * 2 + 1)).getIntValue();
                }
            } else {
                this._index = new IndexRange[1];
                this._index[0].start = 0;
                this._index[0].len = this._size;
            }
            if ((wObj = this._dict.get("W")) instanceof PdfArray) {
                Vector<PdfObject> vec = ((PdfArray)wObj).getContent();
                int len = vec.size();
                this._fieldSizes = new int[len];
                for (int i = 0; i < len; ++i) {
                    PdfSimpleObject ob = (PdfSimpleObject)vec.get(i);
                    this._fieldSizes[i] = ob.getIntValue();
                }
            }
            this._prevXref = (prevObj = this._dict.get("Prev")) instanceof PdfSimpleObject ? (long)((PdfSimpleObject)prevObj).getIntValue() : -1L;
            this._filters = this._xstrm.getFilters();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void initRead(RandomAccessFile raf) throws IOException, PdfException {
        Stream strm = this._xstrm.getStream();
        strm.setFilters(this._xstrm.getFilters());
        strm.initRead(raf);
        this._readRange = 0;
        this._readIndex = 0;
        this._bytesPerEntry = 0;
        for (int i = 0; i < this._fieldSizes.length; ++i) {
            this._bytesPerEntry += this._fieldSizes[i];
        }
    }

    public boolean readNextObject() throws IOException {
        Stream is = this._xstrm.getStream();
        while (true) {
            int b;
            int i;
            int wid = this._fieldSizes[0];
            if (this._readIndex++ >= this._index[this._readRange].len) {
                this._readIndex = 1;
                if (this._readRange++ >= this._index.length) {
                    return false;
                }
            }
            if (wid != 0) {
                this._objType = 0;
                for (i = 0; i < wid; ++i) {
                    b = is.read();
                    if (b < 0) {
                        return false;
                    }
                    this._objType = this._objType * 256 + b;
                }
            } else {
                this._objType = 1;
            }
            wid = this._fieldSizes[1];
            this._objField1 = 0;
            for (i = 0; i < wid; ++i) {
                b = is.read();
                if (b < 0) {
                    return false;
                }
                this._objField1 = this._objField1 * 256 + b;
            }
            wid = this._fieldSizes[2];
            this._objField2 = 0;
            for (i = 0; i < wid; ++i) {
                b = is.read();
                if (b < 0) {
                    return false;
                }
                this._objField2 = this._objField2 * 256 + b;
            }
            if (this._objType != 0) {
                this._objNum = this._index[this._readRange].start + this._readIndex - 1;
                return true;
            }
            ++this._freeCount;
        }
    }

    public int getObjNum() {
        return this._objNum;
    }

    public boolean isObjCompressed() {
        return this._objType == 2;
    }

    public int getFreeCount() {
        return this._freeCount;
    }

    public int getCrossRefTableSize() {
        return this._size;
    }

    public int getOffset() {
        return this._objField1;
    }

    public int getContentStreamObjNum() {
        return this._objField1;
    }

    public long getPrevXref() {
        return this._prevXref;
    }

    public int getContentStreamIndex() {
        return this._objField2;
    }

    private class IndexRange {
        public int start;
        public int len;

        private IndexRange() {
        }
    }
}

