/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileClassY
extends TiffProfile {
    public TiffProfileClassY() {
        this._profileText = "Extension YCbCr (Class Y)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getImageWidth() == -1L || niso.getImageLength() == -1L || niso.getStripOffsets() == null || niso.getRowsPerStrip() == -1L || niso.getStripByteCounts() == null || niso.getXSamplingFrequency() == null || niso.getYSamplingFrequency() == null || niso.getReferenceBlackWhite() == null) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 3)) {
            return false;
        }
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps.length < 3 || bps[0] != 8 || bps[1] != 8 || bps[2] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 5, 6})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 6)) {
            return false;
        }
        return this.satisfiesResolutionUnit(tifd, new int[]{1, 2, 3});
    }
}

