/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.iff.Superchunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabeledTextChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import java.io.DataInputStream;
import java.io.IOException;

public class AssocDataListChunk
extends Superchunk {
    public AssocDataListChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm, RepInfo info) {
        super(module, hdr, dstrm, info);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        ChunkHeader chunkh;
        WaveModule module = (WaveModule)this._module;
        String typeID = module.read4Chars(this._dstream);
        if (!"adtl".equals(typeID)) {
            info.setMessage(new ErrorMessage("Unknown list type in Associated Data List Chunk", "Type = " + typeID, this._module.getNByte()));
            info.setWellFormed(false);
            return false;
        }
        while ((chunkh = this.getNextChunkHeader()) != null) {
            Chunk chunk = null;
            String id = chunkh.getID();
            int chunkSize = (int)chunkh.getSize();
            if (id.equals("labl")) {
                chunk = new LabelChunk(this._module, chunkh, this._dstream);
            } else if (id.equals("note")) {
                chunk = new NoteChunk(this._module, chunkh, this._dstream);
            } else if (id.equals("ltxt")) {
                chunk = new LabeledTextChunk(this._module, chunkh, this._dstream);
            }
            if (chunk == null) {
                this._module.skipBytes(this._dstream, chunkSize, this._module);
                info.setMessage(new InfoMessage("Chunk type '" + id + "' in Associated Data Chunk ignored"));
                continue;
            }
            try {
                if (((Chunk)chunk).readChunk(info)) continue;
                return false;
            }
            catch (JhoveException e) {
                info.setMessage(new ErrorMessage(e.getMessage()));
                info.setWellFormed(false);
                return false;
            }
        }
        return true;
    }
}

