/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.xml;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public final class XhtmlProcessing {
    protected static void processElement(String localName, String qualifiedName, Attributes atts, HtmlMetadata mdata) {
        if ("html".equals(localName)) {
            XhtmlProcessing.processHtml(mdata, atts);
        } else if ("meta".equals(localName)) {
            XhtmlProcessing.processMeta(mdata, atts);
        } else if ("a".equals(localName)) {
            XhtmlProcessing.processA(mdata, atts);
        } else if ("img".equals(localName)) {
            XhtmlProcessing.processImg(mdata, atts);
        } else if ("frame".equals(localName)) {
            XhtmlProcessing.processFrame(mdata, atts);
        } else if ("script".equals(localName)) {
            XhtmlProcessing.processScript(mdata, atts);
        } else if ("abbr".equals(localName)) {
            XhtmlProcessing.processAbbr(mdata, atts);
        } else if ("title".equals(localName)) {
            XhtmlProcessing.processTitle(mdata, atts);
        } else if ("cite".equals(localName)) {
            XhtmlProcessing.processCite(mdata, atts);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if (!"lang".equals(attname) || attval == null) continue;
            mdata.addLanguage(attval);
        }
    }

    private static void processHtml(HtmlMetadata mdata, Attributes atts) {
        String lang = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if (!"lang".equals(attname)) continue;
            lang = attval;
        }
        if (lang != null) {
            mdata.setLanguage(lang);
        }
    }

    private static void processMeta(HtmlMetadata mdata, Attributes atts) {
        String name = null;
        String httpeq = null;
        String content = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if ("name".equals(attname)) {
                name = attval;
            }
            if ("http-equiv".equals(attname)) {
                httpeq = attval;
            }
            if (!"content".equals(attname)) continue;
            content = attval;
        }
        if (name != null || httpeq != null || content != null) {
            ArrayList<Property> plist = new ArrayList<Property>(3);
            if (name != null) {
                plist.add(new Property("Name", PropertyType.STRING, name));
            }
            if (httpeq != null) {
                plist.add(new Property("Httpequiv", PropertyType.STRING, httpeq));
            }
            if (content != null) {
                plist.add(new Property("Content", PropertyType.STRING, content));
            }
            mdata.addMeta(new Property("Meta", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        }
    }

    private static void processA(HtmlMetadata mdata, Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if (!"href".equals(attname)) continue;
            String link = attval;
            if (link.length() <= 0 || link.charAt(0) == '#') break;
            mdata.addLink(link);
            break;
        }
    }

    private static void processImg(HtmlMetadata mdata, Attributes atts) {
        String alt = null;
        String longdesc = null;
        String src = null;
        int height = -1;
        int width = -1;
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if ("alt".equals(attname)) {
                alt = attval;
                continue;
            }
            if ("src".equals(attname)) {
                src = attval;
                continue;
            }
            if ("longdesc".equals(attname)) {
                longdesc = attval;
                continue;
            }
            if ("height".equals(attname)) {
                try {
                    height = Integer.parseInt(attval);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!"width".equals(attname)) continue;
            try {
                width = Integer.parseInt(attval);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<Property> plist = new ArrayList<Property>(5);
        if (alt != null) {
            plist.add(new Property("Alt", PropertyType.STRING, alt));
        }
        if (longdesc != null) {
            plist.add(new Property("Longdesc", PropertyType.STRING, longdesc));
        }
        if (src != null) {
            plist.add(new Property("Src", PropertyType.STRING, src));
        }
        if (height >= 0) {
            plist.add(new Property("Height", PropertyType.INTEGER, new Integer(height)));
        }
        if (width >= 0) {
            plist.add(new Property("Width", PropertyType.INTEGER, new Integer(width)));
        }
        if (!plist.isEmpty()) {
            mdata.addImage(new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        }
    }

    private static void processFrame(HtmlMetadata mdata, Attributes atts) {
        String name = null;
        String title = null;
        String src = null;
        String longdesc = null;
        int height = -1;
        int width = -1;
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if ("name".equals(attname)) {
                name = attval;
                continue;
            }
            if ("title".equals(attname)) {
                title = attval;
                continue;
            }
            if ("src".equals(attname)) {
                src = attval;
                continue;
            }
            if (!"longdesc".equals(attname)) continue;
            longdesc = attval;
        }
        ArrayList<Property> plist = new ArrayList<Property>(4);
        if (name != null) {
            plist.add(new Property("Name", PropertyType.STRING, name));
        }
        if (title != null) {
            plist.add(new Property("Title", PropertyType.STRING, title));
        }
        if (longdesc != null) {
            plist.add(new Property("Longdesc", PropertyType.STRING, longdesc));
        }
        if (src != null) {
            plist.add(new Property("Src", PropertyType.STRING, src));
        }
        if (!plist.isEmpty()) {
            mdata.addFrame(new Property("Frame", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        }
    }

    private static void processScript(HtmlMetadata mdata, Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String stype;
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if (!"type".equals(attname) || (stype = attval).length() <= 0) continue;
            mdata.addScript(stype);
        }
    }

    private static void processAbbr(HtmlMetadata mdata, Attributes atts) {
        ArrayList<Property> lst = new ArrayList<Property>(2);
        Property p = new Property("abbr", PropertyType.PROPERTY, PropertyArity.LIST, lst);
        for (int i = 0; i < atts.getLength(); ++i) {
            String attname = atts.getLocalName(i);
            String attval = atts.getValue(i);
            if (!"title".equals(attname) || attval.length() <= 0) continue;
            lst.add(new Property("title", PropertyType.STRING, attval));
        }
        mdata.setPropUnderConstruction(p);
    }

    private static void processTitle(HtmlMetadata mdata, Attributes atts) {
        Property p = new Property("title", PropertyType.STRING, "");
        mdata.setPropUnderConstruction(p);
    }

    private static void processCite(HtmlMetadata mdata, Attributes atts) {
        Property p = new Property("cite", PropertyType.STRING, "");
        mdata.setPropUnderConstruction(p);
    }
}

