/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;

public class Digest {
    public String algorithm;
    public byte[] digestBytes;
    public String digestString;
    public String encoding;
    protected static Map<String, Integer> digestAlgoLengthache = new TreeMap<String, Integer>();

    public static synchronized int digestAlgorithmLength(String digestAlgorithm) {
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            throw new IllegalArgumentException("'digestAlgorithm' is empty or null");
        }
        Integer cachedLen = digestAlgoLengthache.get(digestAlgorithm);
        if (cachedLen == null) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
                byte[] digest = md.digest(new byte[16]);
                cachedLen = digest.length;
                md.reset();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (cachedLen == null) {
                cachedLen = -1;
            }
            digestAlgoLengthache.put(digestAlgorithm, cachedLen);
        }
        return cachedLen;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Digest)) {
            return false;
        }
        Digest digestObj = (Digest)obj;
        if (!Arrays.equals(this.digestBytes, digestObj.digestBytes)) {
            return false;
        }
        if (this.algorithm != null ? !this.algorithm.equals(digestObj.algorithm) : digestObj.algorithm != null) {
            return false;
        }
        if (this.digestString != null ? !this.digestString.equals(digestObj.digestString) : digestObj.digestString != null) {
            return false;
        }
        return !(this.encoding != null ? !this.encoding.equals(digestObj.encoding) : digestObj.encoding != null);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.digestBytes != null) {
            CRC32 checksum = new CRC32();
            checksum.update(this.digestBytes, 0, this.digestBytes.length);
            hashCode = (int)((long)hashCode ^ checksum.getValue());
        }
        if (this.algorithm != null) {
            hashCode ^= this.algorithm.hashCode();
        }
        if (this.digestString != null) {
            hashCode ^= this.digestString.hashCode();
        }
        if (this.encoding != null) {
            hashCode ^= this.encoding.hashCode();
        }
        return hashCode;
    }
}

