/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.tiffTests;

import java.util.List;
import org.opengis.cite.geotiff11.tiffTests.GeoKeysTests;
import org.opengis.cite.geotiff11.util.EPSGDataSet;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoubleParamsTests
extends GeoKeysTests {
    float processFourthShortForDouble(int index) {
        int doubleIndex = (Integer)this.keyEntrySet.get(index + 3);
        List<Object> doubleParamsSet = this.directory.getTag(34736).getValues();
        Assert.assertTrue(doubleParamsSet != null);
        return ((Float)doubleParamsSet.get(doubleIndex)).floatValue();
    }

    @Test(description="Double Params GeogLinearUnitSizeGeoKey (2053) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeogLinearUnitSizeGeoKey() throws Exception {
        int index = this.getKeyIndex(2053);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the GeogLinearUnitSizeGeoKey SHALL have type = DOUBLE");
        Assert.assertTrue(this.keyExists(2052), "the units of the GeogLinearUnitSizeGeoKey value SHALL be meters");
        int unitsValue = this.processFourthShortForShort(this.getKeyIndex(2052), this.processThirdShort(this.getKeyIndex(2052)));
        if (unitsValue != Short.MAX_VALUE) {
            Assert.assertTrue(EPSGDataSet.getItem("unit-of-measure", "UOM_CODE", unitsValue, "TARGET_UOM_CODE").equals("9001"), "the units of the GeogLinearUnitSizeGeoKey value SHALL be meters");
        }
    }

    @Test(description="Double Params GeogAngularUnitSizeGeoKey (2055) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeogAngularUnitSizeGeoKey() throws Exception {
        int index = this.getKeyIndex(2055);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the GeogAngularUnitSizeGeoKey SHALL have type = DOUBLE");
        Assert.assertTrue(this.keyExists(2054));
        int unitsValue = this.processFourthShortForShort(this.getKeyIndex(2054), this.processThirdShort(this.getKeyIndex(2054)));
        if (unitsValue != Short.MAX_VALUE) {
            Assert.assertTrue(EPSGDataSet.getItem("unit-of-measure", "UOM_CODE", unitsValue, "TARGET_UOM_CODE").equals("9101"), "the units of the GeogAngularUnitSizeGeoKey value SHALL be radians");
        }
    }

    @Test(description="Double Params EllipsoidSemiMajorAxisGeoKey (2057) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyEllipsoidSemiMajorAxisGeoKey() throws Exception {
        int index = this.getKeyIndex(2057);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the EllipsoidSemiMajorAxisGeoKey SHALL have type = DOUBLE");
        Assert.assertTrue(this.keyExists(2052), "the units of the EllipsoidSemiMajorAxisGeoKey SHALL be defined by the value of GeogLinearUnitsGeoKey");
    }

    @Test(description="Double Params EllipsoidSemiMinorAxisGeoKey (2058) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyEllipsoidSemiMinorAxisGeoKey() throws Exception {
        int index = this.getKeyIndex(2058);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the EllipsoidSemiMinorAxisGeoKey SHALL have type = DOUBLE");
        Assert.assertTrue(this.keyExists(2052), "the units of the EllipsoidSemiMinorAxisGeoKey SHALL be defined by the value of GeogLinearUnitsGeoKey");
    }

    @Test(description="Double Params EllipsoidInvFlatteningGeoKey (2059) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyEllipsoidInvFlatteningGeoKey() throws Exception {
        int index = this.getKeyIndex(2059);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the EllipsoidInvFlatteningGeoKey SHALL have type = DOUBLE");
    }

    @Test(description="Double Params PrimeMeridianLongitudeGeoKey (2061) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyPrimeMeridianLongitudeGeoKey() throws Exception {
        int index = this.getKeyIndex(2061);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the PrimeMeridianLongitudeGeoKey SHALL have type = DOUBLE");
        Assert.assertTrue(this.keyExists(2054), "the unit for the PrimeMeridianLongitudeGeoKey value SHALL be GeogAngularUnits");
    }

    @Test(description="Double Params ProjLinearUnitSizeGeoKey (3077) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjLinearUnitSizeGeoKey() throws Exception {
        int index = this.getKeyIndex(3077);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the ProjLinearUnitSizeGeoKey SHALL have type = DOUBLE");
        Assert.assertTrue(this.keyExists(3076), "the units of the ProjLinearUnitSizeGeoKey value SHALL be meters");
        int unitsValue = this.processFourthShortForShort(this.getKeyIndex(3076), this.processThirdShort(this.getKeyIndex(3076)));
        if (unitsValue != Short.MAX_VALUE) {
            Assert.assertTrue(EPSGDataSet.getItem("unit-of-measure", "UOM_CODE", unitsValue, "TARGET_UOM_CODE").equals("9001"), "the units of the ProjLinearUnitSizeGeoKey value SHALL be meters");
        }
    }

    @Test(description="ProjScalarParameters Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjScalarParameters() throws Exception {
        int[] projScalarParameters;
        for (int geoKey : projScalarParameters = new int[]{3092, 3093}) {
            int index = this.getKeyIndex(geoKey);
            if (index == -1) continue;
            int type = this.processSecondShort(index);
            Assert.assertTrue(type == 34736, "the ProjScalarParameters SHALL have type = DOUBLE");
        }
    }

    @Test(description="Double Params ProjAzimuthAngleGeoKey (3094) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjAzimuthAngleGeoKey() throws Exception {
        int index = this.getKeyIndex(3094);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        float value = this.processFourthShortForDouble(index);
        Assert.assertTrue(type == 34736, "the ProjAzimuthAngleGeoKey SHALL have type = DOUBLE");
        Assert.assertTrue(this.keyExists(2060), "the ProjAzimuthAngleGeoKey SHALL have units as specified by the GeogAzimuthUnitsGeoKey");
    }

    @Test(description="ProjAngularParameters Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjAngularParameters() throws Exception {
        int[] projAngularParameters;
        for (int geoKey : projAngularParameters = new int[]{3078, 3079, 3080, 3081, 3084, 3085, 3088, 3089, 3095}) {
            int index = this.getKeyIndex(geoKey);
            if (index == -1) continue;
            int type = this.processSecondShort(index);
            Assert.assertTrue(type == 34736, "the ProjAngularParameters SHALL have type = DOUBLE");
            Assert.assertTrue(this.keyExists(2054), "all parameters in this requirements class SHALL have units as specified by the GeogAngularUnitsGeoKey");
        }
    }

    @Test(description="ProjLinearParameters Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjLinearParameters() throws Exception {
        int[] projLinearParameters;
        for (int geoKey : projLinearParameters = new int[]{3082, 3083, 3086, 3087, 3090, 3091}) {
            int index = this.getKeyIndex(geoKey);
            if (index == -1) continue;
            int type = this.processSecondShort(index);
            Assert.assertTrue(type == 34736, "the ProjLinearParameters SHALL have type = DOUBLE");
            Assert.assertTrue(this.keyExists(3076), "all parameters in this requirements class SHALL have units as specified by the ProjLinearUnitsGeoKey");
        }
    }
}

