/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public final class EPSGDataSet {
    public static final String METERS = "9001";
    public static final String RADIANS = "9101";
    private static final String EXTENSION = ".csv";
    public static final String UOM = "unit-of-measure";
    public static final String CRS = "coordinate-reference-system";
    public static final String DATUM = "datum";
    public static final String PRIMEMERIDIAN = "prime-meridian";
    public static final String ELLIPSOID = "ellipsoid";
    public static final String CO = "coordinate-operation";
    public static final String COM = "coordinate-operation-method";
    public static final String COP = "coordinate-operation-parameter";

    private static InputStreamReader getResourceISR(String name) {
        return new InputStreamReader(EPSGDataSet.class.getResourceAsStream("/epsg/" + name + EXTENSION));
    }

    protected static BufferedReader readTable(String tableName) throws IOException {
        return new BufferedReader(EPSGDataSet.getResourceISR(tableName));
    }

    public static CSVRecord getRecord(String tableName, String column, String value) throws IOException {
        BufferedReader reader = EPSGDataSet.readTable(tableName);
        CSVParser csvParser = new CSVParser(reader, CSVFormat.DEFAULT.withFirstRecordAsHeader().withTrim());
        for (CSVRecord csvRecord : csvParser) {
            if (!csvRecord.get(column).equals(value)) continue;
            csvParser.close();
            return csvRecord;
        }
        csvParser.close();
        return null;
    }

    public static String getItem(String tableName, String column, String value, String returnColumn) throws IOException {
        return EPSGDataSet.getRecord(tableName, column, value).get(returnColumn);
    }

    public static String getItem(String tableName, String column, int value, String returnColumn) throws IOException {
        return EPSGDataSet.getItem(tableName, column, Integer.toString(value), returnColumn);
    }
}

