/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AsciiModule
extends ModuleBase {
    private static final String NAME = "ASCII-hul";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2006, 9, 5};
    private static final String[] FORMAT = new String[]{"ASCII", "US-ASCII", "ANSI X3.4", "ISO 646"};
    private static final String COVERAGE = null;
    private static final String[] MIMETYPE = new String[]{"text/plain; charset=US-ASCII"};
    private static final String WELLFORMED = "An ASCII object is well-formed if each byte is between 0x00 and 0x7F";
    private static final String VALIDITY = null;
    private static final String REPINFO = "Additional representation information includes: line ending and control characters";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final int CR = 13;
    private static final int LF = 10;
    private static final String[] controlCharMnemonics = new String[]{"NUL (0x00)", "SOH (0x01)", "STX (0x02)", "ETX (0x03)", "EOT (0x04)", "ENQ (0x05)", "ACK (0x06)", "BEL (0x07)", "BS (0x08)", "TAB (0x09)", "LF (0x0A)", "VT (0x0B)", "FF (0x0C)", "CR (0x0D)", "SO (0x0E)", "SI (0x0F)", "DLE (0x10)", "DC1 (0x11)", "DC2 (0x12)", "DC3 (0x13)", "DC4 (0x14)", "NAK (0x15)", "SYN (0x16)", "ETB (0x17)", "CAN (0x18)", "EM (0x19)", "SUB (0x1A)", "ESC (0x1B)", "FS (0x1C)", "GS (0x1D)", "RS (0x1E)", "US (0x1F)"};
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected boolean _lineEndCR;
    protected boolean _lineEndLF;
    protected boolean _lineEndCRLF;
    protected int _prevChar;
    protected Map<Integer, String> _controlCharMap;
    protected boolean _withTextMD = false;
    protected TextMDMetadata _textMD;

    public AsciiModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("Information technology -- ISO 7-bit coded character set for information interchange", DocumentType.STANDARD);
        doc.setPublisher(Agent.newIsoInstance());
        doc.setDate("1991");
        doc.setIdentifier(new Identifier("ISO/IEC 646:1991", IdentifierType.ISO));
        this._specification.add(doc);
        doc = new Document("Information Systems -- Coded Character Sets 7-Bit American National Standard Code for Information Interchange (7-Bit ASCII)", DocumentType.STANDARD);
        Agent.Builder builder = new Agent.Builder("ANSI", AgentType.STANDARD).address("1819 L Street, NW, Washington, DC 20036").telephone("+1 (202) 293-8020").fax("+1 (202) 293-9287").email("info@ansi.org").web("http://www.ansi.org/");
        doc.setPublisher(builder.build());
        doc.setDate("1986-12-30");
        doc.setIdentifier(new Identifier("ANSI X3.4-1986", IdentifierType.ANSI));
        this._specification.add(doc);
        doc = new Document("7-Bit coded Character Set", DocumentType.STANDARD);
        doc.setEdition("6th");
        doc.setDate("1991-12");
        builder = new Agent.Builder("ECMA", AgentType.STANDARD).address("114 Rue du Rhone, CH-1204 Geneva, Switzerland").telephone("+41 22 849.60.00").fax("+41 22 849.60.01").email("helpdesk@ecma.ch").web("http://www.ecma-international.org/");
        doc.setPublisher(builder.build());
        doc.setIdentifier(new Identifier("ECMA-6", IdentifierType.ECMA));
        doc.setIdentifier(new Identifier("http://www.ecma-international.org/publications/files/ecma-st/Ecma-006.pdf", IdentifierType.URL));
        this._specification.add(doc);
    }

    public final int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        if (this._defaultParams != null) {
            for (String param : this._defaultParams) {
                if (!"withtextmd=true".equalsIgnoreCase(param)) continue;
                this._withTextMD = true;
            }
        }
        this.initParse();
        info.setModule((Module)this);
        this._lineEndCR = false;
        this._lineEndLF = false;
        this._lineEndCRLF = false;
        this._prevChar = 0;
        this._controlCharMap = new HashMap<Integer, String>();
        this._textMD = new TextMDMetadata();
        boolean printableChars = false;
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        Checksummer ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(stream, ckSummer);
            this._dstream = AsciiModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = AsciiModule.getBufferedDataStream((InputStream)stream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        boolean eof = false;
        this._nByte = 0L;
        while (!eof) {
            try {
                int ch = AsciiModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (ch > 127) {
                    ErrorMessage error = new ErrorMessage("Invalid character", "Character = " + (char)ch + " (0x" + Integer.toHexString(ch) + ")", this._nByte - 1L);
                    info.setMessage((Message)error);
                    info.setWellFormed(0);
                    return 0;
                }
                if (ch < 32 && ch != 13 && ch != 10) {
                    this._controlCharMap.put(new Integer(ch), controlCharMnemonics[ch]);
                } else if (ch == 127) {
                    this._controlCharMap.put(new Integer(ch), "DEL (0x7F)");
                }
                this.checkLineEnd(ch);
                if (32 <= ch && ch <= 126) {
                    printableChars = true;
                }
                this._prevChar = ch;
            }
            catch (EOFException e) {
                eof = true;
                this.checkLineEnd(0);
            }
        }
        if (ckSummer != null) {
            info.setSize(this._cstream.getNBytes());
            info.setChecksum(new Checksum(ckSummer.getCRC32(), ChecksumType.CRC32));
            String value = ckSummer.getMD5();
            if (value != null) {
                info.setChecksum(new Checksum(value, ChecksumType.MD5));
            }
            if ((value = ckSummer.getSHA1()) != null) {
                info.setChecksum(new Checksum(value, ChecksumType.SHA1));
            }
        }
        if (this._nByte == 0L) {
            info.setMessage((Message)new ErrorMessage("Zero-length file"));
            info.setWellFormed(0);
            return 0;
        }
        this._textMD.setCharset("US-ASCII");
        this._textMD.setByte_order(this._bigEndian ? 0 : 1);
        this._textMD.setByte_size("8");
        this._textMD.setCharacter_size("1");
        ArrayList<Property> metadataList = new ArrayList<Property>(2);
        if (this._lineEndCR || this._lineEndLF || this._lineEndCRLF) {
            ArrayList<String> propArray = new ArrayList<String>(3);
            if (this._lineEndCR) {
                propArray.add("CR");
                this._textMD.setLinebreak(0);
            }
            if (this._lineEndLF) {
                propArray.add("LF");
                this._textMD.setLinebreak(1);
            }
            if (this._lineEndCRLF) {
                propArray.add("CRLF");
                this._textMD.setLinebreak(2);
            }
            Property property = new Property("LineEndings", PropertyType.STRING, PropertyArity.LIST, propArray);
            metadataList.add(property);
        }
        if (!this._controlCharMap.isEmpty()) {
            String mnem;
            LinkedList<String> propList = new LinkedList<String>();
            for (int i = 0; i < 32; ++i) {
                mnem = this._controlCharMap.get(new Integer(i));
                if (mnem == null) continue;
                propList.add(mnem);
            }
            mnem = this._controlCharMap.get(new Integer(127));
            if (mnem != null) {
                propList.add(mnem);
            }
            Property property = new Property("ControlCharacters", PropertyType.STRING, PropertyArity.LIST, propList);
            metadataList.add(property);
        }
        if (this._withTextMD) {
            Property property = new Property("TextMDMetadata", PropertyType.TEXTMDMETADATA, PropertyArity.SCALAR, (Object)this._textMD);
            metadataList.add(property);
        }
        if (!metadataList.isEmpty()) {
            info.setProperty(new Property("ASCIIMetadata", PropertyType.PROPERTY, PropertyArity.LIST, metadataList));
        }
        if (!printableChars) {
            info.setMessage((Message)new InfoMessage("No printable characters"));
        }
        return 0;
    }

    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule((Module)this);
        JhoveBase jb = this.getBase();
        int sigBytes = jb.getSigBytes();
        int bytesRead = 0;
        boolean eof = false;
        DataInputStream dstream = new DataInputStream(stream);
        while (!eof && bytesRead < sigBytes) {
            try {
                int ch = AsciiModule.readUnsignedByte((DataInputStream)dstream, (ModuleBase)this);
                ++bytesRead;
                if (ch <= 127) continue;
                info.setWellFormed(false);
                return;
            }
            catch (EOFException e) {
                eof = true;
            }
        }
        if (bytesRead == 0) {
            info.setWellFormed(false);
            return;
        }
        info.setSigMatch(this._name);
    }

    protected void checkLineEnd(int ch) {
        if (ch == 10) {
            if (this._prevChar == 13) {
                this._lineEndCRLF = true;
            } else {
                this._lineEndLF = true;
            }
        } else if (this._prevChar == 13) {
            this._lineEndCR = true;
        }
    }
}

