/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class ExifVersionChunk
extends Chunk {
    public ExifVersionChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        if (this.bytesLeft != 4L) {
            info.setMessage((Message)new ErrorMessage("Incorrect length for Exif Version Chunk"));
            info.setWellFormed(false);
            return false;
        }
        byte[] buf = new byte[4];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
        String txt = new String(buf);
        module.getExifInfo().setExifVersion(txt);
        return true;
    }
}

