/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;

public class IendChunk
extends PNGChunk {
    public IendChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        this._module.setIendSeen(true);
        if (this.length > 0L) {
            ErrorMessage msg = new ErrorMessage("IEND chunk is not empty");
            info.setMessage((Message)msg);
            info.setValid(false);
            int i = 0;
            while ((long)i < this.length) {
                this.readUnsignedByte();
                ++i;
            }
        }
    }
}

