/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.iff.Superchunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import edu.harvard.hul.ois.jhove.module.wave.ExifStringChunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifVersionChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabeledTextChunk;
import edu.harvard.hul.ois.jhove.module.wave.ListInfoTextChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;

public class ListInfoChunk
extends Superchunk {
    public ListInfoChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm, RepInfo info) {
        super(module, hdr, dstrm, info);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        boolean isInfo = false;
        boolean isExif = false;
        String typeID = ((WaveModule)this._module).read4Chars(this._dstream);
        this.bytesLeft -= 4L;
        if ("INFO".equals(typeID)) {
            return this.readInfoChunk(info);
        }
        if ("exif".equals(typeID)) {
            return this.readExifChunk(info);
        }
        if ("adtl".equals(typeID)) {
            return this.readAdtlChunk(info);
        }
        info.setMessage((Message)new ErrorMessage("Unknown list type " + typeID + " in List Chunk", this._module.getNByte()));
        info.setWellFormed(false);
        return false;
    }

    private boolean readInfoChunk(RepInfo info) throws IOException {
        ChunkHeader chunkh;
        LinkedList listInfoProps = new LinkedList();
        WaveModule module = (WaveModule)this._module;
        while ((chunkh = this.getNextChunkHeader()) != null) {
            ListInfoTextChunk chunk = null;
            String id = chunkh.getID();
            int chunkSize = (int)chunkh.getSize();
            chunk = new ListInfoTextChunk(this._module, chunkh, this._dstream, listInfoProps, this);
            if (chunk == null) {
                this._module.skipBytes(this._dstream, (long)chunkSize, this._module);
                info.setMessage((Message)new InfoMessage("Chunk type '" + id + "' in List Info Chunk ignored"));
            } else {
                try {
                    if (!((Chunk)chunk).readChunk(info)) {
                        return false;
                    }
                }
                catch (JhoveException e) {
                    info.setMessage((Message)new ErrorMessage(e.getMessage()));
                    info.setWellFormed(false);
                    return false;
                }
            }
            if ((chunkSize & 1) == 0) continue;
            this._module.skipBytes(this._dstream, 1L, this._module);
            --this.bytesLeft;
        }
        if (!listInfoProps.isEmpty()) {
            module.addListInfo(listInfoProps);
        }
        return true;
    }

    private boolean readExifChunk(RepInfo info) throws IOException {
        ChunkHeader chunkh;
        LinkedList exifProps = new LinkedList();
        WaveModule module = (WaveModule)this._module;
        module.setExifInfo(new ExifInfo());
        while ((chunkh = this.getNextChunkHeader()) != null) {
            Chunk chunk = null;
            String id = chunkh.getID();
            int chunkSize = (int)chunkh.getSize();
            if ("ever".equals(id)) {
                chunk = new ExifVersionChunk(this._module, chunkh, this._dstream);
            } else if ("erel".equals(id) || "etim".equals(id) || "ecor".equals(id) || "emdl".equals(id)) {
                chunk = new ExifStringChunk(this._module, chunkh, this._dstream);
            } else if ("emnt".equals(id) || "eucm".equals(id)) {
                // empty if block
            }
            if (chunk == null) {
                this._module.skipBytes(this._dstream, (long)chunkSize, this._module);
                info.setMessage((Message)new InfoMessage("Chunk type '" + id + "' in Associated Data Chunk ignored"));
                continue;
            }
            try {
                if (chunk.readChunk(info)) continue;
                return false;
            }
            catch (JhoveException e) {
                info.setMessage((Message)new ErrorMessage(e.getMessage()));
                info.setWellFormed(false);
                return false;
            }
        }
        return false;
    }

    public boolean readAdtlChunk(RepInfo info) throws IOException {
        ChunkHeader chunkh;
        WaveModule module = (WaveModule)this._module;
        while ((chunkh = this.getNextChunkHeader()) != null) {
            Chunk chunk = null;
            String id = chunkh.getID();
            int chunkSize = (int)chunkh.getSize();
            if (id.equals("labl")) {
                chunk = new LabelChunk(this._module, chunkh, this._dstream);
            } else if (id.equals("note")) {
                chunk = new NoteChunk(this._module, chunkh, this._dstream);
            } else if (id.equals("ltxt")) {
                chunk = new LabeledTextChunk(this._module, chunkh, this._dstream);
            }
            if (chunk == null) {
                this._module.skipBytes(this._dstream, (long)chunkSize, this._module);
                info.setMessage((Message)new InfoMessage("Chunk type '" + id + "' in Associated Data Chunk ignored"));
            } else {
                try {
                    if (!((Chunk)chunk).readChunk(info)) {
                        return false;
                    }
                }
                catch (JhoveException e) {
                    info.setMessage((Message)new ErrorMessage(e.getMessage()));
                    info.setWellFormed(false);
                    return false;
                }
            }
            if ((chunkSize & 1) == 0) continue;
            this._module.skipBytes(this._dstream, 1L, this._module);
            --this.bytesLeft;
        }
        return true;
    }
}

