/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.handler.XmlHandler;
import edu.harvard.hul.ois.jhove.handler.audit.AuditCount;
import edu.harvard.hul.ois.jhove.handler.audit.AuditState;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

public class AuditHandler
extends XmlHandler {
    private static final String NAME = "Audit";
    private static final String RELEASE = "1.1";
    private static final int[] DATE = new int[]{2005, 4, 22};
    private static final String NOTE = "This output handler is derived from the standard JHOVE XML output handler.  It is intended to be used as the parent class for other, more interesting handlers.";
    private static final String RIGHTS = "Copyright 2004-2005 by the President and Fellows of Harvard College. Released under the GNU LGPL license";
    protected String _home;
    protected Map _mimeType;
    protected Map _stateMap;
    protected Stack _stateStack;
    protected long _t0;
    protected int _nAudit;

    public AuditHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._name = NAME;
        this._release = RELEASE;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(DATE[0], DATE[1] - 1, DATE[2]);
        this._date = calendar.getTime();
        this._note = NOTE;
        this._rights = RIGHTS;
        this._mimeType = new TreeMap();
        this._stateMap = new TreeMap();
        this._stateStack = new Stack();
        this._nAudit = 0;
    }

    @Override
    public final void endDirectory() {
        AuditState state = (AuditState)this._stateStack.pop();
        this._stateMap.put(state.getDirectory(), state);
        this.endDirectoryImpl(state);
    }

    public void endDirectoryImpl(AuditState state) {
    }

    @Override
    public final boolean okToProcess(String filepath) {
        AuditState state = (AuditState)this._stateStack.peek();
        boolean ok = this.okToProcessImpl(filepath, state);
        if (!ok) {
            state.setNotProcessed(state.getNotProcessed() + 1);
        }
        return ok;
    }

    public boolean okToProcessImpl(String filepath, AuditState state) {
        return true;
    }

    @Override
    public void show(RepInfo info) {
        AuditState state = (AuditState)this._stateStack.peek();
        if (info.getModule() == null) {
            state.setNotFound(state.getNotFound() + 1);
            this._writer.println("<!-- file not found or not readable: " + info.getUri() + " -->");
        } else {
            int valid;
            String mime = info.getMimeType();
            AuditCount count = (AuditCount)this._mimeType.get(mime);
            if (count == null) {
                count = new AuditCount();
            }
            if ((valid = info.getValid()) == 1) {
                state.setValid(state.getValid() + 1);
                count.setValid(count.getValid() + 1);
            } else {
                state.setWellFormed(state.getWellFormed() + 1);
                count.setWellFormed(count.getWellFormed() + 1);
            }
            this._mimeType.put(mime, count);
        }
        this.showImpl(info, state);
    }

    public void showImpl(RepInfo info, AuditState state) {
        String status = null;
        String mime = info.getMimeType();
        status = mime != null ? (info.getWellFormed() == 1 ? (info.getValid() == 1 ? "valid" : "well-formed") : "not well-formed") : "not found";
        String md5 = null;
        List<Checksum> list = info.getChecksum();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            Checksum checksum = list.get(i);
            if (!checksum.getType().equals(ChecksumType.MD5)) continue;
            md5 = checksum.getValue();
            break;
        }
        if (this._nAudit == 0) {
            String margin = AuditHandler.getIndent(++this._level);
            String[][] attrs = new String[][]{{"home", this._home}};
            this._writer.println(margin + AuditHandler.elementStart("audit", attrs));
        }
        String margn2 = AuditHandler.getIndent(this._level) + " ";
        String uri = info.getUri();
        int n = uri.indexOf(this._home);
        if (n == 0) {
            uri = uri.substring(this._home.length() + 1);
        }
        String[][] attrs = new String[][]{{"mime", mime}, {"status", status}, {"md5", md5}};
        this._writer.println(margn2 + AuditHandler.element("file", attrs, uri));
        ++this._nAudit;
    }

    @Override
    public void showFooter() {
        AuditState state = (AuditState)this._stateStack.pop();
        if (state.getTotal() > 0 || state.getNotFound() > 0) {
            this._stateMap.put(state.getDirectory(), state);
        }
        this.showFooterImpl(state);
        this._writer.println("<!-- Summary by MIME type:");
        int nTotal = 0;
        int nValid = 0;
        int nWellFormed = 0;
        Set keys = this._mimeType.keySet();
        for (String mime : keys) {
            AuditCount count = (AuditCount)this._mimeType.get(mime);
            int total = count.getTotal();
            int valid = count.getValid();
            int wellFormed = count.getWellFormed();
            this._writer.println(mime + ": " + total + " (" + valid + "," + wellFormed + ")");
            nTotal += total;
            nValid += valid;
            nWellFormed += wellFormed;
        }
        this._writer.println("Total: " + nTotal + " (" + nValid + "," + nWellFormed + ")");
        this._writer.println("-->");
        this._writer.println("<!-- Summary by directory:");
        nTotal = 0;
        nValid = 0;
        nWellFormed = 0;
        int nNotFound = 0;
        int nNotProcessed = 0;
        keys = this._stateMap.keySet();
        for (String directory : keys) {
            state = (AuditState)this._stateMap.get(directory);
            int total = state.getTotal();
            int valid = state.getValid();
            int wellFormed = state.getWellFormed();
            int notFound = state.getNotFound();
            int notProcessed = state.getNotProcessed();
            this._writer.println(directory + ": " + total + " (" + valid + "," + wellFormed + ") + " + notProcessed + "," + notFound);
            nTotal += total;
            nValid += valid;
            nWellFormed += wellFormed;
            nNotFound += notFound;
            nNotProcessed += notProcessed;
        }
        this._writer.println("Total: " + nTotal + " (" + nValid + "," + nWellFormed + ") + " + nNotProcessed + "," + nNotFound);
        this._writer.println("-->");
        long dt = (System.currentTimeMillis() - this._t0 + 999L) / 1000L;
        long ss = dt % 60L;
        long dm = dt / 60L;
        long mm4 = dm % 60L;
        long hh = dm / 60L;
        this._writer.println("<!-- Elapsed time: " + hh + ":" + (mm4 > 9L ? "" : "0") + mm4 + ":" + (ss > 9L ? "" : "0") + ss + " -->");
        this._writer.flush();
    }

    public void showFooterImpl(AuditState state) {
        if (this._nAudit > 0) {
            String margin = AuditHandler.getIndent(this._level--);
            this._writer.println(margin + AuditHandler.elementEnd("audit"));
        }
        super.showFooter();
    }

    @Override
    public void showHeader() {
        this._mimeType = new TreeMap();
        this._stateMap = new TreeMap();
        this._stateStack = new Stack();
        this._nAudit = 0;
        this._t0 = System.currentTimeMillis();
        AuditState state = this.showHeaderImpl(".");
        this._stateStack.push(state);
        this._home = state.getDirectory();
    }

    public AuditState showHeaderImpl(String directory) {
        super.showHeader();
        return new AuditState(directory);
    }

    @Override
    public void startDirectory(String directory) {
        try {
            AuditState state = (AuditState)((AuditState)this._stateStack.peek()).clone(directory);
            this.startDirectoryImpl(state);
            this._stateStack.push(state);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public void startDirectoryImpl(AuditState state) {
    }
}

