/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TextHandler
extends HandlerBase {
    private static final String NAME = "TEXT";
    private static final String RELEASE = "1.5";
    private static final int[] DATE = new int[]{2009, 10, 14};
    private static final String NOTE = "This is the default JHOVE output handler";
    private static final String RIGHTS = "Copyright 2003-2009 by JSTOR and the President and Fellows of Harvard College. Released under the terms of the GNU Lesser General Public License.";
    private NumberFormat _format;
    private double _sampleRate;

    public TextHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._vendor = Agent.harvardInstance();
        this._format = NumberFormat.getInstance();
        this._format.setGroupingUsed(false);
        this._format.setMinimumFractionDigits(0);
    }

    @Override
    public void show() {
        String margin = TextHandler.getIndent(++this._level);
        --this._level;
    }

    @Override
    public void show(App app) {
        String s2;
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + "App:");
        this._writer.println(margin + " API: " + app.getRelease() + ", " + HandlerBase.date.format(this._je.getDate()));
        String configFile = this._je.getConfigFile();
        if (configFile != null) {
            this._writer.println(margin + " Configuration: " + configFile);
        }
        if ((s2 = this._je.getSaxClass()) != null) {
            this._writer.println(margin + " SAXparser: " + s2);
        }
        if ((s2 = this._je.getJhoveHome()) != null) {
            this._writer.println(margin + " JhoveHome: " + s2);
        }
        if ((s2 = this._je.getEncoding()) != null) {
            this._writer.println(margin + " Encoding: " + s2);
        }
        if ((s2 = this._je.getTempDirectory()) != null) {
            this._writer.println(margin + " TempDirectory: " + s2);
        }
        this._writer.println(margin + " BufferSize: " + this._je.getBufferSize());
        Iterator<String> iter = this._je.getModuleMap().keySet().iterator();
        while (iter.hasNext()) {
            Module module = this._je.getModule(iter.next());
            this._writer.println(margin + " Module: " + module.getName() + " " + module.getRelease());
        }
        iter = this._je.getHandlerMap().keySet().iterator();
        while (iter.hasNext()) {
            OutputHandler handler = this._je.getHandler(iter.next());
            this._writer.println(margin + " OutputHandler: " + handler.getName() + " " + handler.getRelease());
        }
        this._writer.println(margin + " Usage: " + app.getUsage());
        this._writer.println(margin + " Rights: " + app.getRights());
        --this._level;
    }

    @Override
    public void show(OutputHandler handler) {
        String s2;
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + "Handler: " + handler.getName());
        this._writer.println(margin + " Release: " + handler.getRelease());
        this._writer.println(margin + " Date: " + HandlerBase.date.format(handler.getDate()));
        List<Document> list = handler.getSpecification();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.showDocument(list.get(i), "Specification");
        }
        Agent vendor = handler.getVendor();
        if (vendor != null) {
            this.showAgent(vendor, "Vendor");
        }
        if ((s2 = handler.getNote()) != null) {
            this._writer.println(margin + " Note: " + s2);
        }
        if ((s2 = handler.getRights()) != null) {
            this._writer.println(margin + " Rights: " + s2);
        }
    }

    @Override
    public void show(Module module) {
        Agent vendor;
        int i;
        String s22;
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + "Module: " + module.getName());
        this._writer.println(margin + " Release: " + module.getRelease());
        this._writer.println(margin + " Date: " + HandlerBase.date.format(module.getDate()));
        String[] ss = module.getFormat();
        if (ss.length > 0) {
            this._writer.print(margin + " Format: " + ss[0]);
            for (int i2 = 1; i2 < ss.length; ++i2) {
                this._writer.print(", " + ss[i2]);
            }
            this._writer.println();
        }
        if ((s22 = module.getCoverage()) != null) {
            this._writer.println(margin + " Coverage: " + s22);
        }
        if ((ss = module.getMimeType()).length > 0) {
            this._writer.print(margin + " MIMEtype: " + ss[0]);
            for (int i3 = 1; i3 < ss.length; ++i3) {
                this._writer.print(", " + ss[i3]);
            }
            this._writer.println();
        }
        List<Object> list = module.getSignature();
        int n = list.size();
        for (i = 0; i < n; ++i) {
            this.showSignature(list.get(i));
        }
        list = module.getSpecification();
        n = list.size();
        for (i = 0; i < n; ++i) {
            this.showDocument((Document)list.get(i), "Specification");
        }
        List<String> ftr = module.getFeatures();
        if (ftr != null) {
            for (String s22 : ftr) {
                this._writer.println(margin + "  Feature: " + s22);
            }
        }
        this._writer.println(margin + " Methodology:");
        s22 = module.getWellFormedNote();
        if (s22 != null) {
            this._writer.println(margin + "  Well-formed: " + s22);
        }
        if ((s22 = module.getValidityNote()) != null) {
            this._writer.println(margin + "  Validity: " + s22);
        }
        if ((s22 = module.getRepInfoNote()) != null) {
            this._writer.println(margin + "  RepresentationInformation: " + s22);
        }
        if ((vendor = module.getVendor()) != null) {
            this.showAgent(vendor, "Vendor");
        }
        if ((s22 = module.getNote()) != null) {
            this._writer.println(margin + " Note: " + s22);
        }
        if ((s22 = module.getRights()) != null) {
            this._writer.println(margin + " Rights: " + s22);
        }
        --this._level;
    }

    @Override
    public void show(RepInfo info) {
        Map<String, Property> map;
        int i;
        String s2;
        long size;
        Date date;
        String margin = TextHandler.getIndent(++this._level);
        Module module = info.getModule();
        this._writer.println(margin + "RepresentationInformation: " + info.getUri());
        if (module != null) {
            this._writer.println(margin + " ReportingModule: " + module.getName() + ", Rel. " + module.getRelease() + " (" + TextHandler.date.format(module.getDate()) + ")");
        }
        if ((date = info.getCreated()) != null) {
            this._writer.println(margin + " Created: " + dateTime.format(date));
        }
        if ((date = info.getLastModified()) != null) {
            this._writer.println(margin + " LastModified: " + dateTime.format(date));
        }
        if ((size = info.getSize()) > -1L) {
            this._writer.println(margin + " Size: " + size);
        }
        if ((s2 = info.getFormat()) != null) {
            this._writer.println(margin + " Format: " + s2);
        }
        if ((s2 = info.getVersion()) != null) {
            this._writer.println(margin + " Version: " + s2);
        }
        if (!this._je.getSignatureFlag()) {
            this._writer.print(margin + " Status: ");
            switch (info.getWellFormed()) {
                case 1: {
                    s2 = "Well-Formed";
                    break;
                }
                case 0: {
                    s2 = "Not well-formed";
                    break;
                }
                default: {
                    s2 = "Unknown";
                }
            }
            if (info.getWellFormed() == 1) {
                switch (info.getValid()) {
                    case 1: {
                        s2 = s2 + " and valid";
                        break;
                    }
                    case 0: {
                        s2 = s2 + ", but not valid";
                    }
                }
            }
            this._writer.println(s2);
        } else {
            this._writer.print(margin + " Status: ");
            switch (info.getWellFormed()) {
                case 1: {
                    s2 = "Well-Formed";
                    break;
                }
                default: {
                    s2 = "Not well-formed";
                }
            }
            this._writer.println(s2);
        }
        List<Object> list = info.getSigMatch();
        int n = list.size();
        if (n > 0) {
            this._writer.println(margin + " SignatureMatches:");
            for (i = 0; i < n; ++i) {
                this._writer.println(margin + "  " + (String)list.get(i));
            }
        }
        list = info.getMessage();
        n = list.size();
        for (i = 0; i < n; ++i) {
            this.showMessage((Message)list.get(i));
        }
        s2 = info.getMimeType();
        if (s2 != null) {
            this._writer.println(margin + " MIMEtype: " + s2);
        }
        if ((n = (list = info.getProfile()).size()) > 0) {
            this._writer.print(margin + " Profile: " + (String)list.get(0));
            for (i = 1; i < n; ++i) {
                this._writer.print(", " + (String)list.get(i));
            }
            this._writer.println();
        }
        if ((map = info.getProperty()) != null) {
            for (String key : map.keySet()) {
                this.showProperty(info.getProperty(key), key, margin);
            }
        }
        list = info.getChecksum();
        n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.showChecksum((Checksum)list.get(i2));
        }
        --this._level;
    }

    private void showAgent(Agent agent, String label) {
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + label + ": " + agent.getName());
        this._writer.println(margin + " Type: " + agent.getType().toString());
        String s2 = agent.getAddress();
        if (s2 != null) {
            this._writer.println(margin + " Address: " + s2);
        }
        if ((s2 = agent.getTelephone()) != null) {
            this._writer.println(margin + " Telephone: " + s2);
        }
        if ((s2 = agent.getFax()) != null) {
            this._writer.println(margin + " Fax: " + s2);
        }
        if ((s2 = agent.getEmail()) != null) {
            this._writer.println(margin + " Email: " + s2);
        }
        if ((s2 = agent.getWeb()) != null) {
            this._writer.println(margin + " Web: " + s2);
        }
        --this._level;
    }

    private void showChecksum(Checksum checksum) {
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + "Checksum: " + checksum.getValue());
        this._writer.println(margin + " Type: " + checksum.getType().toString());
        --this._level;
    }

    private void showDocument(Document document, String label) {
        int i;
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + label + ": " + document.getTitle());
        this._writer.println(margin + " Type: " + document.getType());
        List list = document.getAuthor();
        int n = list.size();
        for (i = 0; i < n; ++i) {
            this.showAgent((Agent)list.get(i), "Author");
        }
        list = document.getPublisher();
        n = list.size();
        for (i = 0; i < n; ++i) {
            this.showAgent((Agent)list.get(i), "Publisher");
        }
        String s2 = document.getEdition();
        if (s2 != null) {
            this._writer.println(margin + " Edition: " + s2);
        }
        if ((s2 = document.getDate()) != null) {
            this._writer.println(margin + " Date: " + s2);
        }
        if ((s2 = document.getEnumeration()) != null) {
            this._writer.println(margin + " Enumeration: " + s2);
        }
        if ((s2 = document.getPages()) != null) {
            this._writer.println(margin + " Pages: " + s2);
        }
        list = document.getIdentifier();
        n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.showIdentifier((Identifier)list.get(i2));
        }
        s2 = document.getNote();
        if (s2 != null) {
            this._writer.println(margin + " Note: " + s2);
        }
        --this._level;
    }

    @Override
    public void showFooter() {
        --this._level;
        this._writer.flush();
    }

    @Override
    public void showHeader() {
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + this._app.getName() + " (Rel. " + this._app.getRelease() + ", " + HandlerBase.date.format(this._app.getDate()) + ")");
        this._writer.println(margin + " Date: " + HandlerBase.dateTime.format(new Date()));
    }

    private void showIdentifier(Identifier identifier) {
        String margin = TextHandler.getIndent(++this._level);
        this._writer.println(margin + "Identifier: " + identifier.getValue());
        this._writer.println(margin + " Type: " + identifier.getType().toString());
        String note = identifier.getNote();
        if (note != null) {
            this._writer.println(margin + " Note: " + note);
        }
        --this._level;
    }

    private void showMessage(Message message) {
        String margin = TextHandler.getIndent(++this._level);
        String prefix = message instanceof ErrorMessage ? "ErrorMessage: " : (message instanceof InfoMessage ? "InfoMessage: " : "Message: ");
        String str = message.getMessage();
        String submsg = message.getSubMessage();
        if (submsg != null) {
            str = str + ": " + submsg;
        }
        this._writer.println(margin + prefix + str);
        long offset = message.getOffset();
        if (offset > -1L) {
            this._writer.println(margin + " Offset: " + offset);
        }
        --this._level;
    }

    private void showSignature(Signature signature) {
        String use;
        String note;
        String margin = TextHandler.getIndent(++this._level);
        String sigValue = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        this._writer.println(margin + signature.getType().toString() + ": " + sigValue);
        if (signature.getType().equals(SignatureType.MAGIC) && ((InternalSignature)signature).hasFixedOffset()) {
            this._writer.println(margin + " Offset: " + ((InternalSignature)signature).getOffset());
        }
        if ((note = signature.getNote()) != null) {
            this._writer.println(margin + " Note: " + note);
        }
        if ((use = signature.getUse().toString()) != null) {
            this._writer.println(margin + " Use: " + use);
        }
        --this._level;
    }

    private void showProperty(Property property, String key, String margin) {
        PropertyArity arity = property.getArity();
        if (key == null) {
            this._writer.print(margin + "  ");
        } else {
            this._writer.print(margin + " " + key + ": ");
        }
        if (arity.equals(PropertyArity.SCALAR)) {
            this.showScalarProperty(property, margin);
        } else if (arity.equals(PropertyArity.LIST)) {
            this.showListProperty(property, margin);
        } else if (arity.equals(PropertyArity.MAP)) {
            this.showMapProperty(property, margin);
        } else if (arity.equals(PropertyArity.SET)) {
            this.showSetProperty(property, margin);
        } else if (arity.equals(PropertyArity.ARRAY)) {
            this.showArrayProperty(property, margin);
        } else {
            this._writer.println();
        }
    }

    private void showScalarProperty(Property property, String margin) {
        PropertyType type = property.getType();
        if (PropertyType.PROPERTY.equals(type)) {
            this._writer.println();
            Property prop = (Property)property.getValue();
            this.showProperty(prop, prop.getName(), margin + " ");
        } else if (PropertyType.NISOIMAGEMETADATA.equals(type)) {
            this.showNisoImageMetadata((NisoImageMetadata)property.getValue(), margin + " ", this._je.getShowRawFlag());
        } else if (PropertyType.AESAUDIOMETADATA.equals(type)) {
            this.showAESAudioMetadata((AESAudioMetadata)property.getValue(), margin + " ", this._je.getShowRawFlag());
        } else if (PropertyType.TEXTMDMETADATA.equals(type)) {
            this.showTextMDMetadata((TextMDMetadata)property.getValue(), margin + " ", this._je.getShowRawFlag());
        } else {
            this._writer.println(property.getValue().toString());
        }
    }

    private void showListProperty(Property property, String margin) {
        PropertyType type = property.getType();
        boolean valueIsProperty = PropertyType.PROPERTY.equals(type);
        boolean valueIsNiso = PropertyType.NISOIMAGEMETADATA.equals(type);
        boolean valueIsTextMD = PropertyType.TEXTMDMETADATA.equals(type);
        List list = (List)property.getValue();
        int n = list.size();
        if (n > 0) {
            if (valueIsProperty) {
                this._writer.println();
            }
            for (int i = 0; i < n; ++i) {
                if (valueIsProperty) {
                    Property pval = (Property)list.get(i);
                    this.showProperty(pval, pval.getName(), margin + " ");
                    continue;
                }
                if (valueIsNiso) {
                    this.showNisoImageMetadata((NisoImageMetadata)list.get(i), margin + " ", this._je.getShowRawFlag());
                    continue;
                }
                if (valueIsTextMD) {
                    this.showTextMDMetadata((TextMDMetadata)list.get(i), margin + " ", this._je.getShowRawFlag());
                    continue;
                }
                Object val = list.get(i);
                if (i == 0) {
                    this._writer.print(val);
                    continue;
                }
                this._writer.print(", " + val);
            }
        }
        if (!valueIsProperty || n == 0) {
            this._writer.println();
        }
    }

    private void showMapProperty(Property property, String margin) {
        PropertyType type = property.getType();
        boolean valueIsProperty = PropertyType.PROPERTY.equals(type);
        boolean valueIsNiso = PropertyType.NISOIMAGEMETADATA.equals(type);
        boolean valueIsTextMD = PropertyType.TEXTMDMETADATA.equals(type);
        Map propmap = (Map)property.getValue();
        Set keys = propmap.keySet();
        for (Object propkey : keys) {
            Object val = propmap.get(propkey);
            if (valueIsProperty) {
                Property pval = (Property)val;
                this.showProperty(pval, pval.getName(), margin + " ");
                String propkeyStr = propkey.toString();
                if (pval.getName().equals(propkeyStr)) continue;
                this._writer.println("    Key: " + propkeyStr);
                continue;
            }
            if (valueIsNiso) {
                this.showNisoImageMetadata((NisoImageMetadata)val, margin + " ", this._je.getShowRawFlag());
                continue;
            }
            if (valueIsTextMD) {
                this.showTextMDMetadata((TextMDMetadata)val, margin + " ", this._je.getShowRawFlag());
                continue;
            }
            this._writer.println("   " + val.toString());
            this._writer.println("     Key: " + propkey.toString());
        }
    }

    private void showSetProperty(Property property, String margin) {
        PropertyType type = property.getType();
        boolean valueIsProperty = PropertyType.PROPERTY.equals(type);
        boolean valueIsNiso = PropertyType.NISOIMAGEMETADATA.equals(type);
        boolean valueIsTextMD = PropertyType.TEXTMDMETADATA.equals(type);
        Set propset = (Set)property.getValue();
        Iterator propiter = propset.iterator();
        boolean first = true;
        while (propiter.hasNext()) {
            Object val = propiter.next();
            if (valueIsProperty) {
                Property pval = (Property)val;
                this.showProperty(pval, pval.getName(), margin + " ");
                continue;
            }
            if (valueIsNiso) {
                this.showNisoImageMetadata((NisoImageMetadata)val, margin + " ", this._je.getShowRawFlag());
                continue;
            }
            if (valueIsTextMD) {
                this.showTextMDMetadata((TextMDMetadata)val, margin + " ", this._je.getShowRawFlag());
                continue;
            }
            if (first) {
                this._writer.print(val.toString());
                first = false;
                continue;
            }
            this._writer.print(", " + val.toString());
        }
        this._writer.println();
    }

    private void showArrayProperty(Property property, String margin) {
        boolean[] boolArray = null;
        byte[] byteArray = null;
        char[] charArray = null;
        Date[] dateArray = null;
        double[] doubleArray = null;
        float[] floatArray = null;
        int[] intArray = null;
        long[] longArray = null;
        Object[] objArray = null;
        Property[] propArray = null;
        short[] shortArray = null;
        String[] stringArray = null;
        Rational[] rationalArray = null;
        NisoImageMetadata[] nisoArray = null;
        TextMDMetadata[] textMDArray = null;
        int n = 0;
        PropertyType propType = property.getType();
        if (PropertyType.BOOLEAN.equals(propType)) {
            boolArray = (boolean[])property.getValue();
            n = boolArray.length;
        } else if (PropertyType.BYTE.equals(propType)) {
            byteArray = (byte[])property.getValue();
            n = byteArray.length;
        } else if (PropertyType.CHARACTER.equals(propType)) {
            charArray = (char[])property.getValue();
            n = charArray.length;
        } else if (PropertyType.DATE.equals(propType)) {
            dateArray = (Date[])property.getValue();
            n = dateArray.length;
        } else if (PropertyType.DOUBLE.equals(propType)) {
            doubleArray = (double[])property.getValue();
            n = doubleArray.length;
        } else if (PropertyType.FLOAT.equals(propType)) {
            floatArray = (float[])property.getValue();
            n = floatArray.length;
        } else if (PropertyType.INTEGER.equals(propType)) {
            intArray = (int[])property.getValue();
            n = intArray.length;
        } else if (PropertyType.LONG.equals(propType)) {
            longArray = (long[])property.getValue();
            n = longArray.length;
        } else if (PropertyType.OBJECT.equals(propType)) {
            objArray = (Object[])property.getValue();
            n = objArray.length;
        } else if (PropertyType.SHORT.equals(propType)) {
            shortArray = (short[])property.getValue();
            n = shortArray.length;
        } else if (PropertyType.STRING.equals(propType)) {
            stringArray = (String[])property.getValue();
            n = stringArray.length;
        } else if (PropertyType.RATIONAL.equals(propType)) {
            rationalArray = (Rational[])property.getValue();
            n = rationalArray.length;
        } else if (PropertyType.PROPERTY.equals(propType)) {
            propArray = (Property[])property.getValue();
            n = propArray.length;
        } else if (PropertyType.NISOIMAGEMETADATA.equals(propType)) {
            nisoArray = (NisoImageMetadata[])property.getValue();
            n = nisoArray.length;
        } else if (PropertyType.TEXTMDMETADATA.equals(propType)) {
            textMDArray = (TextMDMetadata[])property.getValue();
            n = textMDArray.length;
        }
        for (int i = 0; i < n; ++i) {
            String elem;
            if (PropertyType.BOOLEAN.equals(propType)) {
                elem = String.valueOf(boolArray[i]);
            } else if (PropertyType.BYTE.equals(propType)) {
                elem = String.valueOf(byteArray[i]);
            } else if (PropertyType.CHARACTER.equals(propType)) {
                elem = String.valueOf(charArray[i]);
            } else if (PropertyType.DATE.equals(propType)) {
                elem = dateArray[i].toString();
            } else if (PropertyType.DOUBLE.equals(propType)) {
                elem = String.valueOf(doubleArray[i]);
            } else if (PropertyType.FLOAT.equals(propType)) {
                elem = String.valueOf(floatArray[i]);
            } else if (PropertyType.INTEGER.equals(propType)) {
                elem = String.valueOf(intArray[i]);
            } else if (PropertyType.LONG.equals(propType)) {
                elem = String.valueOf(longArray[i]);
            } else if (PropertyType.OBJECT.equals(propType)) {
                elem = objArray[i].toString();
            } else if (PropertyType.SHORT.equals(propType)) {
                elem = String.valueOf(shortArray[i]);
            } else if (PropertyType.STRING.equals(propType)) {
                elem = stringArray[i];
            } else if (PropertyType.RATIONAL.equals(propType)) {
                elem = rationalArray[i].toString();
            } else {
                if (PropertyType.NISOIMAGEMETADATA.equals(propType)) {
                    if (i == 0) {
                        this._writer.println();
                    }
                    NisoImageMetadata niso = nisoArray[i];
                    this.showNisoImageMetadata(niso, margin + " ", this._je.getShowRawFlag());
                    continue;
                }
                if (PropertyType.TEXTMDMETADATA.equals(propType)) {
                    if (i == 0) {
                        this._writer.println();
                    }
                    this.showTextMDMetadata(textMDArray[i], margin + " ", this._je.getShowRawFlag());
                    continue;
                }
                if (PropertyType.PROPERTY.equals(propType)) {
                    if (i == 0) {
                        this._writer.println();
                    }
                    Property pval = propArray[i];
                    this.showProperty(pval, pval.getName(), margin + " ");
                    continue;
                }
                elem = "<error>";
            }
            if (i == 0) {
                this._writer.print(elem);
                continue;
            }
            this._writer.print(", " + elem);
        }
        if (propType != PropertyType.PROPERTY && propType != PropertyType.NISOIMAGEMETADATA) {
            this._writer.println();
        }
    }

    private void showTextMDMetadata(TextMDMetadata textMD, String margin, boolean rawOutput) {
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        this._writer.println();
        this._writer.println(margn2 + "Character_info:");
        String s2 = textMD.getCharset();
        if (s2 != null) {
            this._writer.println(margn3 + "Charset: " + s2);
        }
        if ((s2 = textMD.getByte_orderString()) != null) {
            this._writer.println(margn3 + "Byte_order: " + s2);
        }
        if ((s2 = textMD.getByte_size()) != null) {
            this._writer.println(margn3 + "Byte_size: " + s2);
        }
        if ((s2 = textMD.getCharacter_size()) != null) {
            this._writer.println(margn3 + "Character_size: " + s2);
        }
        if ((s2 = textMD.getLinebreakString()) != null) {
            this._writer.println(margn3 + "Linebreak: " + s2);
        }
        if ((s2 = textMD.getLanguage()) != null) {
            this._writer.println(margn2 + "Language: " + s2);
        }
        if ((s2 = textMD.getMarkup_basis()) != null) {
            this._writer.println(margn2 + "Markup_basis: " + s2);
        }
        if ((s2 = textMD.getMarkup_basis_version()) != null) {
            this._writer.println(margn2 + "Markup_basis_version: " + s2);
        }
        if ((s2 = textMD.getMarkup_language()) != null) {
            this._writer.println(margn2 + "Markup_language: " + s2);
        }
        if ((s2 = textMD.getMarkup_language_version()) != null) {
            this._writer.println(margn2 + "Markup_language_version: " + s2);
        }
    }

    private void showAESAudioMetadata(AESAudioMetadata aes, String margin, boolean rawOutput) {
        List flist;
        List facelist;
        String[] use;
        long lin;
        int in;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        this._sampleRate = aes.getSampleRate();
        this._writer.println();
        String s2 = aes.getAnalogDigitalFlag();
        if (s2 != null) {
            this._writer.println(margn2 + "AnalogDigitalFlag: " + s2);
        }
        if ((s2 = aes.getSchemaVersion()) != null) {
            this._writer.println(margn2 + "SchemaVersion: " + s2);
        }
        if ((s2 = aes.getFormat()) != null) {
            this._writer.println(margn2 + "Format: " + s2);
        }
        if ((s2 = aes.getSpecificationVersion()) != null) {
            this._writer.println(margn2 + "SpecificationVersion: " + s2);
        }
        if ((s2 = aes.getAppSpecificData()) != null) {
            this._writer.println(margn2 + "AppSpecificData: " + s2);
        }
        if ((s2 = aes.getAudioDataEncoding()) != null) {
            this._writer.println(margn2 + "AudioDataEncoding: " + s2);
        }
        if ((in = aes.getByteOrder()) != -1) {
            this._writer.println(margn2 + "ByteOrder: " + (in == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN"));
        }
        if ((lin = aes.getFirstSampleOffset()) != -1L) {
            this._writer.println(margn2 + "FirstSampleOffset: " + Long.toString(lin));
        }
        if ((use = aes.getUse()) != null) {
            this._writer.println(margn2 + "Use:");
            this._writer.println(margn3 + "UseType: " + use[0]);
            this._writer.println(margn3 + "OtherType: " + use[1]);
        }
        if ((s2 = aes.getPrimaryIdentifier()) != null) {
            String t2 = aes.getPrimaryIdentifierType();
            this._writer.println(margn2 + "PrimaryIdentifier: " + s2);
            if (t2 != null) {
                this._writer.println(margn3 + "IdentifierType: " + t2);
            }
        }
        if (!(facelist = aes.getFaceList()).isEmpty()) {
            int nchan;
            AESAudioMetadata.Face f = (AESAudioMetadata.Face)facelist.get(0);
            this._writer.println(margn2 + "Face: ");
            this._writer.println(margn3 + "TimeLine: ");
            AESAudioMetadata.TimeDesc startTime = f.getStartTime();
            if (startTime != null) {
                this.writeAESTimeRange(margn3, startTime, f.getDuration());
            }
            if ((nchan = aes.getNumChannels()) != -1) {
                this._writer.println(margn4 + "NumChannels: " + Integer.toString(nchan));
            }
            String[] locs = aes.getMapLocations();
            for (int ch = 0; ch < nchan; ++ch) {
                this._writer.println(margn4 + "Stream:");
                this._writer.println(margn5 + "ChannelNum: " + Integer.toString(ch));
                this._writer.println(margn5 + "ChannelAssignment: " + locs[ch]);
            }
        }
        if (!(flist = aes.getFormatList()).isEmpty()) {
            AESAudioMetadata.FormatRegion rgn = (AESAudioMetadata.FormatRegion)flist.get(0);
            int bitDepth = rgn.getBitDepth();
            double sampleRate = rgn.getSampleRate();
            int wordSize = rgn.getWordSize();
            String[] bitRed = rgn.getBitrateReduction();
            if (bitDepth != -1 || sampleRate != -1.0 || wordSize != -1) {
                this._writer.println(margn2 + "FormatList:");
                this._writer.println(margn3 + "FormatRegion:");
                if (bitDepth != -1) {
                    this._writer.println(margn4 + "BitDepth: " + Integer.toString(bitDepth));
                }
                if (sampleRate != -1.0) {
                    this._writer.println(margn4 + "SampleRate: " + Double.toString(sampleRate));
                }
                if (wordSize != -1) {
                    this._writer.println(margn4 + "WordSize: " + Integer.toString(wordSize));
                }
                if (bitRed != null) {
                    this._writer.println(margn4 + "BitrateReduction");
                    this._writer.println(margn5 + "CodecName: " + bitRed[0]);
                    this._writer.println(margn5 + "codecNameVersion: " + bitRed[1]);
                    this._writer.println(margn5 + "codecCreatorApplication: " + bitRed[2]);
                    this._writer.println(margn5 + "codecCreatorApplicationVersion: " + bitRed[3]);
                    this._writer.println(margn5 + "codecQuality: " + bitRed[4]);
                    this._writer.println(margn5 + "dataRate: " + bitRed[5]);
                    this._writer.println(margn5 + "dataRateMode: " + bitRed[6]);
                }
            }
        }
    }

    private void writeAESTimeRange(String baseIndent, AESAudioMetadata.TimeDesc start, AESAudioMetadata.TimeDesc duration) {
        String margn1 = baseIndent + " ";
        String margn2 = margn1 + " ";
        String margn3 = margn2 + " ";
        this._writer.println(margn1 + "StartTime:");
        this._writer.println(margn2 + "FrameCount: 30");
        this._writer.println(margn2 + "TimeBase: 1000");
        this._writer.println(margn2 + "VideoField: FIELD_1");
        this._writer.println(margn2 + "CountingMode: NTSC_NON_DROP_FRAME");
        this._writer.println(margn2 + "Hours: " + Integer.toString(start.getHours()));
        this._writer.println(margn2 + "Minutes: " + Integer.toString(start.getMinutes()));
        this._writer.println(margn2 + "Seconds: " + Integer.toString(start.getSeconds()));
        this._writer.println(margn2 + "Frames: " + Integer.toString(start.getFrames()));
        this._writer.println(margn2 + "Samples: ");
        double sr = start.getSampleRate();
        if (sr == 1.0) {
            sr = this._sampleRate;
        }
        this._writer.println(margn3 + "SampleRate: S" + Integer.toString((int)sr));
        this._writer.println(margn3 + "NumberOfSamples: " + Integer.toString(start.getSamples()));
        this._writer.println(margn2 + "FilmFraming: NOT_APPLICABLE");
        this._writer.println(margn3 + "Type: ntscFilmFramingType");
        if (duration != null) {
            this._writer.println(margn1 + "Duration:");
            this._writer.println(margn2 + "FrameCount: 30");
            this._writer.println(margn2 + "TimeBase: 1000");
            this._writer.println(margn2 + "VideoField: FIELD_1");
            this._writer.println(margn2 + "CountingMode: NTSC_NON_DROP_FRAME");
            this._writer.println(margn2 + "Hours: " + Integer.toString(duration.getHours()));
            this._writer.println(margn2 + "Minutes: " + Integer.toString(duration.getMinutes()));
            this._writer.println(margn2 + "Seconds: " + Integer.toString(duration.getSeconds()));
            this._writer.println(margn2 + "Frames: " + Integer.toString(duration.getFrames()));
            this._writer.println(margn2 + "Samples: ");
            sr = duration.getSampleRate();
            if (sr == 1.0) {
                sr = this._sampleRate;
            }
            this._writer.println(margn3 + "SampleRate: S" + Integer.toString((int)sr));
            this._writer.println(margn3 + "NumberOfSamples: " + Integer.toString(duration.getSamples()));
            this._writer.println(margn2 + "FilmFraming: NOT_APPLICABLE");
            this._writer.println(margn3 + "Type: ntscFilmFramingType");
        }
    }

    protected void showNisoImageMetadata(NisoImageMetadata niso, String margin, boolean rawOutput) {
        if ("0.2".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata02(niso, margin, rawOutput);
        } else {
            this.showNisoImageMetadata10(niso, margin, rawOutput);
        }
    }

    private void showNisoImageMetadata02(NisoImageMetadata niso, String margin, boolean rawOutput) {
        String[] sarray;
        int i;
        Rational r;
        double[] darray;
        double d;
        int i2;
        long ln;
        long[] larray;
        int i3;
        Rational[] rarray;
        int[] iarray;
        int n;
        String margn2 = margin + " ";
        this._writer.println();
        String s2 = niso.getMimeType();
        if (s2 != null) {
            this._writer.println(margn2 + "MIMEType: " + s2);
        }
        if ((s2 = niso.getByteOrder()) != null) {
            this._writer.println(margn2 + "ByteOrder: " + s2);
        }
        if ((n = niso.getCompressionScheme()) != -1) {
            this._writer.println(margn2 + "CompressionScheme: " + this.addIntegerValue(n, NisoImageMetadata.COMPRESSION_SCHEME, NisoImageMetadata.COMPRESSION_SCHEME_INDEX, rawOutput));
        }
        if ((n = niso.getCompressionLevel()) != -1) {
            this._writer.println(margn2 + "CompressionLevel: " + n);
        }
        if ((n = niso.getColorSpace()) != -1) {
            this._writer.println(margn2 + "ColorSpace: " + this.addIntegerValue(n, NisoImageMetadata.COLORSPACE, NisoImageMetadata.COLORSPACE_INDEX, rawOutput));
        }
        if ((s2 = niso.getProfileName()) != null) {
            this._writer.println(margn2 + "ProfileName: " + s2);
        }
        if ((s2 = niso.getProfileURL()) != null) {
            this._writer.println(margn2 + "ProfileURL: " + s2);
        }
        if ((iarray = niso.getYCbCrSubSampling()) != null) {
            this._writer.print(margn2 + "YCbCrSubSampling: " + iarray[0]);
            for (int i4 = 1; i4 < iarray.length; ++i4) {
                this._writer.print(", " + iarray[i4]);
            }
            this._writer.println();
        }
        if ((n = niso.getYCbCrPositioning()) != -1) {
            this._writer.println(margn2 + "YCbCrPositioning: " + this.addIntegerValue(n, NisoImageMetadata.YCBCR_POSITIONING, rawOutput));
        }
        if ((rarray = niso.getYCbCrCoefficients()) != null) {
            this._writer.print(margn2 + "YCbCrCoefficients: " + this.addRationalValue(rarray[0], rawOutput));
            for (i3 = 1; i3 < rarray.length; ++i3) {
                this._writer.print(", " + this.addRationalValue(rarray[i3], rawOutput));
            }
            this._writer.println();
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            this._writer.print(margn2 + "ReferenceBlackWhite: " + this.addRationalValue(rarray[0], rawOutput));
            for (i3 = 1; i3 < rarray.length; ++i3) {
                this._writer.print(", " + this.addRationalValue(rarray[i3], rawOutput));
            }
            this._writer.println();
        }
        if ((n = niso.getSegmentType()) != -1) {
            this._writer.println(margn2 + "SegmentType: " + this.addIntegerValue(n, NisoImageMetadata.SEGMENT_TYPE, rawOutput));
        }
        if ((larray = niso.getStripOffsets()) != null) {
            this._writer.print(margn2 + "StripOffsets: " + larray[0]);
            for (int i5 = 1; i5 < larray.length; ++i5) {
                this._writer.print(", " + larray[i5]);
            }
            this._writer.println();
        }
        if ((ln = niso.getRowsPerStrip()) != -1L) {
            this._writer.println(margn2 + "RowsPerStrip: " + ln);
        }
        if ((larray = niso.getStripByteCounts()) != null) {
            this._writer.print(margn2 + "StripByteCounts: " + larray[0]);
            for (i2 = 1; i2 < larray.length; ++i2) {
                this._writer.print(", " + larray[i2]);
            }
            this._writer.println();
        }
        if ((ln = niso.getTileWidth()) != -1L) {
            this._writer.println(margn2 + "TileWidth: " + ln);
        }
        if ((ln = niso.getTileLength()) != -1L) {
            this._writer.println(margn2 + "TileLength: " + ln);
        }
        if ((larray = niso.getTileOffsets()) != null) {
            this._writer.print(margn2 + "TileOffsets: " + larray[0]);
            for (i2 = 1; i2 < larray.length; ++i2) {
                this._writer.print(", " + larray[i2]);
            }
            this._writer.println();
        }
        if ((larray = niso.getTileByteCounts()) != null) {
            this._writer.print(margn2 + "TileByteCounts: " + larray[0]);
            for (i2 = 1; i2 < larray.length; ++i2) {
                this._writer.print(", " + larray[i2]);
            }
            this._writer.println();
        }
        if ((n = niso.getPlanarConfiguration()) != -1) {
            this._writer.println(margn2 + "PlanarConfiguration: " + this.addIntegerValue(n, NisoImageMetadata.PLANAR_CONFIGURATION, rawOutput));
        }
        if ((s2 = niso.getImageIdentifier()) != null) {
            this._writer.println(margn2 + "ImageIdentifier: " + s2);
        }
        if ((s2 = niso.getImageIdentifierLocation()) != null) {
            this._writer.println(margn2 + "ImageIdentifierLocation: " + s2);
        }
        if ((ln = niso.getFileSize()) != -1L) {
            this._writer.println(margn2 + "FileSize: " + ln);
        }
        if ((n = niso.getChecksumMethod()) != -1) {
            this._writer.println(margn2 + "ChecksumMethod: " + this.addIntegerValue(n, NisoImageMetadata.CHECKSUM_METHOD, rawOutput));
        }
        if ((s2 = niso.getChecksumValue()) != null) {
            this._writer.println(margn2 + "ChecksumValue: " + s2);
        }
        if ((n = niso.getOrientation()) != -1) {
            this._writer.println(margn2 + "Orientation: " + this.addIntegerValue(n, NisoImageMetadata.ORIENTATION, rawOutput));
        }
        if ((n = niso.getDisplayOrientation()) != -1) {
            this._writer.println(margn2 + "DisplayOrientation: " + this.addIntegerValue(n, NisoImageMetadata.DISPLAY_ORIENTATION, rawOutput));
        }
        if ((ln = niso.getXTargetedDisplayAR()) != -1L) {
            this._writer.println(margn2 + "XTargetedDisplayAR: " + ln);
        }
        if ((ln = niso.getYTargetedDisplayAR()) != -1L) {
            this._writer.println(margn2 + "YTargetedDisplayAR: " + ln);
        }
        if ((s2 = niso.getPreferredPresentation()) != null) {
            this._writer.println(margn2 + "PreferredPresentation: " + s2);
        }
        if ((s2 = niso.getSourceType()) != null) {
            this._writer.println(margn2 + "SourceType: " + s2);
        }
        if ((s2 = niso.getImageProducer()) != null) {
            this._writer.println(margn2 + "ImageProducer: " + s2);
        }
        if ((s2 = niso.getHostComputer()) != null) {
            this._writer.println(margn2 + "HostComputer: " + s2);
        }
        if ((s2 = niso.getOS()) != null) {
            this._writer.println(margn2 + "OperatingSystem: " + s2);
        }
        if ((s2 = niso.getOSVersion()) != null) {
            this._writer.println(margn2 + "OSVersion: " + s2);
        }
        if ((s2 = niso.getDeviceSource()) != null) {
            this._writer.println(margn2 + "DeviceSource: " + s2);
        }
        if ((s2 = niso.getScannerManufacturer()) != null) {
            this._writer.println(margn2 + "ScannerManufacturer: " + s2);
        }
        if ((s2 = niso.getScannerModelName()) != null) {
            this._writer.println(margn2 + "ScannerModelName: " + s2);
        }
        if ((s2 = niso.getScannerModelNumber()) != null) {
            this._writer.println(margn2 + "ScannerModelNumber: " + s2);
        }
        if ((s2 = niso.getScannerModelSerialNo()) != null) {
            this._writer.println(margn2 + "ScannerModelSerialNo: " + s2);
        }
        if ((s2 = niso.getScanningSoftware()) != null) {
            this._writer.println(margn2 + "ScanningSoftware: " + s2);
        }
        if ((s2 = niso.getScanningSoftwareVersionNo()) != null) {
            this._writer.println(margn2 + "ScanningSoftwareVersionNo: " + s2);
        }
        if ((d = niso.getPixelSize()) != -1.0) {
            this._writer.println(margn2 + "PixelSize: " + d);
        }
        if ((d = niso.getXPhysScanResolution()) != -1.0) {
            this._writer.println(margn2 + "XPhysScanResolution: " + d);
        }
        if ((d = niso.getYPhysScanResolution()) != -1.0) {
            this._writer.println(margn2 + "YPhysScanResolution: " + d);
        }
        if ((s2 = niso.getDigitalCameraManufacturer()) != null) {
            this._writer.println(margn2 + "DigitalCameraManufacturer: " + s2);
        }
        if ((s2 = niso.getDigitalCameraModel()) != null) {
            this._writer.println(margn2 + "DigitalCameraModel: " + s2);
        }
        if ((d = niso.getFNumber()) != -1.0) {
            this._writer.println(margn2 + "FNumber: " + d);
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            this._writer.println(margn2 + "ExposureTime: " + d);
        }
        if ((d = niso.getBrightness()) != -1.0) {
            this._writer.println(margn2 + "Brightness: " + d);
        }
        if ((d = niso.getExposureBias()) != -1.0) {
            this._writer.println(margn2 + "ExposureBias: " + d);
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            this._writer.print(margn2 + "SubjectDistance: " + darray[0]);
            for (int i6 = 1; i6 < darray.length; ++i6) {
                this._writer.print(", " + darray[i6]);
            }
            this._writer.println();
        }
        if ((n = niso.getMeteringMode()) != -1) {
            this._writer.println(margn2 + "MeteringMode: " + this.addIntegerValue(n, NisoImageMetadata.METERING_MODE, rawOutput));
        }
        if ((n = niso.getSceneIlluminant()) != -1) {
            this._writer.println(margn2 + "SceneIlluminant: " + this.addIntegerValue(n, NisoImageMetadata.METERING_MODE, rawOutput));
        }
        if ((d = niso.getColorTemp()) != -1.0) {
            this._writer.println(margn2 + "ColorTemp: " + d);
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            this._writer.println(margn2 + "FocalLength: " + d);
        }
        if ((n = niso.getFlash()) != -1) {
            this._writer.println(margn2 + "Flash: " + this.addIntegerValue(n, NisoImageMetadata.FLASH, rawOutput));
        }
        if ((d = niso.getFlashEnergy()) != -1.0) {
            this._writer.println(margn2 + "FlashEnergy: " + d);
        }
        if ((n = niso.getFlashReturn()) != -1) {
            this._writer.println(margn2 + "FlashReturn: " + this.addIntegerValue(n, NisoImageMetadata.FLASH_RETURN, rawOutput));
        }
        if ((n = niso.getBackLight()) != -1) {
            this._writer.println(margn2 + "BackLight: " + this.addIntegerValue(n, NisoImageMetadata.BACKLIGHT, rawOutput));
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            this._writer.println(margn2 + "ExposureIndex: " + d);
        }
        if ((n = niso.getAutoFocus()) != -1) {
            this._writer.println(margn2 + "AutoFocus: " + this.addIntegerValue(n, NisoImageMetadata.AUTOFOCUS, rawOutput));
        }
        if ((d = niso.getXPrintAspectRatio()) != -1.0) {
            this._writer.println(margn2 + "XPrintAspectRatio: " + d);
        }
        if ((d = niso.getYPrintAspectRatio()) != -1.0) {
            this._writer.println(margn2 + "YPrintAspectRatio: " + d);
        }
        if ((n = niso.getSensor()) != -1) {
            this._writer.println(margn2 + "Sensor: " + this.addIntegerValue(n, NisoImageMetadata.SENSOR, rawOutput));
        }
        if ((s2 = niso.getDateTimeCreated()) != null) {
            this._writer.println(margn2 + "DateTimeCreated: " + s2);
        }
        if ((s2 = niso.getMethodology()) != null) {
            this._writer.println(margn2 + "Methodology: " + s2);
        }
        if ((n = niso.getSamplingFrequencyPlane()) != -1) {
            this._writer.println(margn2 + "SamplingFrequencyPlane: " + this.addIntegerValue(n, NisoImageMetadata.SAMPLING_FREQUENCY_PLANE, rawOutput));
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            this._writer.println(margn2 + "SamplingFrequencyUnit: " + this.addIntegerValue(n, NisoImageMetadata.SAMPLING_FREQUENCY_UNIT, rawOutput));
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            this._writer.println(margn2 + "XSamplingFrequency: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            this._writer.println(margn2 + "YSamplingFrequency: " + this.addRationalValue(r, rawOutput));
        }
        if ((ln = niso.getImageWidth()) != -1L) {
            this._writer.println(margn2 + "ImageWidth: " + ln);
        }
        if ((ln = niso.getImageLength()) != -1L) {
            this._writer.println(margn2 + "ImageLength: " + ln);
        }
        if ((d = niso.getSourceXDimension()) != -1.0) {
            this._writer.println(margn2 + "SourceXDimension: " + d);
        }
        if ((n = niso.getSourceXDimensionUnit()) != -1) {
            this._writer.println(margn2 + "SourceXDimensionUnit: " + this.addIntegerValue(n, NisoImageMetadata.SOURCE_DIMENSION_UNIT, rawOutput));
        }
        if ((d = niso.getSourceYDimension()) != -1.0) {
            this._writer.println(margn2 + "SourceYDimension: " + ln);
        }
        if ((n = niso.getSourceYDimensionUnit()) != -1) {
            this._writer.println(margn2 + "SourceYDimensionUnit: " + this.addIntegerValue(n, NisoImageMetadata.SOURCE_DIMENSION_UNIT, rawOutput));
        }
        if ((iarray = niso.getBitsPerSample()) != null) {
            this._writer.print(margn2 + "BitsPerSample: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            this._writer.println(margn2 + "SamplesPerPixel: " + n);
        }
        if ((iarray = niso.getExtraSamples()) != null) {
            this._writer.print(margn2 + "ExtraSamples: " + this.addIntegerValue(iarray[0], NisoImageMetadata.EXTRA_SAMPLES, rawOutput));
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + this.addIntegerValue(iarray[i], NisoImageMetadata.EXTRA_SAMPLES, rawOutput));
            }
            this._writer.println();
        }
        if ((s2 = niso.getColormapReference()) != null) {
            this._writer.println(margn2 + "ColormapReference: " + s2);
        }
        if ((iarray = niso.getColormapBitCodeValue()) != null) {
            this._writer.print(margn2 + "ColormapBitCodeValue: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
        }
        if ((iarray = niso.getColormapRedValue()) != null) {
            this._writer.print(margn2 + "ColormapRedValue: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
        }
        if ((iarray = niso.getColormapGreenValue()) != null) {
            this._writer.print(margn2 + "ColormapGreenValue: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
        }
        if ((iarray = niso.getColormapBlueValue()) != null) {
            this._writer.print(margn2 + "ColormapBlueValue: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
        }
        if ((iarray = niso.getGrayResponseCurve()) != null) {
            this._writer.print(margn2 + "GrayResponseCurve: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
        }
        if ((n = niso.getGrayResponseUnit()) != -1) {
            this._writer.println(margn2 + "GrayResponseUnit: " + this.addIntegerValue(n, NisoImageMetadata.GRAY_RESPONSE_UNIT_02, rawOutput));
        }
        if ((r = niso.getWhitePointXValue()) != null) {
            this._writer.println(margn2 + "WhitePointXValue: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getWhitePointYValue()) != null) {
            this._writer.println(margn2 + "WhitePointXValue: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesRedX()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesRedX: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesRedY: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesGreenX: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesGreenY: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesBlueX: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesBlueY: " + this.addRationalValue(r, rawOutput));
        }
        if ((n = niso.getTargetType()) != -1) {
            this._writer.println(margn2 + "TargetType: " + this.addIntegerValue(n, NisoImageMetadata.TARGET_TYPE, rawOutput));
        }
        if ((s2 = niso.getTargetIDManufacturer()) != null) {
            this._writer.println(margn2 + "TargetIDManufacturer: " + s2);
        }
        if ((s2 = niso.getTargetIDName()) != null) {
            this._writer.println(margn2 + "TargetIDName: " + s2);
        }
        if ((s2 = niso.getTargetIDNo()) != null) {
            this._writer.println(margn2 + "TargetIDNo: " + s2);
        }
        if ((s2 = niso.getTargetIDMedia()) != null) {
            this._writer.println(margn2 + "TargetIDMedia: " + s2);
        }
        if ((s2 = niso.getImageData()) != null) {
            this._writer.println(margn2 + "ImageData: " + s2);
        }
        if ((s2 = niso.getPerformanceData()) != null) {
            this._writer.println(margn2 + "PerformanceData: " + s2);
        }
        if ((s2 = niso.getProfiles()) != null) {
            this._writer.println(margn2 + "Profiles: " + s2);
        }
        if ((s2 = niso.getDateTimeProcessed()) != null) {
            this._writer.println(margn2 + "DateTimeProcessed: " + s2);
        }
        if ((s2 = niso.getSourceData()) != null) {
            this._writer.println(margn2 + "SourceData: " + s2);
        }
        if ((s2 = niso.getProcessingAgency()) != null) {
            this._writer.println(margn2 + "ProcessingAgency: " + s2);
        }
        if ((s2 = niso.getProcessingSoftwareName()) != null) {
            this._writer.println(margn2 + "ProcessingSoftwareName: " + s2);
        }
        if ((s2 = niso.getProcessingSoftwareVersion()) != null) {
            this._writer.println(margn2 + "ProcessingSoftwareVersion: " + s2);
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            this._writer.print(margn2 + "ProcessingActions: " + sarray[0]);
            for (int i7 = 1; i7 < sarray.length; ++i7) {
                this._writer.print(", " + sarray[i7]);
            }
            this._writer.println();
        }
    }

    private void showNisoImageMetadata10(NisoImageMetadata niso, String margin, boolean rawOutput) {
        String[] sarray;
        int i;
        Rational r;
        double[] darray;
        double d;
        int i2;
        Rational[] rarray;
        int[] iarray;
        int n;
        long ln;
        String margn2 = margin + " ";
        this._writer.println();
        String s2 = niso.getImageIdentifier();
        if (s2 != null) {
            this._writer.println(margn2 + "ImageIdentifier: " + s2);
        }
        if ((ln = niso.getFileSize()) != -1L) {
            this._writer.println(margn2 + "FileSize: " + ln);
        }
        if ((s2 = niso.getByteOrder()) != null) {
            if (s2.startsWith("big")) {
                s2 = "big_endian";
            } else if (s2.startsWith("little")) {
                s2 = "little_endian";
            }
            this._writer.println(margn2 + "ByteOrder: " + s2);
        }
        if ((n = niso.getCompressionScheme()) != -1) {
            this._writer.println(margn2 + "CompressionScheme: " + this.addIntegerValue(n, NisoImageMetadata.COMPRESSION_SCHEME, NisoImageMetadata.COMPRESSION_SCHEME_INDEX, rawOutput));
        }
        if ((n = niso.getCompressionLevel()) != -1) {
            this._writer.println(margn2 + "CompressionLevel: " + n);
        }
        if ((n = niso.getChecksumMethod()) != -1) {
            this._writer.println(margn2 + "ChecksumMethod: " + this.addIntegerValue(n, NisoImageMetadata.CHECKSUM_METHOD, rawOutput));
        }
        if ((s2 = niso.getChecksumValue()) != null) {
            this._writer.println(margn2 + "ChecksumValue: " + s2);
        }
        if ((ln = niso.getImageWidth()) != -1L) {
            this._writer.println(margn2 + "ImageWidth: " + ln);
        }
        if ((ln = niso.getImageLength()) != -1L) {
            this._writer.println(margn2 + "ImageHeight: " + ln);
        }
        if ((n = niso.getColorSpace()) != -1) {
            this._writer.println(margn2 + "ColorSpace: " + this.addIntegerValue(n, NisoImageMetadata.COLORSPACE, NisoImageMetadata.COLORSPACE_INDEX, rawOutput));
        }
        if ((s2 = niso.getProfileName()) != null) {
            this._writer.println(margn2 + "iccProfileName: " + s2);
        }
        if ((s2 = niso.getProfileURL()) != null) {
            this._writer.println(margn2 + "iccProfileURL: " + s2);
        }
        if ((iarray = niso.getYCbCrSubSampling()) != null) {
            this._writer.print(margn2 + "YCbCrSubSampling: " + iarray[0]);
            for (int i3 = 1; i3 < iarray.length; ++i3) {
                this._writer.print(", " + iarray[i3]);
            }
            this._writer.println();
        }
        if ((rarray = niso.getYCbCrCoefficients()) != null) {
            this._writer.print(margn2 + "YCbCrCoefficients: " + this.addRationalValue(rarray[0], rawOutput));
            for (i2 = 1; i2 < rarray.length; ++i2) {
                this._writer.print(", " + this.addRationalValue(rarray[i2], rawOutput));
            }
            this._writer.println();
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            this._writer.print(margn2 + "ReferenceBlackWhite: " + this.addRationalValue(rarray[0], rawOutput));
            for (i2 = 1; i2 < rarray.length; ++i2) {
                this._writer.print(", " + this.addRationalValue(rarray[i2], rawOutput));
            }
            this._writer.println();
        }
        if ((s2 = niso.getSourceType()) != null) {
            this._writer.println(margn2 + "SourceType: " + s2);
        }
        if ((s2 = niso.getSourceID()) != null) {
            this._writer.println(margn2 + "SourceID" + s2);
        }
        if ((d = niso.getSourceXDimension()) != -1.0) {
            this._writer.println(margn2 + "SourceXDimension: " + d);
        }
        if ((n = niso.getSourceXDimensionUnit()) != -1) {
            this._writer.println(margn2 + "SourceXDimensionUnit: " + this.addIntegerValue(n, NisoImageMetadata.SOURCE_DIMENSION_UNIT, rawOutput));
        }
        if ((d = niso.getSourceYDimension()) != -1.0) {
            this._writer.println(margn2 + "SourceYDimension: " + ln);
        }
        if ((n = niso.getSourceYDimensionUnit()) != -1) {
            this._writer.println(margn2 + "SourceYDimensionUnit: " + this.addIntegerValue(n, NisoImageMetadata.SOURCE_DIMENSION_UNIT, rawOutput));
        }
        if ((s2 = niso.getDateTimeCreated()) != null) {
            this._writer.println(margn2 + "DateTimeCreated: " + s2);
        }
        if ((s2 = niso.getImageProducer()) != null) {
            this._writer.println(margn2 + "ImageProducer: " + s2);
        }
        if ((s2 = niso.getDeviceSource()) != null) {
            this._writer.println(margn2 + "CaptureDevice: " + s2);
        }
        if ((s2 = niso.getScannerManufacturer()) != null) {
            this._writer.println(margn2 + "ScannerManufacturer: " + s2);
        }
        if ((s2 = niso.getScannerModelName()) != null) {
            this._writer.println(margn2 + "ScannerModelName: " + s2);
        }
        if ((s2 = niso.getScannerModelNumber()) != null) {
            this._writer.println(margn2 + "ScannerModelNumber: " + s2);
        }
        if ((s2 = niso.getScannerModelSerialNo()) != null) {
            this._writer.println(margn2 + "ScannerModelSerialNo: " + s2);
        }
        double xres = niso.getXPhysScanResolution();
        double yres = niso.getYPhysScanResolution();
        if (xres != -1.0 && yres != -1.0) {
            double res = xres > yres ? xres : yres;
            this._writer.println(margn2 + "MaximumOpticalResolution: " + Double.toString(res));
        }
        if ((s2 = niso.getScanningSoftware()) != null) {
            this._writer.println(margn2 + "ScanningSoftware: " + s2);
        }
        if ((s2 = niso.getScanningSoftwareVersionNo()) != null) {
            this._writer.println(margn2 + "ScanningSoftwareVersionNo: " + s2);
        }
        if ((s2 = niso.getDigitalCameraManufacturer()) != null) {
            this._writer.println(margn2 + "DigitalCameraManufacturer: " + s2);
        }
        if ((s2 = niso.getDigitalCameraModel()) != null) {
            this._writer.println(margn2 + "DigitalCameraModel: " + s2);
        }
        if ((d = niso.getFNumber()) != -1.0) {
            this._writer.println(margn2 + "FNumber: " + d);
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            this._writer.println(margn2 + "ExposureTime: " + d);
        }
        if ((d = niso.getBrightness()) != -1.0) {
            this._writer.println(margn2 + "BrightnessValue: " + d);
        }
        if ((d = niso.getExposureBias()) != -1.0) {
            this._writer.println(margn2 + "ExposureBiasValue: " + d);
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            this._writer.print(margn2 + "SubjectDistance: " + darray[0]);
            for (int i4 = 1; i4 < darray.length; ++i4) {
                this._writer.print(", " + darray[i4]);
            }
            this._writer.println();
        }
        if ((n = niso.getMeteringMode()) != -1) {
            this._writer.println(margn2 + "MeteringMode: " + this.addIntegerValue(n, NisoImageMetadata.METERING_MODE, rawOutput));
        }
        if ((n = niso.getFlash()) != -1) {
            this._writer.println(margn2 + "Flash: " + this.addIntegerValue(n, NisoImageMetadata.FLASH, rawOutput));
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            this._writer.println(margn2 + "FocalLength: " + d);
        }
        if ((d = niso.getFlashEnergy()) != -1.0) {
            this._writer.println(margn2 + "FlashEnergy: " + d);
        }
        if ((n = niso.getBackLight()) != -1) {
            this._writer.println(margn2 + "BackLight: " + this.addIntegerValue(n, NisoImageMetadata.BACKLIGHT, rawOutput));
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            this._writer.println(margn2 + "ExposureIndex: " + d);
        }
        if ((n = niso.getAutoFocus()) != -1) {
            this._writer.println(margn2 + "AutoFocus: " + this.addIntegerValue(n, NisoImageMetadata.AUTOFOCUS, rawOutput));
        }
        if ((d = niso.getXPrintAspectRatio()) != -1.0) {
            this._writer.println(margn2 + "XPrintAspectRatio: " + d);
        }
        if ((d = niso.getYPrintAspectRatio()) != -1.0) {
            this._writer.println(margn2 + "YPrintAspectRatio: " + d);
        }
        if ((n = niso.getOrientation()) != -1) {
            this._writer.println(margn2 + "Orientation: " + this.addIntegerValue(n, NisoImageMetadata.ORIENTATION, rawOutput));
        }
        if ((s2 = niso.getMethodology()) != null) {
            this._writer.println(margn2 + "Methodology: " + s2);
        }
        if ((n = niso.getSamplingFrequencyPlane()) != -1) {
            this._writer.println(margn2 + "SamplingFrequencyPlane: " + this.addIntegerValue(n, NisoImageMetadata.SAMPLING_FREQUENCY_PLANE, rawOutput));
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            this._writer.println(margn2 + "SamplingFrequencyUnit: " + this.addIntegerValue(n, NisoImageMetadata.SAMPLING_FREQUENCY_UNIT, rawOutput));
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            this._writer.println(margn2 + "XSamplingFrequency: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            this._writer.println(margn2 + "YSamplingFrequency: " + this.addRationalValue(r, rawOutput));
        }
        if ((iarray = niso.getBitsPerSample()) != null) {
            this._writer.print(margn2 + "BitsPerSample: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
            this._writer.println(margn2 + "BitsPerSampleUnit: integer");
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            this._writer.println(margn2 + "SamplesPerPixel: " + n);
        }
        if ((iarray = niso.getExtraSamples()) != null) {
            this._writer.print(margn2 + "ExtraSamples: " + this.addIntegerValue(iarray[0], NisoImageMetadata.EXTRA_SAMPLES, rawOutput));
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + this.addIntegerValue(iarray[i], NisoImageMetadata.EXTRA_SAMPLES, rawOutput));
            }
            this._writer.println();
        }
        if ((s2 = niso.getColormapReference()) != null) {
            this._writer.println(margn2 + "ColormapReference: " + s2);
        }
        if ((iarray = niso.getGrayResponseCurve()) != null) {
            this._writer.print(margn2 + "GrayResponseCurve: " + iarray[0]);
            for (i = 1; i < iarray.length; ++i) {
                this._writer.print(", " + iarray[i]);
            }
            this._writer.println();
        }
        if ((n = niso.getGrayResponseUnit()) != -1) {
            this._writer.println(margn2 + "GrayResponseUnit: " + this.addIntegerValue(n, NisoImageMetadata.GRAY_RESPONSE_UNIT_02, rawOutput));
        }
        if ((r = niso.getWhitePointXValue()) != null) {
            this._writer.println(margn2 + "WhitePointXValue: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getWhitePointYValue()) != null) {
            this._writer.println(margn2 + "WhitePointXValue: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesRedX()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesRedX: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesRedY: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesGreenX: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesGreenY: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesBlueX: " + this.addRationalValue(r, rawOutput));
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            this._writer.println(margn2 + "PrimaryChromaticitiesBlueY: " + this.addRationalValue(r, rawOutput));
        }
        if ((n = niso.getTargetType()) != -1) {
            this._writer.println(margn2 + "TargetType: " + this.addIntegerValue(n, NisoImageMetadata.TARGET_TYPE, rawOutput));
        }
        if ((s2 = niso.getTargetIDManufacturer()) != null) {
            this._writer.println(margn2 + "TargetIDManufacturer: " + s2);
        }
        if ((s2 = niso.getTargetIDName()) != null) {
            this._writer.println(margn2 + "TargetIDName: " + s2);
        }
        if ((s2 = niso.getTargetIDNo()) != null) {
            this._writer.println(margn2 + "TargetIDNo: " + s2);
        }
        if ((s2 = niso.getTargetIDMedia()) != null) {
            this._writer.println(margn2 + "TargetIDMedia: " + s2);
        }
        if ((s2 = niso.getImageData()) != null) {
            this._writer.println(margn2 + "ExternalTarget: " + s2);
        }
        if ((s2 = niso.getPerformanceData()) != null) {
            this._writer.println(margn2 + "PerformanceData: " + s2);
        }
        if ((s2 = niso.getSourceData()) != null) {
            this._writer.println(margn2 + "SourceData: " + s2);
        }
        if ((s2 = niso.getProcessingAgency()) != null) {
            this._writer.println(margn2 + "ProcessingAgency: " + s2);
        }
        if ((s2 = niso.getProcessingSoftwareName()) != null) {
            this._writer.println(margn2 + "ProcessingSoftwareName: " + s2);
        }
        if ((s2 = niso.getProcessingSoftwareVersion()) != null) {
            this._writer.println(margn2 + "ProcessingSoftwareVersion: " + s2);
        }
        if ((s2 = niso.getOS()) != null) {
            this._writer.println(margn2 + "OperatingSystem: " + s2);
        }
        if ((s2 = niso.getOSVersion()) != null) {
            this._writer.println(margn2 + "OSVersion: " + s2);
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            this._writer.print(margn2 + "ProcessingActions: " + sarray[0]);
            for (int i5 = 1; i5 < sarray.length; ++i5) {
                this._writer.print(", " + sarray[i5]);
            }
            this._writer.println();
        }
    }

    private String addIntegerValue(int value, String[] labels, boolean rawOutput) {
        String s2 = null;
        s2 = !rawOutput && 0 <= value && value < labels.length ? labels[value] : Integer.toString(value);
        return s2;
    }

    private String addIntegerValue(int value, String[] labels, int[] index, boolean rawOutput) {
        String s2 = null;
        boolean outOfRange = false;
        if (!rawOutput) {
            int n = -1;
            for (int i = 0; i < index.length; ++i) {
                if (value != index[i]) continue;
                n = i;
                break;
            }
            if (n > -1) {
                s2 = labels[n];
            } else {
                outOfRange = true;
            }
        }
        if (rawOutput || outOfRange) {
            s2 = Integer.toString(value);
        }
        return s2;
    }

    private String addRationalValue(Rational r, boolean rawOutput) {
        String s2 = null;
        s2 = !rawOutput ? this._format.format(r.toDouble()) : r.toString();
        return s2;
    }
}

