/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.gzip;

import edu.harvard.hul.ois.jhove.module.gzip.GzipEntryData;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jwat.gzip.GzipEntry;

public class GzipEntryProperties {
    protected GzipEntryData data;
    private Map<String, String> properties;

    public GzipEntryProperties(GzipEntry entry) {
        this.data = new GzipEntryData(entry);
    }

    public Map<String, String> getProperties() {
        this.properties = new LinkedHashMap<String, String>();
        this.setProperty(this.data.isNonCompliant, "Is non compliant.");
        this.setProperty(this.data.offset, "Offset value.");
        this.setProperty(this.data.fileName, "GZip entry name.");
        this.setProperty(this.data.comment, "GZip entry comment.");
        this.setProperty(this.data.date, "GZip entry date.");
        this.setProperty(this.data.method.label, "GZip entry compression method.");
        this.setProperty(this.data.os.label, "GZip entry operating system.");
        this.setProperty(this.getCrc16(), "GZip entry header crc16.");
        this.setProperty("0x" + Integer.toHexString(this.data.readCrc32), "GZip entry crc32.");
        this.setProperty(this.data.readISize, "GZip entry extracted size (ISIZE) value.");
        this.setProperty(this.data.size, "GZip entry (computed) uncompressed size, in bytes.");
        this.setProperty(this.data.csize, "GZip entry (computed) compressed size, in bytes.");
        this.setProperty(this.getCompressionRatio(), "GZip entry (computed) compression ratio.");
        return this.properties;
    }

    private String getCrc16() {
        String crc16 = this.data.readCrc16 != null ? "0x" + Integer.toHexString(this.data.readCrc16 & 0xFFFF) : null;
        return crc16;
    }

    private String getCompressionRatio() {
        Double ratio = -1.0;
        long size = this.data.size;
        long csize = this.data.csize;
        if (size > 0L && csize > 0L) {
            long l = (size - csize) * 10000L / size;
            ratio = (double)l / 100.0;
        }
        return ratio.toString();
    }

    private void setProperty(String variable, String description) {
        if (variable != null && !variable.isEmpty()) {
            this.properties.put(description, variable);
        }
    }

    private void setProperty(Long variable, String description) {
        if (variable != null) {
            this.properties.put(description, variable.toString());
        }
    }

    private void setProperty(Boolean variable, String description) {
        if (variable != null) {
            this.properties.put(description, variable.toString());
        }
    }

    private void setProperty(Date variable, String description) {
        if (variable != null) {
            this.properties.put(description, variable.toString());
        }
    }
}

