/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;

public class CODMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int codeStyle = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int progOrder = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int nLayers = this._module.readUnsignedShort(this._dstream);
        int mcTrans = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int nDecomp = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int codeBlockWid = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int codeBlockHt = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int codeBlockStyle = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int xform = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int[] precSize = null;
        if ((codeStyle & 1) != 0) {
            precSize = new int[nDecomp + 1];
            for (int i = 0; i < nDecomp + 1; ++i) {
                precSize[i] = ModuleBase.readUnsignedByte(this._dstream, this._module);
            }
        }
        MainOrTile cs = this.getMainOrTile();
        ArrayList<Property> propList = new ArrayList<Property>(12);
        propList.add(new Property("CodingStyle", PropertyType.INTEGER, new Integer(codeStyle)));
        propList.add(new Property("ProgressionOrder", PropertyType.INTEGER, new Integer(progOrder)));
        propList.add(new Property("NumberOfLayers", PropertyType.INTEGER, new Integer(nLayers)));
        propList.add(new Property("MultipleComponentTransformation", PropertyType.INTEGER, new Integer(mcTrans)));
        propList.add(new Property("NumberDecompositionLevels", PropertyType.INTEGER, new Integer(nDecomp)));
        propList.add(new Property("CodeBlockWidth", PropertyType.INTEGER, new Integer(codeBlockWid)));
        propList.add(new Property("CodeBlockHeight", PropertyType.INTEGER, new Integer(codeBlockHt)));
        propList.add(new Property("CodeBlockStyle", PropertyType.INTEGER, new Integer(codeBlockStyle)));
        propList.add(new Property("Transformation", PropertyType.INTEGER, new Integer(xform)));
        if (precSize != null) {
            propList.add(new Property("PrecinctSize", PropertyType.INTEGER, PropertyArity.ARRAY, precSize));
        }
        cs.setCODProperty(new Property("CodingStyleDefault", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }
}

