/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CodestreamRegBox
extends JP2Box {
    public CodestreamRegBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof ComposLayerHdrBox)) {
            this.wrongBoxContext();
            return false;
        }
        Property[] propArray = new Property[3];
        propArray[0] = new Property("HorizontalGridSize", PropertyType.INTEGER, new Integer(this._module.readUnsignedShort(this._dstrm)));
        propArray[1] = new Property("VerticalGridSize", PropertyType.INTEGER, new Integer(this._module.readUnsignedShort(this._dstrm)));
        int bytesLeft = (int)this._boxHeader.getDataLength() - 4;
        int nStreams = bytesLeft / 6;
        Property[] streamsProp = new Property[nStreams];
        for (int i = 0; i < nStreams; ++i) {
            Property[] csProp = new Property[]{new Property("CodestreamNumber", PropertyType.INTEGER, new Integer(this._module.readUnsignedShort(this._dstrm))), new Property("HorizontalResolution", PropertyType.INTEGER, new Integer(ModuleBase.readUnsignedByte(this._dstrm, this._module))), new Property("VerticalResolution", PropertyType.INTEGER, new Integer(ModuleBase.readUnsignedByte(this._dstrm, this._module))), new Property("HorizontalOffset", PropertyType.INTEGER, new Integer(ModuleBase.readUnsignedByte(this._dstrm, this._module))), new Property("VerticalOffset", PropertyType.INTEGER, new Integer(ModuleBase.readUnsignedByte(this._dstrm, this._module)))};
            streamsProp[i] = new Property("Codestreams", PropertyType.PROPERTY, PropertyArity.ARRAY, csProp);
        }
        ((ComposLayerHdrBox)this._parentBox).addCodestreamReg(new Property("CodestreamRegistration", PropertyType.PROPERTY, PropertyArity.ARRAY, streamsProp));
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Codestream Registration Box";
    }
}

