/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ComponentMapBox
extends JP2Box {
    public ComponentMapBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof JP2HeaderBox) && !(this._parentBox instanceof CodestreamHeaderBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        int ncomp = len / 4;
        Property[] parray = new Property[ncomp];
        App app = this._module.getApp();
        for (int i = 0; i < ncomp; ++i) {
            Property[] cprop = new Property[3];
            int index = this._module.readUnsignedShort(this._dstrm);
            cprop[0] = new Property("ComponentIndex", PropertyType.INTEGER, new Integer(index));
            int mtyp = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            cprop[1] = this._module.addIntegerProperty("MTyp", mtyp, JP2Strings.mtypStr);
            int pcol = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            cprop[2] = new Property("PaletteComponent", PropertyType.INTEGER, new Integer(pcol));
            parray[i] = new Property("Component", PropertyType.PROPERTY, PropertyArity.ARRAY, cprop);
        }
        Property cmProp = new Property("ComponentMapping", PropertyType.PROPERTY, PropertyArity.ARRAY, parray);
        if (this._parentBox instanceof CodestreamHeaderBox) {
            Codestream cs = ((CodestreamHeaderBox)this._parentBox).getCodestream();
            cs.setCompMapProperty(cmProp);
        } else {
            this._module.addProperty(cmProp);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Component Mapping Box";
    }
}

