/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompOptionsBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.InstructionSetBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CompositionBox
extends JP2Box {
    private List<Property> instSets;
    private long _height;
    private long _width;
    private int _loop;

    public CompositionBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        this.instSets = new LinkedList<Property>();
        if (!this.hasNext()) {
            this.emptyBox();
            return false;
        }
        JP2Box box = (JP2Box)this.next();
        if (!(box instanceof CompOptionsBox)) {
            this._repInfo.setMessage(new ErrorMessage("First box in Composition Box must be Composition Options Box", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        long sizeLeft = this._boxHeader.getDataLength() - box.getLength();
        if (!box.readBox()) {
            return false;
        }
        while (this.hasNext() && (box = (JP2Box)this.next()) != null) {
            if (box instanceof InstructionSetBox) {
                if (box.readBox()) continue;
                return false;
            }
            box.skipBox();
        }
        if (sizeLeft != 0L) {
            this.superboxUnderrun();
            return false;
        }
        this.finalizeBytesRead();
        ArrayList<Property> propList = new ArrayList<Property>(4);
        propList.add(new Property("Width", PropertyType.LONG, new Long(this._width)));
        propList.add(new Property("Height", PropertyType.LONG, new Long(this._height)));
        propList.add(new Property("Loop", PropertyType.INTEGER, new Integer(this._loop)));
        if (!this.instSets.isEmpty()) {
            propList.add(new Property("InstructionSets", PropertyType.PROPERTY, PropertyArity.LIST, this.instSets));
        }
        this._module.addProperty(new Property("Composition", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }

    protected void addInstSet(Property p) {
        this.instSets.add(p);
    }

    protected void setHeight(long h2) {
        this._height = h2;
    }

    protected void setWidth(long w) {
        this._width = w;
    }

    protected void setLoop(int l) {
        this._loop = l;
    }
}

