/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentInputStream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FragmentListBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class CrossRefBox
extends JP2Box {
    DataInputStream fragStream;

    public CrossRefBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof CodestreamHeaderBox || this._parentBox instanceof ComposLayerHdrBox || this._parentBox instanceof AssociationBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        this._module.read4Chars(this._dstrm);
        this.bytesLeft -= 4L;
        JP2Box box = null;
        if (this.hasNext()) {
            box = (JP2Box)this.next();
        }
        if (!(box instanceof FragmentListBox)) {
            this._repInfo.setMessage(new ErrorMessage("Cross Reference Box does not contain Fragment List Box", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        box.readBox();
        List fragList = ((FragmentListBox)box).getFragmentList();
        JhoveBase base = this._module.getBase();
        int bufSize = base.getBufferSize();
        this.fragStream = new DataInputStream(new FragmentInputStream(fragList, this._raf, bufSize));
        this.finalizeBytesRead();
        return false;
    }

    public DataInputStream getCrossRefStream() {
        return this.fragStream;
    }

    @Override
    protected String getSelfPropName() {
        return "Cross Reference Box";
    }
}

