/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class FileTypeBox
extends JP2Box {
    public FileTypeBox(RandomAccessFile raf) {
        super(raf);
    }

    public FileTypeBox(RandomAccessFile raf, JP2Box parent) {
        super(raf);
    }

    @Override
    public boolean readBox() throws IOException {
        String brand = this._module.read4Chars(this._dstrm);
        this._module.addProperty(new Property("Brand", PropertyType.STRING, brand));
        if (!"jp2 ".equals(brand)) {
            this._module.setJP2Compliant(false);
        }
        if (!"jpx ".equals(brand)) {
            this._module.setJPXCompliant(false);
        }
        long minv = this._module.readUnsignedInt(this._dstrm);
        this._module.addProperty(new Property("MinorVersion", PropertyType.LONG, new Long(minv)));
        int ncomp = ((int)this._boxHeader.getLength() - 16) / 4;
        if (ncomp < 1) {
            this._repInfo.setMessage(new ErrorMessage("Empty compatibility list in File Type Box", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        ArrayList<String> compList = new ArrayList<String>(ncomp);
        boolean eflag = false;
        StringBuffer hexcitem = new StringBuffer(8);
        for (int i = 0; i < ncomp; ++i) {
            String citem = this._module.read4Chars(this._dstrm);
            char[] cbytes = citem.toCharArray();
            boolean binflag = false;
            for (int j = 0; j < cbytes.length; ++j) {
                char ch = cbytes[j];
                hexcitem.append(Integer.toHexString(ch));
                if (ch != '\u0000' && ch < '\u007f') continue;
                binflag = true;
                if (eflag) continue;
                eflag = true;
                this._repInfo.setValid(false);
                this._repInfo.setMessage(new ErrorMessage("Non-ASCII characters in compatibility item of File Type Box", this._module.getFilePos()));
            }
            if (!binflag) {
                compList.add(citem);
                continue;
            }
            compList.add(this.hexifyString(citem));
        }
        this._module.addProperty(new Property("Compatibility", PropertyType.STRING, PropertyArity.LIST, compList));
        return true;
    }

    private String hexifyString(String s2) {
        StringBuffer retval = new StringBuffer(2 * s2.length() + 2);
        retval.append("0X");
        char[] chs = s2.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            String hs = Integer.toHexString(chs[i]);
            if (hs.length() == 1) {
                retval.append('0');
            }
            retval.append(hs);
        }
        return retval.toString();
    }

    @Override
    protected String getSelfPropName() {
        return "File Type Box";
    }
}

