/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NumberListBox
extends JP2Box {
    private Property[] propArray;

    public NumberListBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        int numEntries = (int)this._boxHeader.getDataLength() / 4;
        if (numEntries > 0) {
            this.propArray = new Property[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                long num = this._module.readUnsignedInt(this._dstrm);
                int typeByte = (int)((num & 0xFF000000L) >> 24);
                int numValue = (int)(num & 0xFFFFFFL);
                App app = this._module.getApp();
                Property[] p = new Property[]{this._module.addIntegerProperty("Type", typeByte, JP2Strings.numberListTypeStr), new Property("Value", PropertyType.INTEGER, new Integer(numValue))};
                this.propArray[i] = new Property("Number", PropertyType.PROPERTY, PropertyArity.ARRAY, p);
            }
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected Property getSelfPropDesc() {
        if (this.propArray != null) {
            return new Property("Description", PropertyType.PROPERTY, PropertyArity.ARRAY, this.propArray);
        }
        return null;
    }

    @Override
    protected String getSelfPropName() {
        return "Number List Box";
    }
}

