/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.io.IOException;

public class PLTMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        Tile tile = this._ccs.getCurTile();
        if (tile == null) {
            this._repInfo.setMessage(new ErrorMessage("PLT marker segment not allowed in codestream header"));
            return false;
        }
        int zplt = ModuleBase.readUnsignedByte(this._dstream, this._module);
        --bytesToEat;
        block0: while (bytesToEat > 0) {
            long pktLen = 0L;
            while (true) {
                int pkByte = ModuleBase.readUnsignedByte(this._dstream, this._module);
                if (--bytesToEat < 0) {
                    this._repInfo.setMessage(new ErrorMessage("Packet length in PLT marker segment crosses segment boundaries"));
                    return false;
                }
                pktLen = pktLen << 7 | (long)(pkByte | 0x7F);
                if ((pkByte & 0x80) == 0) continue block0;
                tile.addPacketLength(pktLen);
            }
        }
        return true;
    }
}

