/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;

public class POCMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int nChanges;
        int compIdxBytes = this.nCompBytes();
        if (compIdxBytes == 0) {
            this._repInfo.setMessage(new ErrorMessage("POC marker segment at wrong position in codestream"));
            return false;
        }
        int changeSize = compIdxBytes < 257 ? 7 : 9;
        if (changeSize * (nChanges = bytesToEat / changeSize) != bytesToEat) {
            this._repInfo.setMessage(new ErrorMessage("Invalid size for POC marker segment"));
            return false;
        }
        Property[] changes = new Property[nChanges];
        for (int i = 0; i < nChanges; ++i) {
            int rspoc = this._module.readUnsignedShort(this._dstream);
            int cspoc = compIdxBytes < 257 ? ModuleBase.readUnsignedByte(this._dstream, this._module) : this._module.readUnsignedShort(this._dstream);
            int lyepoc = this._module.readUnsignedShort(this._dstream);
            int repoc = ModuleBase.readUnsignedByte(this._dstream, this._module);
            int cepoc = compIdxBytes < 257 ? ModuleBase.readUnsignedByte(this._dstream, this._module) : this._module.readUnsignedShort(this._dstream);
            int ppoc = ModuleBase.readUnsignedByte(this._dstream, this._module);
            Property[] propArr = new Property[]{new Property("StartResolutionLevelIndex", PropertyType.INTEGER, new Integer(rspoc)), new Property("ComponentIndex", PropertyType.INTEGER, new Integer(cspoc)), new Property("LayerIndex", PropertyType.INTEGER, new Integer(lyepoc)), new Property("EndResolutionLevelIndex", PropertyType.INTEGER, new Integer(cepoc)), new Property("ProgressionOrder", PropertyType.INTEGER, new Integer(ppoc))};
            changes[i] = new Property("Change", PropertyType.PROPERTY, PropertyArity.ARRAY, propArr);
        }
        MainOrTile cs = this.getMainOrTile();
        cs.setPOCProperty(new Property("ProgressionOrderChange", PropertyType.PROPERTY, PropertyArity.ARRAY, changes));
        return true;
    }
}

