/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.io.IOException;

public class PPTMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        if (this._ccs.isPPMSeen()) {
            this._repInfo.setMessage(new ErrorMessage("PPT and PPM not allowed in same codestream"));
            return false;
        }
        Tile tile = this._ccs.getCurTile();
        if (tile == null) {
            this._repInfo.setMessage(new ErrorMessage("PPT not allowed in codestream header"));
            return false;
        }
        int zppt = ModuleBase.readUnsignedByte(this._dstream, this._module);
        --bytesToEat;
        while (bytesToEat > 0) {
            long nppt = this._module.readUnsignedInt(this._dstream);
            if (nppt > (long)(bytesToEat -= 4)) {
                this._repInfo.setMessage(new ErrorMessage("Invalid length for tile-part header in PPM packet"));
                return false;
            }
            tile.addPPTLength(nppt);
            this._module.skipBytes(this._dstream, (int)nppt, this._module);
            bytesToEat = (int)((long)bytesToEat - nppt);
        }
        return true;
    }
}

