/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;

public class TLMMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int ztlm = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int stlm = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int st = (stlm & 0x30) >> 4;
        int sp = (stlm & 0x40) >> 6;
        int partLength = sp == 1 ? 4 : 2;
        switch (st) {
            case 1: {
                ++partLength;
                break;
            }
            case 2: {
                partLength += 2;
                break;
            }
            case 3: {
                this._repInfo.setMessage(new ErrorMessage("Invalid ST value in TLM marker segment"));
                return false;
            }
        }
        int nParts = (bytesToEat - 2) / partLength;
        if (nParts * partLength != bytesToEat - 2) {
            return false;
        }
        if (this._ccs.getCurTile() != null) {
            return false;
        }
        for (int i = 0; i < nParts; ++i) {
            ArrayList<Property> tpList = new ArrayList<Property>(2);
            if (st != 0) {
                int ttlm = st == 1 ? ModuleBase.readUnsignedByte(this._dstream, this._module) : this._module.readUnsignedShort(this._dstream);
                tpList.add(new Property("Index", PropertyType.INTEGER, new Integer(ttlm)));
            }
            int length = sp == 1 ? (int)this._module.readUnsignedInt(this._dstream) : this._module.readUnsignedShort(this._dstream);
            tpList.add(new Property("Length", PropertyType.INTEGER, new Integer(length)));
            this._cs.addTileLength(new Property("TilePartLength", PropertyType.PROPERTY, PropertyArity.LIST, tpList));
        }
        return true;
    }
}

