/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.State;
import edu.harvard.hul.ois.jhove.module.pdf.StringValuedToken;
import edu.harvard.hul.ois.jhove.module.pdf.Tokenizer;
import java.io.EOFException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class Literal
extends StringValuedToken {
    private boolean _pdfDocEncoding = true;
    private StringBuffer rawHex = new StringBuffer();
    private StringBuffer buffer = new StringBuffer();
    private boolean haveHi = false;
    private int hi;
    int b1;
    private State _state;
    private boolean _pdfACompliant;
    private int _parenLevel;
    public static char[] PDFDOCENCODING = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u02d8', '\u02c7', '\u02c6', '\u02d9', '\u02dd', '\u02db', '\u02da', '\u02dc', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u2022', '\u2020', '\u2021', '\u2026', '\u2003', '\u2002', '\u0192', '\u2044', '\u2039', '\u203a', '\u2212', '\u2030', '\u201e', '\u201c', '\u201d', '\u2018', '\u2019', '\u201a', '\u2122', '\ufb01', '\ufb02', '\u0141', '\u0152', '\u0160', '\u0178', '\u017d', '\u0131', '\u0142', '\u0153', '\u0161', '\u017e', '\u009f', '\u20ac', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ef', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int BS = 8;
    private static final int HT = 9;
    private static final int FORMFEED = 12;
    private static final int ESC = 27;
    private static final int OPEN_PARENTHESIS = 40;
    private static final int CLOSE_PARENTHESIS = 41;
    private static final int BACKSLASH = 92;
    private static final int FE = 254;
    private static final int FF = 255;

    public void appendHex(int ch) throws PdfException {
        if (this._rawBytes == null) {
            this._rawBytes = new Vector(32);
        }
        if (this.haveHi) {
            this._rawBytes.add(new Integer(Literal.hexToInt(this.hi, ch)));
            this.haveHi = false;
        } else {
            this.hi = ch;
            this.haveHi = true;
        }
    }

    public long processLiteral(Tokenizer tok) throws IOException {
        int utfch = 0;
        int b1 = 0;
        this._parenLevel = 0;
        this._rawBytes = new Vector(32);
        this._state = State.LITERAL;
        long offset = 0L;
        while (true) {
            int ch;
            if ((ch = tok.readChar()) < 0) {
                throw new EOFException("Unterminated literal in PDF file");
            }
            ++offset;
            this._rawBytes.add(new Integer(ch));
            if (this._state == State.LITERAL) {
                if (ch == 254) {
                    this._state = State.LITERAL_FE;
                    continue;
                }
                if (ch == 41 && --this._parenLevel < 0) {
                    this.setPDFDocEncoding(true);
                    this.setValue(this.buffer.toString());
                    return offset;
                }
                if (ch == 92) {
                    ch = this.readBackslashSequence(false, tok);
                    if (ch == 0) continue;
                    if (ch == 254) {
                        this._state = State.LITERAL_FE;
                        continue;
                    }
                    this.setPDFDocEncoding(true);
                    this.buffer.append(PDFDOCENCODING[ch]);
                    continue;
                }
                if (ch == 40) {
                    ++this._parenLevel;
                }
                this._state = State.LITERAL_PDF;
                this.setPDFDocEncoding(true);
                this.buffer.append(PDFDOCENCODING[ch]);
                continue;
            }
            if (this._state == State.LITERAL_FE) {
                if (ch == 255) {
                    this._state = State.LITERAL_UTF16_1;
                    this.setPDFDocEncoding(false);
                    continue;
                }
                if (ch == 92) {
                    ch = this.readBackslashSequence(false, tok);
                    if (ch == 0) continue;
                    if (ch == 255) {
                        this._state = State.LITERAL_UTF16_1;
                        this.setPDFDocEncoding(false);
                        continue;
                    }
                    this.setPDFDocEncoding(true);
                    this.buffer.append(PDFDOCENCODING[254]);
                    this.buffer.append(PDFDOCENCODING[ch]);
                    continue;
                }
                this._state = State.LITERAL_PDF;
                this.setPDFDocEncoding(true);
                this.buffer.append(PDFDOCENCODING[254]);
                this.buffer.append(PDFDOCENCODING[ch]);
                continue;
            }
            if (this._state == State.LITERAL_PDF) {
                if (ch == 41 && --this._parenLevel < 0) {
                    this.setValue(this.buffer.toString());
                    return offset;
                }
                if (ch == 92) {
                    ch = this.readBackslashSequence(false, tok);
                    if (ch == 0) continue;
                    this.buffer.append(PDFDOCENCODING[ch]);
                    continue;
                }
                this.buffer.append(PDFDOCENCODING[ch]);
                continue;
            }
            if (this._state == State.LITERAL_UTF16_1) {
                if (ch == 41) {
                    this.setValue(this.buffer.toString());
                    return offset;
                }
                if (ch == 92) {
                    utfch = this.readBackslashSequence(true, tok);
                    if (utfch != 0) continue;
                    continue;
                }
                this._state = State.LITERAL_UTF16_2;
                b1 = ch;
                continue;
            }
            if (this._state != State.LITERAL_UTF16_2) continue;
            utfch = 256 * b1 + ch;
            this._state = State.LITERAL_UTF16_1;
            if (utfch == 27) {
                this.readUTFLanguageCode(tok);
                continue;
            }
            if (utfch == 92 && (utfch = this.readBackslashSequence(false, tok)) == 0) continue;
            this.buffer.append((char)utfch);
        }
    }

    public void convertHex() throws PdfException {
        if (this._rawBytes != null) {
            boolean utf = false;
            StringBuffer buffer = new StringBuffer();
            if (this.haveHi) {
                this._rawBytes.add(new Integer(Literal.hexToInt(this.hi, 48)));
            }
            if (this._rawBytes.size() >= 2 && this.rawByte(0) == 254 && this.rawByte(1) == 255) {
                utf = true;
            }
            if (utf) {
                for (int i = 2; i < this._rawBytes.size(); i += 2) {
                    buffer.append((char)(this.rawByte(i) * 256 + this.rawByte(i + 1)));
                }
            } else {
                for (int i = 0; i < this._rawBytes.size(); ++i) {
                    buffer.append(Tokenizer.PDFDOCENCODING[this.rawByte(i)]);
                }
            }
            this._value = buffer.toString();
        }
    }

    private static int hexToInt(int c1, int c2) throws PdfException {
        return 16 * Literal.hexValue(c1) + Literal.hexValue(c2);
    }

    private static int hexValue(int h2) throws PdfException {
        int d = 0;
        if (48 <= h2 && h2 <= 57) {
            d = h2 - 48;
        } else if (65 <= h2 && h2 <= 70) {
            d = h2 - 55;
        } else if (97 <= h2 && h2 <= 102) {
            d = h2 - 87;
        } else {
            throw new PdfMalformedException("Invalid character in hex string");
        }
        return d;
    }

    private int rawByte(int idx) {
        if (idx >= this._rawBytes.size()) {
            return 0;
        }
        return (Integer)this._rawBytes.elementAt(idx);
    }

    public boolean isPDFDocEncoding() {
        return this._pdfDocEncoding;
    }

    public void setPDFDocEncoding(boolean pdfDocEncoding) {
        this._pdfDocEncoding = pdfDocEncoding;
    }

    public boolean isDate() {
        return this.parseDate() != null;
    }

    public Date parseDate() {
        int datestate;
        Calendar cal;
        int timezoneminute;
        int timezonehour;
        char timezonechar;
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        block32: {
            year = 0;
            month = 0;
            day = 0;
            hour = 0;
            minute = 0;
            second = 0;
            timezonechar = '?';
            timezonehour = 0;
            timezoneminute = 0;
            cal = null;
            String str = this.getValue();
            if (str == null) {
                return null;
            }
            if ((str = str.trim()).length() < 4) {
                return null;
            }
            datestate = 0;
            int charidx = 0;
            try {
                while (charidx < str.length()) {
                    switch (datestate) {
                        case 0: {
                            if ("D:".equals(str.substring(charidx, charidx + 2))) {
                                charidx += 2;
                            }
                            datestate = 1;
                            break;
                        }
                        case 1: {
                            year = Integer.parseInt(str.substring(charidx, charidx + 4));
                            charidx += 4;
                            datestate = 2;
                            break;
                        }
                        case 2: {
                            month = Integer.parseInt(str.substring(charidx, charidx + 2));
                            charidx += 2;
                            datestate = 3;
                            break;
                        }
                        case 3: {
                            day = Integer.parseInt(str.substring(charidx, charidx + 2));
                            if (day < 1 || day > 31) {
                                return null;
                            }
                            charidx += 2;
                            datestate = 4;
                            break;
                        }
                        case 4: {
                            hour = Integer.parseInt(str.substring(charidx, charidx + 2));
                            charidx += 2;
                            datestate = 5;
                            break;
                        }
                        case 5: {
                            minute = Integer.parseInt(str.substring(charidx, charidx + 2));
                            charidx += 2;
                            datestate = 6;
                            break;
                        }
                        case 6: {
                            second = Integer.parseInt(str.substring(charidx, charidx + 2));
                            charidx += 2;
                            datestate = 7;
                            break;
                        }
                        case 7: {
                            timezonechar = str.charAt(charidx);
                            if (timezonechar != 'Z' && timezonechar != '+' && timezonechar != '-') {
                                return null;
                            }
                            ++charidx;
                            datestate = 8;
                            break;
                        }
                        case 8: {
                            if (timezonechar == '+' || timezonechar == '-') {
                                timezonehour = Integer.parseInt(str.substring(charidx, charidx + 2));
                                if (timezonechar == '-') {
                                    timezonehour = -timezonehour;
                                }
                                if (!str.substring(charidx + 2, charidx + 3).equals("'")) {
                                    return null;
                                }
                                charidx += 3;
                            }
                            datestate = 9;
                            break;
                        }
                        case 9: {
                            if (timezonechar == '+' || timezonechar == '-') {
                                if (str.charAt(charidx) == '\'') {
                                    timezoneminute = Integer.parseInt(str.substring(charidx, charidx + 2));
                                }
                                if (timezonechar == '-') {
                                    timezoneminute = -timezoneminute;
                                }
                                if (!str.substring(charidx + 2, charidx + 3).equals("'")) {
                                    return null;
                                }
                            }
                            break block32;
                        }
                    }
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if (datestate < 2) {
            return null;
        }
        if (timezonechar != '?') {
            String tzStr = "GMT";
            if (timezonechar == 'Z') {
                tzStr = tzStr + "+0000";
            } else {
                tzStr = tzStr + timezonechar;
                NumberFormat nfmt = NumberFormat.getInstance();
                nfmt.setMinimumIntegerDigits(2);
                nfmt.setMaximumIntegerDigits(2);
                tzStr = tzStr + nfmt.format(timezonehour);
                tzStr = tzStr + nfmt.format(timezoneminute);
            }
            TimeZone tz = TimeZone.getTimeZone(tzStr);
            cal = Calendar.getInstance(tz);
        } else {
            cal = Calendar.getInstance();
        }
        cal.set(year, month - 1, day, hour, minute, second);
        return cal.getTime();
    }

    public boolean isPDFACompliant() {
        return this._pdfACompliant;
    }

    private int readBackslashSequence(boolean utf16, Tokenizer tok) throws IOException {
        int ch = tok.readChar1(utf16);
        if (ch >= 48 && ch <= 55) {
            int num = ch - 48;
            for (int i = 0; i < 2; ++i) {
                int ch1 = tok.readChar1(utf16);
                if (ch1 < 48 || ch1 > 55) {
                    tok.backupChar();
                    this._pdfACompliant = false;
                    return num;
                }
                num = num * 8 + (ch1 - 48);
            }
            return num;
        }
        switch (ch) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 104: {
                return 8;
            }
            case 102: {
                return 12;
            }
            case 40: {
                return 40;
            }
            case 41: {
                return 41;
            }
            case 92: {
                return 92;
            }
        }
        return 0;
    }

    private void readUTFLanguageCode(Tokenizer tok) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        while ((ch = tok.readChar1(true)) != 27) {
            sb.append((char)ch);
        }
        tok.addLanguageCode(sb.toString());
    }
}

