/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.StdStructTypes;
import edu.harvard.hul.ois.jhove.module.pdf.StructureTree;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;

public class StructureElement {
    private StructureTree _tree;
    private PdfDictionary _dict;
    private PdfModule _module;
    private List<StructureElement> children;
    private String _structType;
    private boolean _structIsInline;
    private boolean _attrIsBlock;
    private Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");
    private static final String[] blockLevelAttrs = new String[]{"SpaceBefore", "SpaceAfter", "StartIndent", "EndIndent", "TextIndent", "TextAlign", "BBox", "Width", "Height", "BlockAlign", "InlineAlign"};

    public StructureElement(PdfDictionary dict, StructureTree tree) throws PdfException {
        this._tree = tree;
        this._dict = dict;
        this._module = tree.getModule();
        this._structType = null;
        try {
            PdfObject s2 = this._module.resolveIndirectObject(dict.get("S"));
            Token tok = ((PdfSimpleObject)s2).getToken();
            String st = ((Name)tok).getValue();
            st = this._tree.dereferenceStructType(st);
            if (StdStructTypes.includes(st)) {
                this._structType = st;
            }
        }
        catch (IOException e) {
            this._logger.warning(e.getClass().getName());
        }
    }

    public void buildSubtree() throws PdfException {
        this._logger.info("Building subtree");
        PdfObject k = null;
        try {
            k = this._module.resolveIndirectObject(this._dict.get("K"));
        }
        catch (IOException e) {
            throw new PdfInvalidException("Invalid data in document structure tree");
        }
        this.children = null;
        if (k instanceof PdfSimpleObject) {
            return;
        }
        if (k instanceof PdfDictionary) {
            this._logger.info("Type K element is dictionary");
            PdfDictionary kdict = (PdfDictionary)k;
            if (this.isStructElem(kdict)) {
                PdfSimpleObject kids;
                Token tok2;
                PdfObject kidsObject = kdict.get("K");
                if (kidsObject instanceof PdfSimpleObject && (tok2 = (kids = (PdfSimpleObject)kidsObject).getToken()) instanceof Numeric && ((Numeric)tok2).getValue() == 0.0) {
                    this.children = null;
                    return;
                }
                StructureElement se = new StructureElement(kdict, this._tree);
                se.buildSubtree();
                se.checkAttributes();
                this.children = new ArrayList<StructureElement>(1);
                this.children.add(se);
            } else if (!this.isMarkedContent(kdict) && !this.isObjectRef(kdict)) {
                throw new PdfInvalidException("Unknown element in structure tree");
            }
        } else if (k instanceof PdfArray) {
            this._logger.info("Type K element is an array");
            Vector<PdfObject> kvec = ((PdfArray)k).getContent();
            this.children = new LinkedList<StructureElement>();
            for (int i = 0; i < kvec.size(); ++i) {
                PdfSimpleObject kids;
                Token tok;
                PdfDictionary kdict;
                PdfObject kelem = kvec.elementAt(i);
                try {
                    kelem = this._module.resolveIndirectObject(kelem);
                }
                catch (IOException tok2) {
                    // empty catch block
                }
                if (!(kelem instanceof PdfDictionary) || !this.isStructElem(kdict = (PdfDictionary)kelem)) continue;
                this._logger.info("Building subtree");
                PdfObject kidsObject = kdict.get("K");
                if (kidsObject instanceof PdfSimpleObject && (tok = (kids = (PdfSimpleObject)kidsObject).getToken()) instanceof Numeric && ((Numeric)tok).getValue() == 0.0) {
                    this._logger.info("No child objects, exiting");
                    this.children = null;
                    return;
                }
                StructureElement se = new StructureElement(kdict, this._tree);
                se.buildSubtree();
                se.checkAttributes();
                this.children.add(se);
            }
            if (this.children.isEmpty()) {
                this._logger.info("No children are structure elements");
                this.children = null;
            }
        }
        if (this._tree.isTransient()) {
            this.children = null;
        }
    }

    public void checkAttributes() throws PdfException {
        PdfObject attr;
        String badattr = "Invalid structure attribute";
        this._attrIsBlock = false;
        this._structIsInline = !this._structType.equals("Figure") && !this._structType.equals("TH") && !this._structType.equals("TD") && !this._structType.equals("TR") && !StdStructTypes.isBlockLevel(this._structType);
        try {
            attr = this._module.resolveIndirectObject(this._dict.get("A"));
        }
        catch (Exception e) {
            throw new PdfInvalidException("Invalid structure attribute reference");
        }
        if (attr == null) {
            return;
        }
        if (attr instanceof PdfArray) {
            Vector<PdfObject> attrVec = ((PdfArray)attr).getContent();
            for (int i = 0; i < attrVec.size(); ++i) {
                PdfObject attrElem;
                try {
                    attrElem = this._module.resolveIndirectObject(attrVec.elementAt(i));
                }
                catch (IOException e) {
                    this._logger.info("IOException on attribute");
                    throw new PdfInvalidException("Invalid structure attribute");
                }
                if (attrElem instanceof PdfDictionary) {
                    this.checkAttribute((PdfDictionary)attrElem);
                    continue;
                }
                if (attrElem instanceof PdfSimpleObject) {
                    try {
                        Numeric e = (Numeric)((PdfSimpleObject)attrElem).getToken();
                        continue;
                    }
                    catch (Exception e) {
                        this._logger.info("Exception getting revision number: " + e.getClass().getName());
                        throw new PdfInvalidException("Invalid structure attribute");
                    }
                }
                throw new PdfInvalidException("Invalid structure attribute");
            }
        } else if (attr instanceof PdfDictionary) {
            this.checkAttribute((PdfDictionary)attr);
        } else {
            throw new PdfInvalidException("Structure attribute has illegal type");
        }
        if (this._structIsInline && this._attrIsBlock) {
            throw new PdfInvalidException("Block-level attributes in inline structure element");
        }
    }

    private void checkAttribute(PdfDictionary attr) throws PdfException {
        try {
            PdfSimpleObject placement = (PdfSimpleObject)attr.get("Placement");
            if (placement != null && !"Inline".equals(placement.getStringValue())) {
                this._structIsInline = false;
            }
            if (this.attrIsBlockLevel(attr)) {
                this._attrIsBlock = true;
            }
        }
        catch (Exception e) {
            throw new PdfInvalidException("Invalid attribute in document structure");
        }
    }

    private boolean isStructElem(PdfDictionary elem) throws PdfException {
        try {
            String typename;
            PdfObject typ = elem.get("Type");
            if (typ != null && !"StructElem".equals(((PdfSimpleObject)typ).getStringValue())) {
                return false;
            }
            PdfObject s2 = this._module.resolveIndirectObject(elem.get("S"));
            if (!(s2 instanceof PdfSimpleObject)) {
                return false;
            }
            Token tok = ((PdfSimpleObject)s2).getToken();
            if (!(tok instanceof Name)) {
                return false;
            }
            boolean checkStandardTypes = false;
            String st = ((Name)tok).getValue();
            if (!StdStructTypes.includes(st = this._tree.dereferenceStructType(st)) && checkStandardTypes) {
                throw new PdfInvalidException("Non-standard structure type name");
            }
            PdfObject pref = elem.get("P");
            if (!(pref instanceof PdfIndirectObj)) {
                return false;
            }
            PdfDictionary p = (PdfDictionary)this._module.resolveIndirectObject(pref);
            PdfSimpleObject ptype = (PdfSimpleObject)p.get("Type");
            return ptype == null || "StructTreeRoot".equals(typename = ptype.getStringValue()) || "StructElem".equals(typename);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean attrIsBlockLevel(PdfDictionary attrDict) {
        for (int i = 0; i < blockLevelAttrs.length; ++i) {
            if (attrDict.get(blockLevelAttrs[i]) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isMarkedContent(PdfDictionary dict) {
        try {
            PdfSimpleObject typeObj = (PdfSimpleObject)dict.get("Type");
            if (!typeObj.getStringValue().equals("MCR")) {
                return false;
            }
            PdfSimpleObject mcidObj = (PdfSimpleObject)this._module.resolveIndirectObject(dict.get("MCID"));
            return mcidObj != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isObjectRef(PdfDictionary dict) {
        try {
            PdfSimpleObject typeObj = (PdfSimpleObject)dict.get("Type");
            if (!typeObj.getStringValue().equals("OBJR")) {
                return false;
            }
            PdfObject obj = this._module.resolveIndirectObject(dict.get("Obj"));
            return obj != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

